/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent;

import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import whatap.agent.ClassDesc;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.asm.CapArgsASM;
import whatap.agent.asm.CapReturnASM;
import whatap.agent.asm.CapReturnLoginASM;
import whatap.agent.asm.CapReturnWClientIDASM;
import whatap.agent.asm.CapThisASM;
import whatap.agent.asm.CollectionHolderASM;
import whatap.agent.asm.CompletableFutureASM;
import whatap.agent.asm.ConnectionPoolASM;
import whatap.agent.asm.CustomLeakCloseASM;
import whatap.agent.asm.CustomLeakOpenASM;
import whatap.agent.asm.DebugMethodASM;
import whatap.agent.asm.DynaMethodASM;
import whatap.agent.asm.DynaServiceASM;
import whatap.agent.asm.ExceptionCreateASM;
import whatap.agent.asm.FileOpenASM;
import whatap.agent.asm.GtidArgsASM;
import whatap.agent.asm.GtidReturnASM;
import whatap.agent.asm.HttpJakartaASM;
import whatap.agent.asm.HttpServiceASM;
import whatap.agent.asm.HttpValveASM;
import whatap.agent.asm.HttpcASM;
import whatap.agent.asm.HttpcNameASM;
import whatap.agent.asm.IASM;
import whatap.agent.asm.JDBCCallableStatementASM;
import whatap.agent.asm.JDBCConnectionCloseASM;
import whatap.agent.asm.JDBCConnectionNativeASM;
import whatap.agent.asm.JDBCConnectionOpenASM;
import whatap.agent.asm.JDBCDriverManagerOpenASM;
import whatap.agent.asm.JDBCPreparedStatementASM;
import whatap.agent.asm.JDBCResultSetASM;
import whatap.agent.asm.JDBCStatementASM;
import whatap.agent.asm.JspServletASM;
import whatap.agent.asm.MethodASM;
import whatap.agent.asm.MethodComponentASM;
import whatap.agent.asm.MethodErrorASM;
import whatap.agent.asm.MethodLogASM;
import whatap.agent.asm.MethodStatASM;
import whatap.agent.asm.ServiceASM;
import whatap.agent.asm.ServiceBackgroundASM;
import whatap.agent.asm.SocketASM;
import whatap.agent.asm.SpringExceptionHandlerASM;
import whatap.agent.asm.ThreadStartASM;
import whatap.agent.asm.TraceHelperASM;
import whatap.agent.asm.TraceHelperEndASM;
import whatap.agent.asm.TraceHelperStartASM;
import whatap.agent.asm.TraceNameASM;
import whatap.agent.asm.WhaTapClassWriter;
import whatap.agent.asm.etc.AsyncWrapSubTxASM;
import whatap.agent.asm.logsink.LogBackASM;
import whatap.agent.asm.logsink.LogCustomASM;
import whatap.agent.asm.logsink.LogSinkLog4jASM;
import whatap.agent.asm.logsink.LoggerUtilASM;
import whatap.agent.asm.logsink.TomcatLogASM;
import whatap.agent.asm.reactor.MethodReactorASM;
import whatap.agent.asm.reactor.ServiceReactorASM;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.asm.weaving.WeaveMain;
import whatap.agent.conf.ConfHook;
import whatap.agent.proxy.SqlTraceFactory;
import whatap.agent.trace.sql.TraceSQL;
import whatap.agent.util.AsyncRunner;
import whatap.lang.STOP;
import whatap.lang.conf.ConfObserver;
import whatap.org.objectweb.asm.ClassReader;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.ClassWriter;
import whatap.util.FileUtil;
import whatap.util.IntSet;
import whatap.util.SystemUtil;

public class AgentTransformer
implements ClassFileTransformer {
    public static ThreadLocal<ClassLoader> hookingCtx = new ThreadLocal();
    private static AgentTransformer instance;
    public List<IASM> asms = new ArrayList<IASM>();
    private int hook_signature;
    private IntSet asynchook = new IntSet();
    public static String hookingClass;
    private static int hook_err_stack;

    public static synchronized AgentTransformer getInstance() {
        if (instance == null) {
            instance = new AgentTransformer();
        }
        return instance;
    }

    private AgentTransformer() {
        Configure.getInstance();
        this.reload();
        this.hook_signature = ConfHook.getHookSignature();
        ConfObserver.add("AgentTransformer", new Runnable(){

            public void run() {
                if (ConfHook.getHookSignature() != AgentTransformer.this.hook_signature) {
                    AgentTransformer.this.reload();
                }
                AgentTransformer.this.hook_signature = ConfHook.getHookSignature();
            }
        });
        if (ConfHook._enable_asm_async) {
            this.asynchook.put("sun/net/www/protocol/http/HttpURLConnection".hashCode());
            this.asynchook.put("sun/net/www/http/HttpClient".hashCode());
            this.asynchook.put("java/net/Socket".hashCode());
            this.asynchook.put("java/io/FileInputStream".hashCode());
            this.asynchook.put("java/io/FileOutputStream".hashCode());
            this.asynchook.put("java/lang/Thread".hashCode());
            this.asynchook.put("java/sql/DriverManager".hashCode());
            this.asynchook.put("java/util/logging/Logger".hashCode());
            this.asynchook.put("java/util/logging/LogRecord".hashCode());
        }
    }

    public void reload() {
        ArrayList<IASM> temp = new ArrayList<IASM>();
        if (ConfHook._enable_asm_http) {
            temp.add(new TraceNameASM());
            temp.add(new GtidArgsASM());
            temp.add(new GtidReturnASM());
            temp.add(new HttpServiceASM());
            temp.add(new HttpJakartaASM());
            temp.add(new HttpValveASM());
        }
        if (ConfHook._enable_asm_nonhttp) {
            temp.add(new ServiceASM());
            temp.add(new ServiceReactorASM());
            temp.add(new ServiceBackgroundASM());
        }
        if (ConfHook._enable_asm_jdbc) {
            temp.add(new JDBCCallableStatementASM());
            temp.add(new JDBCPreparedStatementASM());
            temp.add(new JDBCStatementASM());
            temp.add(new JDBCResultSetASM());
            temp.add(new JDBCConnectionOpenASM());
            temp.add(new JDBCConnectionCloseASM());
            temp.add(new JDBCConnectionNativeASM());
            temp.add(new ConnectionPoolASM());
            if (ConfHook.hook_drivermanager_enabled) {
                temp.add(new JDBCDriverManagerOpenASM());
            }
        }
        if (ConfHook._enable_asm_httpc) {
            temp.add(new HttpcNameASM());
            temp.add(new HttpcASM());
            temp.add(new SocketASM());
        }
        if (ConfHook._enable_asm_method) {
            temp.add(new MethodLogASM());
            temp.add(new MethodASM());
            temp.add(new MethodStatASM());
            temp.add(new JspServletASM());
            temp.add(new CapArgsASM());
            temp.add(new CapReturnASM());
            temp.add(new CapReturnWClientIDASM());
            temp.add(new CapReturnLoginASM());
            temp.add(new CapThisASM());
            temp.add(new MethodErrorASM());
            temp.add(new DebugMethodASM());
            temp.add(new MethodComponentASM());
        }
        if (ConfHook._enable_asm_etc) {
            temp.add(new TraceHelperASM());
            temp.add(new TraceHelperStartASM());
            temp.add(new TraceHelperEndASM());
            temp.add(new FileOpenASM());
            temp.add(new SpringExceptionHandlerASM());
            temp.add(new CustomLeakOpenASM());
            temp.add(new CustomLeakCloseASM());
            temp.add(new CollectionHolderASM());
            temp.add(new CompletableFutureASM());
            temp.add(new ExceptionCreateASM());
        }
        if (ConfHook._enable_asm_dyna) {
            temp.add(new DynaServiceASM());
            temp.add(new DynaMethodASM());
            if (ConfHook._has_async_supplier) {
                temp.add(new AsyncWrapSubTxASM("Ljava/util/function/Supplier;", ConfHook.hook_async_supplier_patterns, ConfHook.hook_async_supplier_point));
            }
            if (ConfHook._has_async_runnable) {
                temp.add(new AsyncWrapSubTxASM("Ljava/lang/Runnable;", ConfHook.hook_async_runnable_patterns, ConfHook.hook_async_runnable_point));
            }
            if (ConfHook._has_async_consumer) {
                temp.add(new AsyncWrapSubTxASM("Ljava/util/function/Consumer;", ConfHook.hook_async_consumer_patterns, ConfHook.hook_async_consumer_point));
            }
            if (ConfHook._has_async_future) {
                temp.add(new AsyncWrapSubTxASM("Ljava/util/concurrent/Future;", ConfHook.hook_async_future_patterns, ConfHook.hook_async_future_point));
            }
            if (ConfHook._has_async_function) {
                temp.add(new AsyncWrapSubTxASM("Ljava/util/function/Function;", ConfHook.hook_async_function_patterns, ConfHook.hook_async_function_point));
            }
        }
        if (ConfHook.hooklog_enabled) {
            temp.add(new LogBackASM());
            temp.add(new TomcatLogASM());
            temp.add(new LogCustomASM());
            temp.add(new LogSinkLog4jASM());
            temp.add(new LoggerUtilASM());
        }
        if (ConfHook.hook_thread_start_enabled) {
            temp.add(new ThreadStartASM());
        }
        if (ConfHook.hook_reactor_methods_enabled) {
            temp.add(new MethodReactorASM());
        }
        this.asms = temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            ClassWriter cw;
            hookingCtx.set(loader);
            if (className == null) {
                byte[] byArray = null;
                return byArray;
            }
            if (classBeingRedefined == null) {
                if (this.asynchook.contains(className.hashCode())) {
                    AsyncRunner.getInstance().add(loader, className, classfileBuffer);
                    byte[] byArray = null;
                    return byArray;
                }
                if (loader == null) {
                    byte[] byArray = null;
                    return byArray;
                }
            }
            if (this.ignoreInstrument(className, loader == null)) {
                byte[] byArray = null;
                return byArray;
            }
            if (SystemUtil.IS_JAVA_OVER9() && TraceSQL.isql == SqlTraceFactory.java8 && ("java/sql/Driver".equals(className) || "java/sql/Connection".equals(className))) {
                TraceSQL.isql = SqlTraceFactory.create(loader);
            }
            final ClassDesc classDesc = new ClassDesc();
            ClassReader cr = new ClassReader(classfileBuffer);
            cr.accept(new ClassVisitor(IASM.API){

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    super.visit(version, access, name, signature, superName, interfaces);
                    classDesc.version = version;
                    classDesc.access = access;
                    classDesc.name = name;
                    classDesc.superName = superName;
                    classDesc.interfaces = interfaces;
                }
            }, 0);
            classDesc.classBeingRedefined = classBeingRedefined;
            if (AsmUtil.isInterface(cr.getAccess())) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] originClassfileBuffer = classfileBuffer;
            if (WeaveMain.hasWeave()) {
                classfileBuffer = WeaveMain.weaving(loader, classfileBuffer, classDesc);
            }
            hookingClass = className;
            ClassVisitor cv = cw = AgentTransformer.getClassWriter(classDesc);
            List<IASM> workAsms = this.asms;
            int max = workAsms.size();
            for (int i = 0; i < max; ++i) {
                cv = workAsms.get(i).transform(cv, className, classDesc);
                if (cv == cw) continue;
                cr = new ClassReader(classfileBuffer);
                cr.accept(cv, 8);
                classfileBuffer = cw.toByteArray();
                cv = cw = AgentTransformer.getClassWriter(classDesc);
            }
            if (ConfHook.hook_dump_enabled && classfileBuffer != null && originClassfileBuffer != classfileBuffer) {
                try {
                    File dumpFile = new File(ConfHook.getDumpBase(), className.replace('/', '.') + ".class");
                    FileUtil.save(dumpFile, classfileBuffer);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            byte[] byArray = classfileBuffer;
            return byArray;
        }
        catch (STOP classDesc) {
        }
        catch (Throwable t) {
            if (ConfHook.debug_hook_error_enabled || hook_err_stack > 0) {
                --hook_err_stack;
                Logger.println("ClassFileTransformer", "Transformer " + className + " " + t, t);
            } else {
                Logger.println("ClassFileTransformer", 10, "Transformer " + className + " " + t);
            }
        }
        finally {
            hookingCtx.set(null);
        }
        return null;
    }

    public boolean ignoreInstrument(String className, boolean isBoot) {
        if (className.startsWith("whatap/")) {
            return !className.startsWith("whatap/v1/");
        }
        if (className.startsWith("org/hyperic/")) {
            return true;
        }
        if (ConfHook.isBciIgnorePackages(className)) {
            return true;
        }
        if (ConfHook.hook_ignore_classes.hasKey(className)) {
            return true;
        }
        return isBoot && !this.asynchook.contains(className.hashCode());
    }

    public static ClassWriter getClassWriter(ClassDesc classDesc) {
        WhaTapClassWriter cw;
        switch (classDesc.version) {
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 196653: {
                cw = new WhaTapClassWriter(1);
                break;
            }
            default: {
                cw = new WhaTapClassWriter(3);
            }
        }
        return cw;
    }

    static {
        hook_err_stack = 1;
    }
}

