/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import whatap.util.LinkedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedSeries<K, V> {
    private LinkedMap<K, TreeMap<Long, V>> table = new LinkedMap<K, TreeMap<Long, V>>(){

        @Override
        protected TreeMap<Long, V> create(K key) {
            return new TreeMap();
        }
    };
    private long minTime = Long.MAX_VALUE;
    private long maxTime = Long.MIN_VALUE;

    public void add(K key, long time, V value) {
        TreeMap<Long, V> tree = this.table.intern(key);
        tree.put(time, value);
        if (time > this.maxTime) {
            this.maxTime = time;
        }
        if (time < this.minTime) {
            this.minTime = time;
        }
    }

    public LinkedMap<K, V> getInTimeList(long time) {
        return this.getInTimeList(time, Long.MAX_VALUE - time);
    }

    public LinkedMap<K, V> getInTimeList(long time, long valid) {
        LinkedMap<K, V> out = new LinkedMap<K, V>();
        Enumeration<LinkedMap.LinkedEntry<K, TreeMap<Long, V>>> en = this.table.entries();
        while (en.hasMoreElements()) {
            LinkedMap.LinkedEntry<K, TreeMap<Long, V>> bt = en.nextElement();
            Map.Entry<Long, V> ent = bt.getValue().ceilingEntry(time);
            if (ent == null || time + valid < ent.getKey()) continue;
            out.put(bt.getKey(), ent.getValue());
        }
        return out;
    }

    public V get(K key, long time) {
        return this.getInTime(key, time, Long.MAX_VALUE - time);
    }

    public V getInTime(K key, long time, long valid) {
        Map.Entry<Long, V> entry;
        TreeMap<Long, V> series = this.table.get(key);
        if (series != null && (entry = series.ceilingEntry(time)) != null && time + valid >= entry.getKey()) {
            return entry.getValue();
        }
        return null;
    }

    public int getSeriesCount() {
        return this.table.size();
    }

    public long getMinTime() {
        return this.minTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public Enumeration<K> getNameEnumer() {
        return this.table.keys();
    }
}

