/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import whatap.util.FileUtil;
import whatap.util.StringEnumer;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringList;
import whatap.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringProperty
extends StringKeyLinkedMap<String> {
    private static final String EMPTY = "__empty__";

    public StringProperty(int initCapacity, float loadFactor) {
        super(initCapacity, loadFactor);
    }

    public StringProperty() {
    }

    public StringList getNames() {
        StringList _keys = new StringList();
        StringEnumer en = this.keys();
        while (en.hasMoreElements()) {
            String key = en.nextString();
            if (key.startsWith(EMPTY)) continue;
            _keys.add(key);
        }
        return _keys;
    }

    public synchronized StringProperty load(File file) {
        this.clear();
        this.load0(this.loadText(file));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List<String> loadText(File file) {
        BufferedReader reader;
        ArrayList<String> out;
        block8: {
            out = new ArrayList<String>();
            reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(file));
                StringBuffer buffer = new StringBuffer();
                while ((line = reader.readLine()) != null) {
                    if ((line = StringUtil.trim(line)).startsWith("#")) {
                        out.add(line);
                        continue;
                    }
                    if (line.endsWith("\\")) {
                        buffer.append(line.substring(0, line.length() - 1));
                        continue;
                    }
                    if (buffer.length() == 0) {
                        out.add(line);
                        continue;
                    }
                    buffer.append(line);
                    out.add(buffer.toString());
                    buffer = new StringBuffer();
                }
                if (buffer.length() <= 0) break block8;
                out.add(buffer.toString());
            }
            catch (Throwable throwable) {
                FileUtil.close(reader);
                catch (Throwable throwable2) {
                    FileUtil.close(reader);
                    throw throwable2;
                }
            }
        }
        FileUtil.close(reader);
        return out;
    }

    private void load0(List<String> arr) {
        for (String line : arr) {
            if (line == null) continue;
            if (line.startsWith("#") || line.length() == 0) {
                this.put(EMPTY + this.size(), line);
                continue;
            }
            String[] keyVal = StringUtil.divKeyValue(line, "=");
            if (keyVal.length == 1) {
                this.put(EMPTY + this.size(), line);
                continue;
            }
            if (keyVal.length != 2) continue;
            this.put(keyVal[0].trim(), keyVal[1].trim());
        }
    }

    @Override
    public String toString() {
        String separator = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        StringEnumer en = this.keys();
        while (en.hasMoreElements()) {
            String key = en.nextString();
            String value = (String)this.get(key);
            if (sb.length() > 0) {
                sb.append(separator);
            }
            if (key.startsWith(EMPTY)) {
                sb.append(value);
                continue;
            }
            sb.append(key).append(" = ").append(value);
        }
        return sb.toString();
    }

    public StringProperty putAll(StringProperty p) {
        String[] keys;
        if (p == null) {
            return null;
        }
        for (String key : keys = p.keyArray()) {
            String value = (String)p.get(key);
            if (key.startsWith(EMPTY)) {
                this.put(EMPTY + this.size(), value);
                continue;
            }
            this.put(key, value);
        }
        return this;
    }
}

