/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Queue<V> {
    private V[] queue;
    private int head = 0;
    private int tail = 0;
    private int count = 0;

    public Queue(int capacity) {
        this.queue = new Object[capacity + 1];
    }

    public synchronized V push(V item) {
        this.queue[this.head] = item;
        this.inchead();
        if (this.head == this.tail) {
            this.inctail();
            return null;
        }
        ++this.count;
        return item;
    }

    public synchronized V pop() {
        if (this.head != this.tail) {
            V o = this.queue[this.tail];
            this.queue[this.tail] = null;
            this.inctail();
            --this.count;
            return o;
        }
        return null;
    }

    public synchronized V[] pop(int n) {
        Object[] out = new Object[n];
        for (int i = 0; i < n && this.head != this.tail; ++i) {
            out[i] = this.queue[this.tail];
            this.queue[this.tail] = null;
            this.inctail();
            --this.count;
        }
        return out;
    }

    public synchronized V[] popAll() {
        int n = this.count;
        Object[] out = new Object[n];
        for (int i = 0; i < n && this.head != this.tail; ++i) {
            out[i] = this.queue[this.tail];
            this.queue[this.tail] = null;
            this.inctail();
            --this.count;
        }
        return out;
    }

    public synchronized void clear() {
        this.count = 0;
        this.tail = 0;
        this.head = 0;
    }

    public int size() {
        return this.count;
    }

    public V enqueue(V item) {
        return this.push(item);
    }

    public V dequeue() {
        return this.pop();
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean isFull() {
        return this.count >= this.queue.length - 1;
    }

    private void inchead() {
        ++this.head;
        if (this.head >= this.queue.length) {
            this.head = 0;
        }
    }

    private void inctail() {
        ++this.tail;
        if (this.tail >= this.queue.length) {
            this.tail = 0;
        }
    }

    public static void main(String[] args) {
        Queue<Integer> q = new Queue<Integer>(4);
        q.push(1);
        System.out.println("full ? " + q.isFull());
        q.push(2);
        System.out.println("full ? " + q.isFull());
        q.push(2);
        System.out.println("full ? " + q.isFull());
        q.push(2);
        System.out.println("full ? " + q.isFull());
        q.push(2);
        System.out.println("full ? " + q.isFull());
        Queue.print("out = ", q.pop(q.size()));
        Queue.print("out = ", q.pop(q.size()));
        Queue.print("out = ", q.pop(q.size()));
    }

    private static void print(String msg, Object[] pop) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pop.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(pop[i]);
        }
        System.out.println(msg + sb);
    }
}

