/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.util.CompareUtil;
import whatap.util.LongEnumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongLongLinkedMap {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private LongLongLinkedEntry[] table;
    private LongLongLinkedEntry header;
    private int count;
    private int threshold;
    private float loadFactor;
    private long NONE = 0L;
    private int max;

    public LongLongLinkedMap setNullValue(int none) {
        this.NONE = none;
        return this;
    }

    public LongLongLinkedMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new LongLongLinkedEntry[initCapacity];
        this.header.link_next = this.header.link_prev = (this.header = new LongLongLinkedEntry(0L, 0L, null));
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public LongLongLinkedMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public long[] keyArray() {
        long[] _keys = new long[this.size()];
        LongEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextLong();
        }
        return _keys;
    }

    public synchronized LongEnumer keys() {
        return new Enumer(1);
    }

    public synchronized LongEnumer values() {
        return new Enumer(2);
    }

    public synchronized Enumeration<LongLongLinkedEntry> entries() {
        return new Enumer(3);
    }

    public synchronized boolean containsValue(long value) {
        LongLongLinkedEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            LongLongLinkedEntry e = tab[i];
            while (e != null) {
                if (CompareUtil.equals(e.value, value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(long key) {
        LongLongLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongLongLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized long get(long key) {
        LongLongLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongLongLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return e.value;
            }
            e = e.next;
        }
        return this.NONE;
    }

    public synchronized long getFirstKey() {
        return this.header.link_next.key;
    }

    public synchronized long getLastKey() {
        return this.header.link_prev.key;
    }

    public synchronized long getFirstValue() {
        return this.header.link_next.value;
    }

    public synchronized long getLastValue() {
        return this.header.link_prev.value;
    }

    private int hash(long key) {
        return (int)(key ^ key >>> 32) & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        LongLongLinkedEntry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        LongLongLinkedEntry[] newMap = new LongLongLinkedEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            LongLongLinkedEntry old = oldMap[i];
            while (old != null) {
                LongLongLinkedEntry e = old;
                old = old.next;
                long key = e.key;
                int index = this.hash(key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public LongLongLinkedMap setMax(int max) {
        this.max = max;
        return this;
    }

    public long put(long key, long value) {
        return this._put(key, value, 4);
    }

    public long putLast(long key, long value) {
        return this._put(key, value, 2);
    }

    public long putFirst(long key, long value) {
        return this._put(key, value, 1);
    }

    private synchronized long _put(long key, long value, int m) {
        LongLongLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongLongLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                long old = e.value;
                e.value = value;
                switch (m) {
                    case 1: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case 2: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return old;
            }
            e = e.next;
        }
        if (this.max > 0) {
            switch (m) {
                case 1: 
                case 3: {
                    while (this.count >= this.max) {
                        long k = this.header.link_prev.key;
                        long v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case 2: 
                case 4: {
                    while (this.count >= this.max) {
                        long k = this.header.link_next.key;
                        long v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new LongLongLinkedEntry(key, value, tab[index]);
        switch (m) {
            case 1: 
            case 3: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case 2: 
            case 4: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return this.NONE;
    }

    public long add(long key, long value) {
        return this._add(key, value, 4);
    }

    public long addLast(long key, long value) {
        return this._add(key, value, 2);
    }

    public long addFirst(long key, long value) {
        return this._add(key, value, 1);
    }

    private synchronized long _add(long key, long value, int m) {
        LongLongLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongLongLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                e.value += value;
                return e.value;
            }
            e = e.next;
        }
        if (this.max > 0) {
            switch (m) {
                case 1: 
                case 3: {
                    while (this.count >= this.max) {
                        this.removeLast();
                    }
                    break;
                }
                case 2: 
                case 4: {
                    while (this.count >= this.max) {
                        this.removeFirst();
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new LongLongLinkedEntry(key, value, tab[index]);
        switch (m) {
            case 1: 
            case 3: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case 2: 
            case 4: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return this.NONE;
    }

    private void overflowed(long k, long v) {
    }

    public synchronized long remove(long key) {
        LongLongLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        LongLongLinkedEntry e = tab[index];
        LongLongLinkedEntry prev = null;
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                long oldValue = e.value;
                e.value = this.NONE;
                this.unchain(e);
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return this.NONE;
    }

    public synchronized long removeFirst() {
        if (this.isEmpty()) {
            return 0L;
        }
        return this.remove(this.header.link_next.key);
    }

    public synchronized long removeLast() {
        if (this.isEmpty()) {
            return 0L;
        }
        return this.remove(this.header.link_prev.key);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isFull() {
        return this.max > 0 && this.max <= this.count;
    }

    public synchronized void clear() {
        LongLongLinkedEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.header.link_next = this.header.link_prev = this.header;
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<LongLongLinkedEntry> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            LongLongLinkedEntry e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<LongLongLinkedEntry> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            LongLongLinkedEntry e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    private void chain(LongLongLinkedEntry link_prev, LongLongLinkedEntry link_next, LongLongLinkedEntry e) {
        e.link_prev = link_prev;
        e.link_next = link_next;
        link_prev.link_next = e;
        link_next.link_prev = e;
    }

    private void unchain(LongLongLinkedEntry e) {
        e.link_prev.link_next = e.link_next;
        e.link_next.link_prev = e.link_prev;
        e.link_prev = null;
        e.link_next = null;
    }

    public void toBytes(DataOutputX dout) {
        dout.writeDecimal(this.size());
        Enumeration<LongLongLinkedEntry> en = this.entries();
        while (en.hasMoreElements()) {
            LongLongLinkedEntry e = en.nextElement();
            dout.writeDecimal(e.getKey());
            dout.writeDecimal(e.getValue());
        }
    }

    public LongLongLinkedMap toObject(DataInputX in) {
        int cnt = (int)in.readDecimal();
        for (int i = 0; i < cnt; ++i) {
            long key = in.readDecimal();
            long value = in.readDecimal();
            this.put(key, value);
        }
        return this;
    }

    public synchronized void sort(Comparator<LongLongLinkedEntry> c) {
        ArrayList<LongLongLinkedEntry> list = new ArrayList<LongLongLinkedEntry>(this.size());
        Enumeration<LongLongLinkedEntry> en = this.entries();
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
        }
        Collections.sort(list, c);
        this.clear();
        for (int i = 0; i < list.size(); ++i) {
            LongLongLinkedEntry e = (LongLongLinkedEntry)list.get(i);
            this.put(e.getKey(), e.getValue());
        }
    }

    public static void main(String[] args) {
        LongLongLinkedMap m = new LongLongLinkedMap();
        LongEnumer e = m.keys();
        System.out.println(e.nextLong());
        System.out.println(e.nextLong());
        System.out.println(e.nextLong());
        System.out.println(e.nextLong());
    }

    private static void print(Object e) {
        System.out.println(e);
    }

    public static class LongLongLinkedEntry {
        long key;
        long value;
        LongLongLinkedEntry next;
        LongLongLinkedEntry link_next;
        LongLongLinkedEntry link_prev;

        protected LongLongLinkedEntry(long key, long value, LongLongLinkedEntry next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new LongLongLinkedEntry(this.key, this.value, this.next == null ? null : (LongLongLinkedEntry)this.next.clone());
        }

        public long getKey() {
            return this.key;
        }

        public long getValue() {
            return this.value;
        }

        public long setValue(long value) {
            long oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LongLongLinkedEntry)) {
                return false;
            }
            LongLongLinkedEntry e = (LongLongLinkedEntry)o;
            return CompareUtil.equals(e.key, this.key) && CompareUtil.equals(e.value, this.value);
        }

        public int hashCode() {
            return (int)(this.key ^ this.key >>> 32) ^ (int)(this.value ^ this.value >>> 32);
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Enumer<V>
    implements Enumeration,
    LongEnumer {
        byte type;
        LongLongLinkedEntry entry;

        Enumer(byte type) {
            this.entry = ((LongLongLinkedMap)LongLongLinkedMap.this).header.link_next;
            this.type = type;
        }

        @Override
        public boolean hasMoreElements() {
            return LongLongLinkedMap.this.header != this.entry && this.entry != null;
        }

        public V nextElement() {
            if (this.hasMoreElements()) {
                LongLongLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case 1: {
                        return (V)new Long(e.key);
                    }
                    case 2: {
                        return (V)new Long(e.value);
                    }
                }
                return (V)e;
            }
            throw new NoSuchElementException("no more next");
        }

        @Override
        public long nextLong() {
            if (this.hasMoreElements()) {
                LongLongLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case 1: {
                        return e.key;
                    }
                    case 2: {
                        return e.value;
                    }
                }
                return LongLongLinkedMap.this.NONE;
            }
            throw new NoSuchElementException("no more next");
        }
    }
}

