/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.util.CompareUtil;
import whatap.util.IntEnumer;
import whatap.util.IntLinkedSet;
import whatap.util.LongEnumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntLongLinkedMap {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private IntLongLinkedEntry[] table;
    private IntLongLinkedEntry header;
    private int count;
    private int threshold;
    private float loadFactor;
    private int NONE = 0;
    private int max;

    public IntLongLinkedMap setNullValue(int none) {
        this.NONE = none;
        return this;
    }

    public IntLongLinkedMap(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new IntLongLinkedEntry[initCapacity];
        this.header.link_next = this.header.link_prev = (this.header = new IntLongLinkedEntry(0, 0L, null));
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public IntLongLinkedMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public int[] keyArray() {
        int[] _keys = new int[this.size()];
        IntEnumer en = this.keys();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextInt();
        }
        return _keys;
    }

    public IntLinkedSet getKeySet() {
        IntLinkedSet _keys = new IntLinkedSet(this.size() + 1, 1.0f);
        IntEnumer en = this.keys();
        while (en.hasMoreElements()) {
            _keys.put(en.nextInt());
        }
        return _keys;
    }

    public synchronized IntEnumer keys() {
        return new Enumer(1);
    }

    public synchronized LongEnumer values() {
        return new Enumer(2);
    }

    public synchronized Enumeration<IntLongLinkedEntry> entries() {
        return new Enumer(3);
    }

    public synchronized boolean containsValue(int value) {
        IntLongLinkedEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            IntLongLinkedEntry e = tab[i];
            while (e != null) {
                if (CompareUtil.equals(e.value, (long)value)) {
                    return true;
                }
                e = e.hash_next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(int key) {
        IntLongLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntLongLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return true;
            }
            e = e.hash_next;
        }
        return false;
    }

    public synchronized long get(int key) {
        IntLongLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntLongLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return e.value;
            }
            e = e.hash_next;
        }
        return this.NONE;
    }

    public synchronized int getFirstKey() {
        return this.header.link_next.key;
    }

    public synchronized int getLastKey() {
        return this.header.link_prev.key;
    }

    public synchronized long getFirstValue() {
        return this.header.link_next.value;
    }

    public synchronized long getLastValue() {
        return this.header.link_prev.value;
    }

    private int hash(int key) {
        return key & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        IntLongLinkedEntry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        IntLongLinkedEntry[] newMap = new IntLongLinkedEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            IntLongLinkedEntry old = oldMap[i];
            while (old != null) {
                IntLongLinkedEntry e = old;
                old = old.hash_next;
                int key = e.key;
                int index = this.hash(key) % newCapacity;
                e.hash_next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public IntLongLinkedMap setMax(int max) {
        this.max = max;
        return this;
    }

    public long put(int key, long value) {
        return this._put(key, value, 4);
    }

    public long putLast(int key, long value) {
        return this._put(key, value, 2);
    }

    public long putFirst(int key, long value) {
        return this._put(key, value, 1);
    }

    private synchronized long _put(int key, long value, int m) {
        IntLongLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntLongLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                long old = e.value;
                e.value = value;
                switch (m) {
                    case 1: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case 2: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return old;
            }
            e = e.hash_next;
        }
        if (this.max > 0) {
            switch (m) {
                case 1: 
                case 3: {
                    while (this.count >= this.max) {
                        int k = this.header.link_prev.key;
                        long v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case 2: 
                case 4: {
                    while (this.count >= this.max) {
                        int k = this.header.link_next.key;
                        long v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new IntLongLinkedEntry(key, value, tab[index]);
        switch (m) {
            case 1: 
            case 3: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case 2: 
            case 4: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return this.NONE;
    }

    public void putIfNull(int key, long value) {
        this.add(key, 0L);
    }

    protected void overflowed(int key, long value) {
    }

    public long add(int key, long value) {
        return this._add(key, value, 4);
    }

    private synchronized long _add(int key, long value, int m) {
        IntLongLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntLongLinkedEntry e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                e.value += value;
                return e.value;
            }
            e = e.hash_next;
        }
        if (this.max > 0) {
            switch (m) {
                case 1: 
                case 3: {
                    while (this.count >= this.max) {
                        int k = this.header.link_prev.key;
                        long v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
                case 2: 
                case 4: {
                    while (this.count >= this.max) {
                        int k = this.header.link_next.key;
                        long v = this.remove(k);
                        this.overflowed(k, v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        tab[index] = e = new IntLongLinkedEntry(key, value, tab[index]);
        switch (m) {
            case 1: 
            case 3: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case 2: 
            case 4: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return this.NONE;
    }

    public synchronized long remove(int key) {
        IntLongLinkedEntry[] tab = this.table;
        int index = this.hash(key) % tab.length;
        IntLongLinkedEntry e = tab[index];
        IntLongLinkedEntry prev = null;
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                if (prev != null) {
                    prev.hash_next = e.hash_next;
                } else {
                    tab[index] = e.hash_next;
                }
                --this.count;
                long oldValue = e.value;
                e.value = this.NONE;
                this.unchain(e);
                return oldValue;
            }
            prev = e;
            e = e.hash_next;
        }
        return this.NONE;
    }

    public synchronized long removeFirst() {
        if (this.isEmpty()) {
            return 0L;
        }
        return this.remove(this.header.link_next.key);
    }

    public synchronized long removeLast() {
        if (this.isEmpty()) {
            return 0L;
        }
        return this.remove(this.header.link_prev.key);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized void clear() {
        IntLongLinkedEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.header.link_next = this.header;
        this.header.link_prev = this.header;
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<IntLongLinkedEntry> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            IntLongLinkedEntry e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<IntLongLinkedEntry> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            IntLongLinkedEntry e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    private void chain(IntLongLinkedEntry link_prev, IntLongLinkedEntry link_next, IntLongLinkedEntry e) {
        e.link_prev = link_prev;
        e.link_next = link_next;
        link_prev.link_next = e;
        link_next.link_prev = e;
    }

    private void unchain(IntLongLinkedEntry e) {
        e.link_prev.link_next = e.link_next;
        e.link_next.link_prev = e.link_prev;
        e.link_prev = null;
        e.link_next = null;
    }

    public void toBytes(DataOutputX dout) {
        dout.writeDecimal(this.size());
        Enumeration<IntLongLinkedEntry> en = this.entries();
        while (en.hasMoreElements()) {
            IntLongLinkedEntry e = en.nextElement();
            dout.writeDecimal(e.getKey());
            dout.writeDecimal(e.getValue());
        }
    }

    public IntLongLinkedMap toObject(DataInputX in) {
        int cnt = (int)in.readDecimal();
        for (int i = 0; i < cnt; ++i) {
            int key = (int)in.readDecimal();
            long value = in.readDecimal();
            this.put(key, value);
        }
        return this;
    }

    public synchronized void sort(Comparator<IntLongLinkedEntry> c) {
        ArrayList<IntLongLinkedEntry> list = new ArrayList<IntLongLinkedEntry>(this.size());
        Enumeration<IntLongLinkedEntry> en = this.entries();
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
        }
        Collections.sort(list, c);
        this.clear();
        for (int i = 0; i < list.size(); ++i) {
            IntLongLinkedEntry e = (IntLongLinkedEntry)list.get(i);
            this.put(e.getKey(), e.getValue());
        }
    }

    public static void main(String[] args) {
        IntLongLinkedMap m = new IntLongLinkedMap().setMax(6);
        for (int i = 0; i < 10; ++i) {
            m.put(i, i);
            System.out.println(m);
        }
        System.out.println();
        System.out.println(m);
        System.out.println("==================================");
        IntEnumer en = m.keys();
        while (en.hasMoreElements()) {
            m.remove(5);
            System.out.println(en.nextInt());
        }
    }

    private static void print(Object e) {
        System.out.println(e);
    }

    public static class IntLongLinkedEntry {
        int key;
        long value;
        IntLongLinkedEntry hash_next;
        IntLongLinkedEntry link_next;
        IntLongLinkedEntry link_prev;

        protected IntLongLinkedEntry(int key, long value, IntLongLinkedEntry next) {
            this.key = key;
            this.value = value;
            this.hash_next = next;
        }

        protected Object clone() {
            return new IntLongLinkedEntry(this.key, this.value, this.hash_next == null ? null : (IntLongLinkedEntry)this.hash_next.clone());
        }

        public int getKey() {
            return this.key;
        }

        public long getValue() {
            return this.value;
        }

        public long setValue(long value) {
            long oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IntLongLinkedEntry)) {
                return false;
            }
            IntLongLinkedEntry e = (IntLongLinkedEntry)o;
            return CompareUtil.equals(e.key, this.key) && CompareUtil.equals(e.value, this.value);
        }

        public int hashCode() {
            return this.key ^ (int)(this.value ^ this.value >>> 32);
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Enumer<V>
    implements Enumeration,
    IntEnumer,
    LongEnumer {
        byte type;
        IntLongLinkedEntry entry;

        Enumer(byte type) {
            this.entry = ((IntLongLinkedMap)IntLongLinkedMap.this).header.link_next;
            this.type = type;
        }

        @Override
        public boolean hasMoreElements() {
            return this.entry != null && IntLongLinkedMap.this.header != this.entry;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                IntLongLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case 1: {
                        return e.key;
                    }
                    case 2: {
                        return e.value;
                    }
                }
                return e;
            }
            throw new NoSuchElementException("no more next");
        }

        @Override
        public int nextInt() {
            if (this.hasMoreElements()) {
                IntLongLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case 1: {
                        return e.key;
                    }
                }
            }
            throw new NoSuchElementException("no more next");
        }

        @Override
        public long nextLong() {
            if (this.hasMoreElements()) {
                IntLongLinkedEntry e = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case 2: {
                        return e.value;
                    }
                }
            }
            throw new NoSuchElementException("no more next");
        }
    }
}

