/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.TimeZone;
import whatap.util.DateUtil;
import whatap.util.StringKeyLinkedMap;

public class DateTimeHelper {
    public static final int MILLIS_PER_SECOND = 1000;
    public static final int MILLIS_PER_MINUTE = 60000;
    public static final int MILLIS_PER_FIVE_MINUTE = 300000;
    public static final int MILLIS_PER_TEN_MINUTE = 600000;
    public static final int MILLIS_PER_HOUR = 3600000;
    public static final int MILLIS_PER_DAY = 86400000;
    static String[] wday = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
    static int[] mdayLen = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private long BASE_TIME;
    private Day[][][] table = new Day[100][][];
    private Day[] dateTable = new Day[40000];
    private int LAST_DATE;
    private static StringKeyLinkedMap<DateTimeHelper> _table = new StringKeyLinkedMap().setMax(5);

    private DateTimeHelper() {
        try {
            this.BASE_TIME = 946684800000L;
            this.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private DateTimeHelper(TimeZone zone) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            sdf.setTimeZone(zone);
            this.BASE_TIME = sdf.parse("20000101").getTime();
            this.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long getBaseTime() {
        return this.BASE_TIME;
    }

    private void open() throws Exception {
        long mtime = this.BASE_TIME;
        int seq = 0;
        int wdayIdx = 5;
        for (int year = 0; year < 100; ++year) {
            boolean isYun = DateTimeHelper.isYun(year);
            this.table[year] = new Day[12][];
            for (int mm = 0; mm < 12; ++mm) {
                int monLen = mdayLen[mm];
                if (mm == 1 && isYun) {
                    ++monLen;
                }
                this.table[year][mm] = new Day[monLen];
                for (int dd = 0; dd < monLen; ++dd) {
                    String yyyyMMdd = String.format("%d%02d%02d", year + 2000, mm + 1, dd + 1);
                    this.dateTable[seq] = new Day(yyyyMMdd, year + 2000, mm + 1, dd + 1, wday[wdayIdx], mtime);
                    this.table[year][mm][dd] = this.dateTable[seq];
                    wdayIdx = wdayIdx == 6 ? 0 : wdayIdx + 1;
                    ++seq;
                    mtime += 86400000L;
                }
            }
        }
        this.LAST_DATE = seq - 1;
    }

    static boolean isYun(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public long yyyymmdd(String yyyyMMdd) {
        int year = Integer.parseInt(yyyyMMdd.substring(0, 4));
        int mm = Integer.parseInt(yyyyMMdd.substring(4, 6));
        int dd = Integer.parseInt(yyyyMMdd.substring(6, 8));
        if (year >= 2100) {
            return this.table[99][11][30].time + 86400000L;
        }
        if (year < 2000) {
            return this.BASE_TIME;
        }
        return this.table[year - 2000][mm - 1][dd - 1].time;
    }

    public long hhmm(String date) {
        if (date == null) {
            return 0L;
        }
        int h = Integer.parseInt(date.substring(0, 2));
        int m = Integer.parseInt(date.substring(2, 4));
        return h * 3600000 + m * 60000;
    }

    public String getWeekDay(String yyyyMMdd) {
        int year = Integer.parseInt(yyyyMMdd.substring(0, 4));
        int mm = Integer.parseInt(yyyyMMdd.substring(4, 6));
        int dd = Integer.parseInt(yyyyMMdd.substring(6, 8));
        if (year >= 2100) {
            return this.table[99][11][30].wday;
        }
        if (year < 2000) {
            return this.table[0][0][0].wday;
        }
        return this.table[year - 2000][mm - 1][dd - 1].wday;
    }

    public String yyyymmdd(long time) {
        int idx = (int)((time - this.BASE_TIME) / 86400000L);
        if (idx < 0) {
            idx = 0;
        }
        return this.dateTable[idx].date;
    }

    public String weekday(long time) {
        int idx = (int)((time - this.BASE_TIME) / 86400000L);
        if (idx < 0) {
            idx = 0;
        }
        return this.dateTable[idx].wday;
    }

    public String datetime(long time) {
        if (time < this.BASE_TIME) {
            return "20000101 00:00:00";
        }
        int idx = (int)((time - this.BASE_TIME) / 86400000L);
        long dtime = (time - this.BASE_TIME) % 86400000L;
        int hh = (int)(dtime / 3600000L);
        dtime = (int)(dtime % 3600000L);
        int mm = (int)(dtime / 60000L);
        dtime = (int)(dtime % 60000L);
        int ss = (int)(dtime / 1000L);
        StringBuffer sb = new StringBuffer();
        sb.append(this.dateTable[idx].date).append(" ");
        sb.append(this.mk2(hh)).append(":");
        sb.append(this.mk2(mm)).append(":");
        sb.append(this.mk2(ss));
        return sb.toString();
    }

    public String timestamp(long time) {
        if (time < this.BASE_TIME) {
            return "20000101 00:00:00.000";
        }
        int idx = (int)((time - this.BASE_TIME) / 86400000L);
        long dtime = (time - this.BASE_TIME) % 86400000L;
        int hh = (int)(dtime / 3600000L);
        dtime = (int)(dtime % 3600000L);
        int mm = (int)(dtime / 60000L);
        dtime = (int)(dtime % 60000L);
        int ss = (int)(dtime / 1000L);
        int sss = (int)(dtime % 1000L);
        StringBuffer sb = new StringBuffer();
        sb.append(this.dateTable[idx].date).append(" ");
        sb.append(this.mk2(hh)).append(":");
        sb.append(this.mk2(mm)).append(":");
        sb.append(this.mk2(ss));
        sb.append(".").append(this.mk3(sss));
        return sb.toString();
    }

    private String mk2(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return "0" + n;
            }
        }
        return Integer.toString(n);
    }

    private String mk3(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return "00" + n;
            }
        }
        return n < 100 ? "0" + n : Integer.toString(n);
    }

    public String timestampFileName(long time) {
        if (time < this.BASE_TIME) {
            return "20000101_000000_000";
        }
        int idx = (int)((time - this.BASE_TIME) / 86400000L);
        long dtime = (time - this.BASE_TIME) % 86400000L;
        int hh = (int)(dtime / 3600000L);
        dtime = (int)(dtime % 3600000L);
        int mm = (int)(dtime / 60000L);
        dtime = (int)(dtime % 60000L);
        int ss = (int)(dtime / 1000L);
        int sss = (int)(dtime % 1000L);
        StringBuffer sb = new StringBuffer();
        sb.append(this.dateTable[idx].date).append("_");
        sb.append(this.mk2(hh));
        sb.append(this.mk2(mm));
        sb.append(this.mk2(ss));
        sb.append("_").append(this.mk3(sss));
        return sb.toString();
    }

    public String ymdhms(long time) {
        if (time < this.BASE_TIME) {
            return "20000101000000";
        }
        int idx = (int)((time - this.BASE_TIME) / 86400000L);
        long dtime = (time - this.BASE_TIME) % 86400000L;
        int hh = (int)(dtime / 3600000L);
        dtime = (int)(dtime % 3600000L);
        int mm = (int)(dtime / 60000L);
        dtime = (int)(dtime % 60000L);
        int ss = (int)(dtime / 1000L);
        StringBuffer sb = new StringBuffer();
        sb.append(this.dateTable[idx].date);
        sb.append(this.mk2(hh));
        sb.append(this.mk2(mm));
        sb.append(this.mk2(ss));
        return sb.toString();
    }

    public long getYear(long time, int delta) {
        if (time < this.BASE_TIME) {
            return this.BASE_TIME;
        }
        int idx = (int)((time - this.BASE_TIME) / 86400000L);
        int year = this.dateTable[idx].yyyy + delta;
        int mm = this.dateTable[idx].mm;
        int dd = this.dateTable[idx].dd;
        if (year < 2000) {
            return this.BASE_TIME;
        }
        if (year > 2100) {
            return this.dateTable[this.LAST_DATE].time;
        }
        long dtime = (time - this.BASE_TIME) % 86400000L;
        Day[] monthTable = this.table[year - 2000][mm - 1];
        if (monthTable.length > dd - 1) {
            return monthTable[dd - 1].time + dtime;
        }
        return monthTable[monthTable.length - 1].time + dtime;
    }

    public long getMonth(long time, int delta) {
        if (time < this.BASE_TIME) {
            return this.BASE_TIME;
        }
        int idx = (int)((time - this.BASE_TIME) / 86400000L);
        int year = this.dateTable[idx].yyyy;
        int mm = this.dateTable[idx].mm;
        int dd = this.dateTable[idx].dd;
        delta = delta + mm - 1;
        int deltaYear = delta / 12;
        int deltaMM = delta % 12;
        if (deltaMM < 0) {
            --deltaYear;
            deltaMM = 12 + deltaMM;
        }
        mm = deltaMM + 1;
        if ((year += deltaYear) < 2000) {
            return this.BASE_TIME;
        }
        if (year > 2100) {
            return this.dateTable[this.LAST_DATE].time;
        }
        long dtime = (time - this.BASE_TIME) % 86400000L;
        Day[] monthTable = this.table[year - 2000][mm - 1];
        if (monthTable.length > dd - 1) {
            return monthTable[dd - 1].time + dtime;
        }
        return monthTable[monthTable.length - 1].time + dtime;
    }

    public long getDate(long time, int delta) {
        if (time < this.BASE_TIME) {
            return this.BASE_TIME;
        }
        int idx = (int)((time - this.BASE_TIME) / 86400000L);
        long dtime = (time - this.BASE_TIME) % 86400000L;
        if ((idx += delta) < 0) {
            return this.BASE_TIME;
        }
        if (idx >= this.LAST_DATE) {
            return this.dateTable[this.LAST_DATE].time;
        }
        return this.dateTable[idx].time + dtime;
    }

    public String logtime(long time) {
        if (time < this.BASE_TIME) {
            return "00:00:00.000";
        }
        long dtime = (time - this.BASE_TIME) % 86400000L;
        int hh = (int)(dtime / 3600000L);
        dtime = (int)(dtime % 3600000L);
        int mm = (int)(dtime / 60000L);
        dtime = (int)(dtime % 60000L);
        int ss = (int)(dtime / 1000L);
        int sss = (int)(dtime % 1000L);
        StringBuffer sb = new StringBuffer();
        sb.append(this.mk2(hh)).append(":");
        sb.append(this.mk2(mm)).append(":");
        sb.append(this.mk2(ss));
        sb.append(".").append(this.mk3(sss));
        return sb.toString();
    }

    public String hhmmss(long time) {
        if (time < this.BASE_TIME) {
            return "000000";
        }
        long dtime = (time - this.BASE_TIME) % 86400000L;
        int hh = (int)(dtime / 3600000L);
        dtime = (int)(dtime % 3600000L);
        int mm = (int)(dtime / 60000L);
        dtime = (int)(dtime % 60000L);
        int ss = (int)(dtime / 1000L);
        return String.format("%02d%02d%02d", hh, mm, ss);
    }

    public String hhmm(long time) {
        if (time < this.BASE_TIME) {
            return "0000";
        }
        long dtime = (time - this.BASE_TIME) % 86400000L;
        int hh = (int)(dtime / 3600000L);
        dtime = (int)(dtime % 3600000L);
        int mm = (int)(dtime / 60000L);
        return String.format("%02d%02d", hh, mm);
    }

    public int getDateMillis(long time) {
        if (time < this.BASE_TIME) {
            return 0;
        }
        long dtime = (time - this.BASE_TIME) % 86400000L;
        return (int)dtime;
    }

    public long getDateStartTime(long time) {
        if (time < this.BASE_TIME) {
            return 0L;
        }
        long dtime = (time - this.BASE_TIME) % 86400000L;
        return time - dtime;
    }

    public int getHour(long time) {
        return this.getDateMillis(time) / 3600000;
    }

    public int getMM(long time) {
        int dtime = this.getDateMillis(time) % 3600000;
        return dtime / 60000;
    }

    public long getTimeUnit(long time) {
        return time - this.BASE_TIME;
    }

    public long getDateUnit(long time) {
        return (time - this.BASE_TIME) / 86400000L;
    }

    public long getTenMinUnit(long time) {
        return (time - this.BASE_TIME) / 600000L;
    }

    public long getFiveMinUnit(long time) {
        return (time - this.BASE_TIME) / 300000L;
    }

    public long getMinUnit(long time) {
        return (time - this.BASE_TIME) / 60000L;
    }

    public long getHourUnit(long time) {
        return (time - this.BASE_TIME) / 3600000L;
    }

    public long reverseHourUnit(long unit) {
        return unit * 3600000L + this.BASE_TIME;
    }

    public long reverseUnit(long unit, long millis) {
        return unit * millis + this.BASE_TIME;
    }

    public long getDateUnit() {
        return this.getDateUnit(DateUtil.currentTime());
    }

    public static synchronized DateTimeHelper getDateTimeHelper() {
        DateTimeHelper helper = _table.get("GMT");
        if (helper == null) {
            helper = new DateTimeHelper();
            _table.put("GMT", helper);
        }
        return helper;
    }

    public static synchronized DateTimeHelper getDateTimeHelper(TimeZone timezone) {
        DateTimeHelper helper = _table.get(timezone.getID());
        if (helper == null) {
            helper = new DateTimeHelper(timezone);
            _table.put(timezone.getID(), helper);
        }
        return helper;
    }

    public String loghms(long time) {
        if (time < this.BASE_TIME) {
            return "00:00:00";
        }
        long dtime = (time - this.BASE_TIME) % 86400000L;
        int hh = (int)(dtime / 3600000L);
        dtime = (int)(dtime % 3600000L);
        int mm = (int)(dtime / 60000L);
        dtime = (int)(dtime % 60000L);
        int ss = (int)(dtime / 1000L);
        StringBuffer sb = new StringBuffer();
        sb.append(this.mk2(hh)).append(":");
        sb.append(this.mk2(mm)).append(":");
        sb.append(this.mk2(ss));
        return sb.toString();
    }

    public long epochtime(int year, int month, int day, int hour, int minute, int second) {
        LocalDateTime localDateTime = LocalDateTime.of(year, month, day, hour, minute, second);
        Instant instant = localDateTime.toInstant(ZoneOffset.UTC);
        long time = instant.getEpochSecond();
        return time;
    }

    public String uptime(long time) {
        int day = (int)(time / 86400000L);
        int hour = (int)((time %= 86400000L) / 3600000L);
        int minute = (int)((time %= 3600000L) / 60000L);
        int second = (int)((time %= 60000L) / 1000L);
        time %= 1000L;
        StringBuffer sb = new StringBuffer("(");
        sb.append(day).append(" days ");
        sb.append(this.mk2(hour)).append(":");
        sb.append(this.mk2(minute)).append(":");
        sb.append(this.mk2(second)).append(")");
        return sb.toString();
    }

    private static class Day {
        public final int yyyy;
        public final int mm;
        public final int dd;
        public final String date;
        public final String wday;
        public final long time;

        public Day(String date, int yyyy, int mm, int dd, String day, long time) {
            this.date = date;
            this.wday = day;
            this.time = time;
            this.yyyy = yyyy;
            this.mm = mm;
            this.dd = dd;
        }
    }
}

