/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import whatap.util.CompareUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheTable<K, V> {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private CacheEntry<K, V>[] table;
    private CacheEntry<K, V> header;
    private int count;
    private int threshold;
    private float loadFactor;
    private long defaultKeepTime = 0L;
    private long last_check = System.currentTimeMillis();
    private int max;

    public CacheTable() {
        this(101, 0.75f);
    }

    public CacheTable(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new CacheEntry[initCapacity];
        this.header = new CacheEntry<Object, Object>(null, null, 0L, null);
        this.header.link_prev = this.header;
        this.header.link_next = this.header.link_prev;
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public int size() {
        return this.count;
    }

    public synchronized Enumeration<K> keys() {
        return new Enumer(1);
    }

    public synchronized Enumeration<V> values() {
        return new Enumer(2);
    }

    public synchronized Enumeration<CacheEntry<K, V>> entries() {
        return new Enumer(3);
    }

    public synchronized boolean containsKey(K key) {
        return this.getEntry(key) != null;
    }

    public synchronized V get(K key) {
        CacheEntry<K, V> e = this.getEntry(key);
        return e == null ? null : (V)e.getValue();
    }

    public synchronized V getKeepAlive(K key, long keepAlive) {
        CacheEntry<K, V> e = this.getEntry(key);
        if (e == null) {
            return null;
        }
        e.keepAlive(keepAlive);
        return e.getValue();
    }

    public synchronized V getKeepAlive(K key) {
        CacheEntry<K, V> e = this.getEntry(key);
        if (e == null) {
            return null;
        }
        e.keepAlive(this.defaultKeepTime);
        return e.getValue();
    }

    private CacheEntry<K, V> getEntry(K key) {
        if (key == null) {
            return null;
        }
        CacheEntry<K, V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        CacheEntry<K, V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(((CacheEntry)e).key, key)) {
                if (e.isExpired()) {
                    this.remove(e.getKey());
                    return null;
                }
                return e;
            }
            e = e.next;
        }
        return null;
    }

    private V getValue(CacheEntry<K, V> e) {
        if (e == null) {
            return null;
        }
        if (e.isExpired()) {
            this.remove(((CacheEntry)e).key);
            return null;
        }
        return (V)((CacheEntry)e).value;
    }

    public synchronized V getFirstValue() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getValue(this.header.link_next);
    }

    public synchronized V getLastValue() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getValue(this.header.link_prev);
    }

    public synchronized int getRemindTime(K key) {
        CacheEntry<K, V> entry = this.getEntry(key);
        if (entry != null) {
            if (((CacheEntry)entry).timeOfExpiration == 0L) {
                return Integer.MAX_VALUE;
            }
            return (int)(((CacheEntry)entry).timeOfExpiration - System.currentTimeMillis());
        }
        return 0;
    }

    public void clearExpiredItemsWithCheckInterval(long checkInterval) {
        long now = System.currentTimeMillis();
        if (now - this.last_check > checkInterval) {
            this.last_check = now;
            this.clearExpiredItems();
        }
    }

    public void clearExpiredItems() {
        try {
            ArrayList<K> delete = new ArrayList<K>();
            Enumeration<CacheEntry<K, V>> en = this.entries();
            while (en.hasMoreElements()) {
                CacheEntry<K, V> e = en.nextElement();
                if (!e.isExpired()) continue;
                delete.add(e.getKey());
            }
            for (int i = 0; i < delete.size(); ++i) {
                this.remove(delete.get(i));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private int hash(Object key) {
        return key.hashCode() & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        CacheEntry<K, V>[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        CacheEntry[] newMap = new CacheEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            CacheEntry<K, V> old = oldMap[i];
            while (old != null) {
                CacheEntry<K, V> e = old;
                old = old.next;
                Object key = ((CacheEntry)e).key;
                int index = this.hash(key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public CacheTable<K, V> setMaxRow(int max) {
        this.max = max;
        return this;
    }

    public CacheTable<K, V> setDefaultKeepTime(long time) {
        this.defaultKeepTime = time;
        return this;
    }

    public V put(K key, V value, long keepTime) {
        return this._put(key, value, keepTime, 4);
    }

    public V putLast(K key, V value, long keepTime) {
        return this._put(key, value, keepTime, 2);
    }

    public V putFirst(K key, V value, long keepTime) {
        return this._put(key, value, keepTime, 1);
    }

    public V put(K key, V value) {
        return this._put(key, value, this.defaultKeepTime, 4);
    }

    public V putLast(K key, V value) {
        return this._put(key, value, this.defaultKeepTime, 2);
    }

    public V putFirst(K key, V value) {
        return this._put(key, value, this.defaultKeepTime, 1);
    }

    private synchronized V _put(K key, V value, long keepTime, int m) {
        CacheEntry<K, V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        CacheEntry<K, V> e = tab[index];
        while (e != null) {
            if (CompareUtil.equals(((CacheEntry)e).key, key)) {
                Object old = ((CacheEntry)e).value;
                ((CacheEntry)e).value = value;
                e.keepAlive(keepTime);
                switch (m) {
                    case 1: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case 2: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return (V)old;
            }
            e = e.next;
        }
        if (this.max > 0) {
            switch (m) {
                case 1: 
                case 3: {
                    while (this.count >= this.max) {
                        this.removeLast();
                    }
                    break;
                }
                case 2: 
                case 4: {
                    while (this.count >= this.max) {
                        this.removeFirst();
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = this.hash(key) % tab.length;
        }
        e = new CacheEntry<K, V>(key, value, keepTime, tab[index]);
        tab[index] = e;
        switch (m) {
            case 1: 
            case 3: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case 2: 
            case 4: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return null;
    }

    public synchronized V remove(Object key) {
        if (key == null) {
            return null;
        }
        CacheEntry<K, V>[] tab = this.table;
        int index = this.hash(key) % tab.length;
        CacheEntry<K, V> e = tab[index];
        CacheEntry<K, V> prev = null;
        while (e != null) {
            if (CompareUtil.equals(((CacheEntry)e).key, key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = ((CacheEntry)e).value;
                ((CacheEntry)e).value = null;
                this.unchain(e);
                return (V)oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public synchronized V removeFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.remove(this.header.link_next.key);
    }

    public synchronized V removeLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.remove(this.header.link_prev.key);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized void clear() {
        CacheEntry<K, V>[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.header.link_prev = this.header;
        this.header.link_next = this.header.link_prev;
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<CacheEntry<K, V>> it = this.entries();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            CacheEntry<K, V> e = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(e.getKey() + "=" + e.getValue());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toKeyString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<K> it = this.keys();
        buf.append("{");
        int i = 0;
        while (it.hasMoreElements()) {
            K key = it.nextElement();
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(key);
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toFormatString() {
        StringBuffer buf = new StringBuffer();
        Enumeration<CacheEntry<K, V>> it = this.entries();
        buf.append("{\n");
        while (it.hasMoreElements()) {
            CacheEntry<K, V> e = it.nextElement();
            buf.append("\t").append(e.getKey() + "=" + e.getValue()).append("\n");
        }
        buf.append("}");
        return buf.toString();
    }

    private void chain(CacheEntry link_prev, CacheEntry link_next, CacheEntry e) {
        e.link_prev = link_prev;
        e.link_next = link_next;
        link_prev.link_next = e;
        link_next.link_prev = e;
    }

    private void unchain(CacheEntry e) {
        e.link_prev.link_next = e.link_next;
        e.link_next.link_prev = e.link_prev;
        e.link_prev = null;
        e.link_next = null;
    }

    public static void main(String[] args) throws Exception {
        CacheTable<Integer, Integer> t = new CacheTable().setDefaultKeepTime(1000L).setMaxRow(100);
        for (int i = 0; i < 100; ++i) {
            t.put(i, i);
        }
        Enumeration e = t.keys();
        System.out.println(t.get(0));
        System.out.println(t.get(10));
        System.out.println(t.get(99));
        Thread.sleep(2000L);
        System.out.println("----->" + t.size());
        System.out.println(t.getFirstValue());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Enumer<V>
    implements Enumeration {
        byte type;
        CacheEntry entry;
        CacheEntry lastEnt;

        Enumer(byte type) {
            this.entry = ((CacheTable)CacheTable.this).header.link_next;
            this.type = type;
        }

        @Override
        public boolean hasMoreElements() {
            return CacheTable.this.header != this.entry && this.entry != null;
        }

        public V nextElement() {
            if (this.hasMoreElements()) {
                CacheEntry e = this.lastEnt = this.entry;
                this.entry = e.link_next;
                switch (this.type) {
                    case 1: {
                        return (V)e.key;
                    }
                    case 2: {
                        return (V)e.value;
                    }
                }
                return (V)e;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CacheEntry<K, V> {
        private K key;
        private V value;
        private long timeOfExpiration;
        private long keepTime = 0L;
        CacheEntry<K, V> next;
        CacheEntry<K, V> link_next;
        CacheEntry<K, V> link_prev;

        protected CacheEntry(K key, V value, long keepTime, CacheEntry next) {
            this.key = key;
            this.value = value;
            this.keepAlive(keepTime);
            this.next = next;
        }

        protected Object clone() {
            return new CacheEntry<K, V>(this.key, this.value, this.keepTime, this.next == null ? null : (CacheEntry)this.next.clone());
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean isExpired() {
            if (this.timeOfExpiration > 0L) {
                return this.timeOfExpiration < System.currentTimeMillis();
            }
            return false;
        }

        public void keepAlive(long keepTime) {
            if (keepTime > 0L) {
                this.keepTime = keepTime;
                this.timeOfExpiration = System.currentTimeMillis() + keepTime;
            } else {
                this.keepTime = 0L;
                this.timeOfExpiration = 0L;
            }
        }

        public void keep() {
            if (this.keepTime > 0L) {
                this.timeOfExpiration = System.currentTimeMillis() + this.keepTime;
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof CacheEntry)) {
                return false;
            }
            CacheEntry e = (CacheEntry)o;
            return CompareUtil.equals(this.key, e.key) && CompareUtil.equals(this.value, e.value);
        }

        public int hashCode() {
            return this.key.hashCode() ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

