/*
 * Decompiled with CFR 0.152.
 */
package whatap.util;

import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.value.Value;
import whatap.util.CompareUtil;
import whatap.util.DoubleList;
import whatap.util.FloatList;
import whatap.util.IntList;
import whatap.util.LongList;
import whatap.util.StringList;
import whatap.util.ValueList;

public abstract class AnyList {
    public static final byte INT = 1;
    public static final byte LONG = 2;
    public static final byte FLOAT = 3;
    public static final byte DOUBLE = 4;
    public static final byte STRING = 5;
    public static final byte VALUE = 6;

    public static AnyList create(byte type) {
        switch (type) {
            case 1: {
                return new IntList();
            }
            case 2: {
                return new LongList();
            }
            case 3: {
                return new FloatList();
            }
            case 4: {
                return new DoubleList();
            }
            case 5: {
                return new StringList();
            }
            case 6: {
                return new ValueList();
            }
        }
        throw new RuntimeException("unknown list type=" + type);
    }

    public abstract byte getType();

    public abstract void setInt(int var1, int var2);

    public abstract void setFloat(int var1, float var2);

    public abstract void setLong(int var1, long var2);

    public abstract void setDouble(int var1, double var2);

    public abstract void setString(int var1, String var2);

    public abstract void addInt(int var1);

    public abstract void addFloat(float var1);

    public abstract void addLong(long var1);

    public abstract void addDouble(double var1);

    public abstract void addString(String var1);

    public abstract int getInt(int var1);

    public abstract float getFloat(int var1);

    public abstract double getDouble(int var1);

    public abstract long getLong(int var1);

    public abstract String getString(int var1);

    public abstract Object getObject(int var1);

    public abstract Value getValue(int var1);

    public abstract void write(DataOutputX var1);

    public abstract void read(DataInputX var1);

    public abstract int size();

    public abstract int[] sorting(boolean var1);

    public abstract int[] sorting(boolean var1, AnyList var2, boolean var3);

    public abstract AnyList filtering(int[] var1);

    protected int compareChild(AnyList child, boolean ord, int i1, int i2) {
        if (child.getType() == 5) {
            if (ord) {
                return CompareUtil.compareTo(child.getString(i1), child.getString(i2));
            }
            return CompareUtil.compareTo(child.getString(i2), child.getString(i1));
        }
        if (ord) {
            return CompareUtil.compareTo(child.getDouble(i1), child.getDouble(i2));
        }
        return CompareUtil.compareTo(child.getDouble(i2), child.getDouble(i1));
    }
}

