/*
 * Decompiled with CFR 0.152.
 */
package whatap.reqlog.file;

import java.io.IOException;
import whatap.agent.Logger;
import whatap.agent.trace.HttpLog;
import whatap.agent.trace.TraceContext;
import whatap.lang.conf.ConfObserver;
import whatap.reqlog.ReqLogConf;
import whatap.reqlog.file.ReqLogFile;
import whatap.util.IPUtil;
import whatap.util.RequestQueue;
import whatap.util.StringUtil;
import whatap.util.ThreadUtil;

public class ReqLogThread
extends Thread {
    private static ReqLogThread instance;
    private long last_log = System.currentTimeMillis();
    private long failcount = 0L;
    private long last_write_log = System.currentTimeMillis();
    private long failwrite = 0L;
    private RequestQueue<TraceContext> buffer = new RequestQueue(ReqLogConf.reqlog_queue_size);
    boolean bRun = true;
    private ReqLogFile logFile = ReqLogFile.getInstance();

    public static synchronized ReqLogThread getInstance() {
        if (instance == null) {
            instance = new ReqLogThread();
            instance.setName("ReqLogThread");
            instance.setDaemon(true);
            instance.start();
        }
        return instance;
    }

    public ReqLogThread() {
        ConfObserver.add(ReqLogThread.class.getName(), new Runnable(){

            public void run() {
                ReqLogThread.this.buffer.setCapacity(ReqLogConf.reqlog_queue_size);
            }
        });
    }

    public void add(TraceContext r) {
        boolean ok = this.buffer.put(r);
        if (!ok) {
            ++this.failcount;
            long now = System.currentTimeMillis();
            if (now - this.last_log > ReqLogConf.reqlog_faillog_interval) {
                this.last_log = now;
                Logger.println("reqlog queue full #" + this.failcount);
            }
        }
    }

    public void run() {
        int stack = 0;
        while (this.bRun) {
            long now;
            try {
                TraceContext r = this.buffer.get();
                this.process(r);
            }
            catch (NullPointerException t) {
                ++this.failwrite;
                now = System.currentTimeMillis();
                if (now - this.last_write_log <= ReqLogConf.reqlog_faillog_interval) continue;
                this.last_write_log = now;
                try {
                    if (stack < 10) {
                        ++stack;
                        Logger.println("reqlog write fail #" + this.failwrite + " " + ThreadUtil.getStackTrace(t));
                        continue;
                    }
                    Logger.println("reqlog write fail #" + this.failwrite + " " + t);
                }
                catch (Throwable throwable) {
                }
            }
            catch (Throwable t) {
                ++this.failwrite;
                now = System.currentTimeMillis();
                if (now - this.last_write_log <= ReqLogConf.reqlog_faillog_interval) continue;
                this.last_write_log = now;
                Logger.println("reqlog write fail #" + this.failwrite + " " + t);
            }
        }
    }

    private void process(TraceContext r) throws IOException {
        if (this.logFile.out != null) {
            if (ReqLogConf.reqlog_error_only_enabled) {
                if (r.error != null) {
                    this.logFile.out.println(this.build(r));
                }
            } else {
                this.logFile.out.println(this.build(r));
            }
            r.reset();
            if (ReqLogConf.reqlog_write_flush) {
                this.logFile.out.flush();
            }
        }
    }

    private String build(TraceContext x) {
        char seperator = ReqLogConf.reqlog_seperator;
        StringBuffer sb = new StringBuffer();
        sb.append("stime=").append(x.endTime - (long)x.elapsed);
        if (ReqLogConf.reqlog_x_etime) {
            sb.append(seperator).append("etime=").append(x.endTime);
        }
        if (ReqLogConf.reqlog_x_elapsed) {
            sb.append(seperator).append("elapsed=").append(x.elapsed);
        }
        if (ReqLogConf.reqlog_x_url) {
            sb.append(seperator).append("url=").append(x.service_name);
        }
        if (ReqLogConf.reqlog_x_full_url) {
            sb.append(seperator).append("fullUrl=").append(x.http_url);
            if (x.http_query != null) {
                sb.append("?").append(x.http_query);
            }
        }
        if (ReqLogConf.reqlog_x_httphost && x.http_host != null) {
            sb.append(seperator).append("httphost=").append(x.http_host);
        }
        if (ReqLogConf.reqlog_x_method) {
            sb.append(seperator).append("method=").append(x.http_method);
        }
        if (ReqLogConf.reqlog_x_ip && x.remoteIp != 0) {
            sb.append(seperator).append("ip=").append(IPUtil.toString(x.remoteIp));
        }
        if (ReqLogConf.reqlog_x_status) {
            sb.append(seperator).append("status=").append(x.status);
        }
        if (ReqLogConf.reqlog_x_wcid && x.wclientId != 0L) {
            sb.append(seperator).append("wcid=").append(x.wclientId);
        }
        if (ReqLogConf.reqlog_x_login && x.login != null) {
            sb.append(seperator).append("login=").append(x.login);
        }
        if (ReqLogConf.reqlog_x_error && x.error != null) {
            sb.append(seperator).append("errCls=").append(x.error.className);
            if (ReqLogConf.reqlog_x_errormsg) {
                sb.append(seperator).append("errMsg=").append(StringUtil.limiting(x.error.message, ReqLogConf.reqlog_value_limit));
            }
        }
        if (ReqLogConf.reqlog_x_useragent) {
            sb.append(seperator).append("userAgent=").append(StringUtil.limiting(x.userAgentString, ReqLogConf.reqlog_value_limit));
        }
        if (ReqLogConf.reqlog_x_txid) {
            sb.append(seperator).append("txid=").append(x.txid);
        }
        if (x.custid != null) {
            if (ReqLogConf.reqlog_x_custid) {
                sb.append(seperator).append("custid=").append(x.custid);
            } else if (ReqLogConf.reqlog_x_gtid) {
                sb.append(seperator).append("gtid=").append(x.custid);
            }
        }
        if (ReqLogConf.reqlog_x_mtid && x.mtid != 0L) {
            sb.append(seperator).append("mtid=").append(x.mtid);
            if (ReqLogConf.reqlog_x_mdepth) {
                sb.append(seperator).append("mdepth=").append(x.mdepth);
            }
        }
        if (ReqLogConf.reqlog_x_dbc && x.dbc_time > 0) {
            sb.append(seperator).append("dbcTime=").append(x.dbc_time);
        }
        if (ReqLogConf.reqlog_x_sql && x.sql_count > 0) {
            sb.append(seperator).append("sqlCnt=").append(x.sql_count);
            sb.append(seperator).append("sqlTime=").append(x.sql_time);
        }
        if (ReqLogConf.reqlog_x_httpc && x.httpc_count > 0) {
            sb.append(seperator).append("httpCallCnt=").append(x.httpc_count);
            sb.append(seperator).append("httpCallTime=").append(x.httpc_time);
        }
        if (ReqLogConf.reqlog_x_rs && x.rs_count > 0) {
            sb.append(seperator).append("rsCnt=").append(x.rs_count);
            sb.append(seperator).append("rsTime=").append(x.rs_time);
        }
        if (x.reqlog != null) {
            int i;
            int len;
            HttpLog reqlog = x.reqlog;
            if (reqlog.req_header_key != null) {
                len = reqlog.req_header_key.length;
                for (i = 0; i < len; ++i) {
                    sb.append(seperator).append(reqlog.req_header_key[i]).append("=").append(reqlog.req_header_value[i]);
                }
            }
            if (reqlog.req_parameter_key != null) {
                len = reqlog.req_parameter_key.length;
                for (i = 0; i < len; ++i) {
                    sb.append(seperator).append(reqlog.req_parameter_key[i]).append("=").append(StringUtil.limiting(reqlog.req_parameter_value[i], ReqLogConf.reqlog_value_limit));
                }
            }
            if (reqlog.req_cookie_key != null) {
                len = reqlog.req_cookie_key.length;
                for (i = 0; i < len; ++i) {
                    sb.append(seperator).append(reqlog.req_cookie_key[i]).append("=").append(reqlog.req_cookie_value[i]);
                }
            }
            if (reqlog.resp_header_key != null) {
                len = reqlog.resp_header_key.length;
                for (i = 0; i < len; ++i) {
                    sb.append(seperator).append(reqlog.resp_header_key[i]).append("=").append(reqlog.resp_header_value[i]);
                }
            }
        }
        return sb.toString();
    }
}

