/*
 * Decompiled with CFR 0.152.
 */
package whatap.reqlog;

import whatap.agent.Configure;
import whatap.util.StringUtil;

public class ReqLogConf {
    public static boolean reqlog_enabled = false;
    public static boolean reqlog_file_enabled = false;
    public static boolean reqlog_logsink_enabled = false;
    public static boolean reqlog_error_only_enabled = false;
    public static boolean reqlog_default_enabled = false;
    public static int reqlog_file_buffer_size = 8192;
    public static int reqlog_queue_size = 1000;
    public static long reqlog_faillog_interval = 10000L;
    public static boolean reqlog_write_flush = true;
    public static String reqlog_base = "./reqlog";
    public static String reqlog_file = "reqlog.log";
    public static String reqlog_mount_check;
    public static boolean reqlog_clean_enabled;
    public static int reqlog_keep_date;
    public static char reqlog_seperator;
    public static boolean reqlog_x_etime;
    public static boolean reqlog_x_elapsed;
    public static boolean reqlog_x_url;
    public static boolean reqlog_x_httphost;
    public static boolean reqlog_x_method;
    public static boolean reqlog_x_ip;
    public static boolean reqlog_x_wcid;
    public static boolean reqlog_x_status;
    public static boolean reqlog_x_error;
    public static boolean reqlog_x_errormsg;
    public static boolean reqlog_x_useragent;
    public static boolean reqlog_x_txid;
    public static boolean reqlog_x_custid;
    public static boolean reqlog_x_gtid;
    public static boolean reqlog_x_full_url;
    public static boolean reqlog_x_mtid;
    public static boolean reqlog_x_mdepth;
    public static boolean reqlog_x_httpc;
    public static boolean reqlog_x_sql;
    public static boolean reqlog_x_dbc;
    public static boolean reqlog_x_login;
    public static boolean reqlog_x_rs;
    public static boolean _reqlog_has_httpreq;
    public static String[] reqlog_parameter;
    public static String[] reqlog_header;
    public static String[] reqlog_cookie;
    public static String[] reqlog_resp_header;
    public static int reqlog_value_limit;
    public static boolean reqlog_x_referer;

    public static void apply(Configure conf) {
        reqlog_enabled = conf.getBoolean("reqlog_enabled", false);
        reqlog_file_enabled = conf.getBoolean("reqlog_file_enabled", reqlog_enabled);
        reqlog_logsink_enabled = conf.getBoolean("reqlog_logsink_enabled", false);
        reqlog_enabled = reqlog_logsink_enabled || reqlog_file_enabled;
        reqlog_default_enabled = conf.getBoolean("reqlog_default_enabled", true);
        reqlog_file_buffer_size = conf.getInt("reqlog_file_buffer_size", 8192);
        reqlog_queue_size = conf.getInt("reqlog_queue_size", 1000);
        reqlog_faillog_interval = conf.getInt("reqlog_faillog_interval", 10000);
        reqlog_write_flush = conf.getBoolean("reqlog_write_flush", true);
        String home = System.getProperty("whatap.home", ".");
        reqlog_base = conf.getValue("reqlog_base", home + "/reqlog");
        String defname = Configure.POD_NAME == null ? "reqlog.log" : "reqlog-" + Configure.POD_NAME + ".log";
        reqlog_file = conf.getValue("reqlog_file", defname);
        reqlog_mount_check = conf.getValue("reqlog_mount_check");
        reqlog_keep_date = conf.getInt("reqlog_keep_date", 3);
        reqlog_clean_enabled = conf.getBoolean("reqlog_clean_enabled", false);
        reqlog_seperator = conf.getChar("reqlog_seperator", '|');
        reqlog_x_etime = conf.getBoolean("reqlog_x_etime", reqlog_default_enabled);
        reqlog_x_elapsed = conf.getBoolean("reqlog_x_elapsed", reqlog_default_enabled);
        reqlog_x_url = conf.getBoolean("reqlog_x_url", reqlog_default_enabled);
        reqlog_x_full_url = conf.getBoolean("reqlog_x_full_url", reqlog_default_enabled);
        reqlog_x_httphost = conf.getBoolean("reqlog_x_httphost", reqlog_default_enabled);
        reqlog_x_method = conf.getBoolean("reqlog_x_method", reqlog_default_enabled);
        reqlog_x_ip = conf.getBoolean("reqlog_x_ip", reqlog_default_enabled);
        reqlog_x_wcid = conf.getBoolean("reqlog_x_wcid", reqlog_default_enabled);
        reqlog_x_status = conf.getBoolean("reqlog_x_status", reqlog_default_enabled);
        reqlog_x_error = conf.getBoolean("reqlog_x_error", reqlog_default_enabled);
        reqlog_x_errormsg = conf.getBoolean("reqlog_x_errormsg", reqlog_default_enabled);
        reqlog_x_useragent = conf.getBoolean("reqlog_x_useragent", reqlog_default_enabled);
        reqlog_x_txid = conf.getBoolean("reqlog_x_txid", reqlog_default_enabled);
        reqlog_x_custid = conf.getBoolean("reqlog_x_custid", reqlog_default_enabled);
        reqlog_x_gtid = conf.getBoolean("reqlog_x_gtid", reqlog_default_enabled);
        reqlog_x_mtid = conf.getBoolean("reqlog_x_mtid", reqlog_default_enabled);
        reqlog_x_mdepth = conf.getBoolean("reqlog_x_mdepth", reqlog_default_enabled);
        reqlog_x_dbc = conf.getBoolean("reqlog_x_dbc", reqlog_default_enabled);
        reqlog_x_httpc = conf.getBoolean("reqlog_x_httpc", reqlog_default_enabled);
        reqlog_x_sql = conf.getBoolean("reqlog_x_sql", reqlog_default_enabled);
        reqlog_x_login = conf.getBoolean("reqlog_x_login", reqlog_default_enabled);
        reqlog_x_rs = conf.getBoolean("reqlog_x_rs", reqlog_default_enabled);
        reqlog_parameter = ReqLogConf.updateReqKeys(conf, "reqlog_parameter");
        reqlog_header = ReqLogConf.updateReqKeys(conf, "reqlog_header");
        reqlog_cookie = ReqLogConf.updateReqKeys(conf, "reqlog_cookie");
        reqlog_resp_header = ReqLogConf.updateReqKeys(conf, "reqlog_resp_header");
        _reqlog_has_httpreq = reqlog_parameter != null || reqlog_header != null || reqlog_cookie != null || reqlog_resp_header != null;
        reqlog_value_limit = conf.getInt("reqlog_value_limit", 200);
        reqlog_x_referer = conf.getBoolean("reqlog_x_referer", reqlog_default_enabled);
        reqlog_error_only_enabled = conf.getBoolean("reqlog_error_only_enabled", false);
    }

    private static String[] updateReqKeys(Configure conf, String key) {
        String[] varr = StringUtil.tokenizer(conf.getValue(key), ",");
        if (varr != null && varr.length > 0) {
            return varr;
        }
        return null;
    }

    static {
        reqlog_clean_enabled = false;
        reqlog_keep_date = 3;
        reqlog_seperator = (char)124;
        reqlog_x_etime = true;
        reqlog_x_elapsed = true;
        reqlog_x_url = true;
        reqlog_x_httphost = true;
        reqlog_x_method = true;
        reqlog_x_ip = true;
        reqlog_x_wcid = true;
        reqlog_x_status = true;
        reqlog_x_error = true;
        reqlog_x_errormsg = true;
        reqlog_x_useragent = true;
        reqlog_x_txid = true;
        reqlog_x_custid = false;
        reqlog_x_gtid = true;
        reqlog_x_full_url = true;
        reqlog_x_mtid = true;
        reqlog_x_mdepth = true;
        reqlog_x_httpc = true;
        reqlog_x_sql = true;
        reqlog_x_dbc = true;
        reqlog_x_login = true;
        reqlog_x_rs = true;
        _reqlog_has_httpreq = false;
        reqlog_value_limit = 200;
        reqlog_x_referer = true;
    }
}

