/*
 * Decompiled with CFR 0.152.
 */
package whatap.perfx.sys.win;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import whatap.agent.Configure;
import whatap.agent.data.DataPackSender;
import whatap.lang.pack.TagCountPack;
import whatap.lang.value.MapValue;
import whatap.perfx.sys.PerfXSystem;
import whatap.util.CastUtil;
import whatap.util.DateUtil;
import whatap.util.FileUtil;
import whatap.util.StringUtil;

public class WinDiskIO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean read(MapValue m) {
        block8: {
            boolean bl;
            InputStream is = null;
            OutputStream os = null;
            InputStream es = null;
            BufferedReader reader = null;
            try {
                String line;
                String scriptPath = Configure.getInstance().getValue("perfx_win_disk_ps1", "./disk.ps1");
                if (!new File(scriptPath).exists()) {
                    boolean bl2 = false;
                    return bl2;
                }
                ProcessBuilder builder = new ProcessBuilder("powershell.exe", "-ExecutionPolicy", "Bypass", "-File", scriptPath);
                builder.redirectErrorStream(true);
                Process process = builder.start();
                is = process.getInputStream();
                os = process.getOutputStream();
                es = process.getErrorStream();
                reader = new BufferedReader(new InputStreamReader(is));
                while ((line = reader.readLine()) != null) {
                    String[] kv = StringUtil.divKeyValueTrim(line, ":");
                    String key = WinDiskIO.key(kv[0]);
                    float val = CastUtil.cfloat(kv[1]);
                    m.put(key, val);
                }
                bl = true;
                FileUtil.close(reader);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block8;
            }
            finally {
                FileUtil.close(reader);
                FileUtil.close(is);
                FileUtil.close(os);
                FileUtil.close(es);
            }
            FileUtil.close(is);
            FileUtil.close(os);
            FileUtil.close(es);
            return bl;
        }
        return false;
    }

    private static String key(String k) {
        int x = k.lastIndexOf("disk");
        char[] ch = k.substring(x).toCharArray();
        StringBuilder sb = new StringBuilder();
        for (char c : ch) {
            if (c == ' ' || c == '/') {
                sb.append('_');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void send() {
        TagCountPack p = new TagCountPack();
        p.time = DateUtil.currentTime() / 1000L * 1000L;
        p.category = "win_disk_io";
        PerfXSystem.setTagAgentInfo(p);
        if (WinDiskIO.read(p.fields)) {
            DataPackSender.send(p, false);
        }
    }
}

