/*
 * Decompiled with CFR 0.152.
 */
package whatap.perfx.plugin;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.management.ObjectName;
import whatap.agent.Configure;
import whatap.agent.api.Repository;
import whatap.agent.conf.ConfPerfX;
import whatap.agent.data.DataPackSender;
import whatap.lang.pack.TagCountPack;
import whatap.util.ArrayUtil;
import whatap.util.DateUtil;
import whatap.util.StringSet;
import whatap.util.StringUtil;

public class PerfXUtil {
    public static String conf(String key) {
        return Configure.getInstance().getValue(key);
    }

    public static Object get(String key) {
        return Repository.get(key);
    }

    public static void put(String key, Object val) {
        Repository.put(key, val);
    }

    public static void remove(String key) {
        Repository.remove(key);
    }

    public static void send(TagCountPack p) {
        if (p.time == 0L) {
            p.time = DateUtil.currentTime();
        }
        p.time = p.time / 1000L * 1000L;
        DataPackSender.send(p);
    }

    public static void send(TagCountPack p, int oid) {
        p.originOid = oid;
        PerfXUtil.send(p);
    }

    public static void addAttr(TagCountPack p, String name, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            if (value instanceof Double) {
                p.add(name, n.doubleValue());
            } else if (value instanceof Float) {
                p.add(name, n.floatValue());
            } else {
                p.add(name, n.longValue());
            }
        } else if (value instanceof Boolean) {
            p.put(name, value.toString());
        } else if (value instanceof Date) {
            p.put(name, ((Date)value).getTime());
        } else if (value instanceof ObjectName) {
            PerfXUtil.setObjProp(p, (ObjectName)value);
        } else {
            String v = value.toString();
            if (StringUtil.isNotEmpty(v)) {
                p.putTag(name, v);
            }
        }
    }

    public static void setAttr(TagCountPack p, String name, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            if (value instanceof Double) {
                p.put(name, n.doubleValue());
            } else if (value instanceof Float) {
                p.put(name, n.floatValue());
            } else {
                p.put(name, n.longValue());
            }
        } else if (value instanceof Boolean) {
            p.put(name, value.toString());
        } else if (value instanceof Date) {
            p.put(name, ((Date)value).getTime());
        } else if (value instanceof ObjectName) {
            PerfXUtil.setObjProp(p, (ObjectName)value);
        } else {
            String v = ArrayUtil.toString(value);
            if (StringUtil.isNotEmpty(v)) {
                p.put(name, StringUtil.truncate(v, ConfPerfX.perfx_java_value_limit, "..."));
            }
        }
    }

    public static void setObjProp(TagCountPack p, ObjectName o) {
        if (o == null) {
            return;
        }
        try {
            Hashtable<String, String> h = o.getKeyPropertyList();
            Enumeration<String> en = h.keys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                String val = h.get(key);
                p.putTag(key, val);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setAttr(TagCountPack p, String name, Object value, boolean objNameTagEnabled, StringSet ignore) {
        if (value == null) {
            return;
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            if (value instanceof Double) {
                p.put(name, n.doubleValue());
            } else if (value instanceof Float) {
                p.put(name, n.floatValue());
            } else {
                p.put(name, n.longValue());
            }
        } else if (value instanceof Boolean) {
            p.put(name, value.toString());
        } else if (value instanceof Date) {
            p.put(name, ((Date)value).getTime());
        } else if (value instanceof ObjectName) {
            if (objNameTagEnabled) {
                PerfXUtil.setObjProp(p, (ObjectName)value, ignore);
            }
        } else {
            String v = ArrayUtil.toString(value);
            if (StringUtil.isNotEmpty(v)) {
                p.putTag(name, StringUtil.truncate(v, ConfPerfX.perfx_java_value_limit, "..."));
            }
        }
    }

    public static void setObjProp(TagCountPack p, ObjectName o, StringSet ignore) {
        if (o == null) {
            return;
        }
        try {
            Hashtable<String, String> h = o.getKeyPropertyList();
            Enumeration<String> en = h.keys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                if (ignore != null && ignore.hasKey(key)) continue;
                String val = h.get(key);
                p.putTag(key, val);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

