/*
 * Decompiled with CFR 0.152.
 */
package whatap.perfx.java;

import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.SecurityMaster;
import whatap.agent.conf.ConfPerfX;
import whatap.lang.pack.TagCountPack;
import whatap.perfx.java.PerfXGCAction;
import whatap.perfx.java.PerfXMemAction;
import whatap.perfx.java.PerfXOperatingSystemAction;
import whatap.util.IPUtil;
import whatap.util.StringUtil;
import whatap.util.SysJMX;
import whatap.util.ThreadUtil;

public class PerfXJava
extends Thread {
    private static PerfXJava instance;
    public String host;
    Configure conf;

    public PerfXJava() {
        this.host = IPUtil.toString(SecurityMaster.getInstance().IP);
        this.conf = Configure.getInstance();
    }

    public static final synchronized PerfXJava getInstance() {
        if (instance == null) {
            instance = new PerfXJava();
            instance.setName("WhaTap-PerfX-Memory");
            instance.setDaemon(true);
            instance.start();
        }
        return instance;
    }

    public void run() {
        while (true) {
            if (!ConfPerfX.perfx_java_enabled) {
                ThreadUtil.sleep(10000L);
                continue;
            }
            ThreadUtil.sleep(ConfPerfX.perfx_java_interval);
            try {
                if ("0.0.0.0".equals(this.host)) {
                    this.host = IPUtil.toString(SecurityMaster.getInstance().IP);
                }
                this.process();
                continue;
            }
            catch (Throwable t) {
                Logger.println(t.toString());
                continue;
            }
            break;
        }
    }

    private void process() {
        if (this.conf.getBoolean("perfx_java_memory_enabled", true)) {
            new PerfXMemAction().process();
        }
        if (this.conf.getBoolean("perfx_java_gc_enabled", true)) {
            new PerfXGCAction().process();
        }
        if (this.conf.getBoolean("perfx_java_os_enabled", true)) {
            new PerfXOperatingSystemAction().process();
        }
    }

    public static void setTagAgentInfo(TagCountPack p) {
        Configure conf = Configure.getInstance();
        SecurityMaster secu = SecurityMaster.getInstance();
        p.putTag("oname", secu.ONAME);
        if (StringUtil.isNotEmpty(conf.ONODE_NAME)) {
            p.putTag("onodeName", conf.ONODE_NAME);
        }
        if (StringUtil.isNotEmpty(conf.OKIND_NAME)) {
            p.putTag("okindName", conf.OKIND_NAME);
        }
        p.putTag("host_ip", PerfXJava.getInstance().host);
        p.putTag("pid", SysJMX.getProcessPID());
    }
}

