/*
 * Decompiled with CFR 0.152.
 */
package whatap.logsink.watch;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.Arrays;
import whatap.agent.Configure;
import whatap.agent.conf.ConfLogSink;
import whatap.agent.data.DataPackSender;
import whatap.lang.pack.LogSinkPack;
import whatap.util.DateUtil;
import whatap.util.FileUtil;

public class WatchLog {
    private final String id;
    private boolean activated = false;
    private File file;
    private long file_pos = -1L;
    String[] words = null;
    public int check_interval = 1000;
    private long last_check_time;
    static Configure conf = Configure.getInstance();

    public WatchLog(String id) {
        this.id = id;
    }

    public void config(String id, File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws IOException {
        int match;
        if (!this.file.canRead()) {
            this.file_pos = -1L;
            return;
        }
        if (this.file_pos < 0L) {
            this.file_pos = this.file.length();
            return;
        }
        long now = System.currentTimeMillis();
        if (now < this.last_check_time + (long)this.check_interval) {
            return;
        }
        this.last_check_time = System.currentTimeMillis();
        if (this.file_pos > this.file.length()) {
            this.file_pos = this.file.length();
            return;
        }
        long fileLength = this.file.length();
        RandomAccessFile raf = null;
        try {
            match = 0;
            raf = new RandomAccessFile(this.file, "r");
            for (int readCnt = 0; readCnt < ConfLogSink.watchlog_read_count; ++readCnt) {
                if (this.file_pos < fileLength) break block10;
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(raf);
            throw throwable;
        }
        {
            block12: {
                int len;
                byte[] buffer;
                block11: {
                    block10: {
                        FileUtil.close(raf);
                        return;
                    }
                    raf.seek(this.file_pos);
                    buffer = new byte[ConfLogSink.watchlog_buffer_size];
                    len = raf.read(buffer);
                    this.file_pos = raf.getFilePointer();
                    if (len != 0) break block11;
                    FileUtil.close(raf);
                    return;
                }
                if (!this.parseAndSend(buffer, len) || ++match < ConfLogSink.watchlog_send_count) break block12;
                this.file_pos = fileLength;
                FileUtil.close(raf);
                return;
            }
            continue;
        }
        FileUtil.close(raf);
    }

    private boolean parseAndSend(byte[] buffer, int len) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(buffer, 0, len);
        BufferedReader r = new BufferedReader(new InputStreamReader(bin));
        String line = r.readLine();
        while (line != null) {
            for (int i = 0; i < this.words.length; ++i) {
                if (line.indexOf(this.words[i]) < 0) continue;
                this.send(this.words[i], this, line);
                return true;
            }
            line = r.readLine();
        }
        return false;
    }

    private void send(String word, WatchLog wlog, String line) {
        LogSinkPack p = new LogSinkPack();
        p.time = DateUtil.currentTime();
        p.category = "watchlog." + wlog.id;
        p.tags.put("keyword", word);
        p.tags.put("id", this.id);
        p.tags.put("file", wlog.file.getName());
        p.tags.put("taglog", "1");
        p.content = line;
        p.line = wlog.file.length();
        DataPackSender.sendLogSink(p, false);
    }

    public void activate() {
        if (!this.activated) {
            this.file_pos = this.file.exists() ? this.file.length() : -1L;
        }
        this.activated = true;
    }

    public void stop() {
        this.activated = false;
    }

    public boolean isActive() {
        return this.activated;
    }

    public String toString() {
        return "WatchLog [id=" + this.id + ", activated=" + this.activated + ", file=" + this.file + ", file_pos=" + this.file_pos + ", words=" + Arrays.toString(this.words) + "]";
    }

    public void reset() {
        this.file_pos = -1L;
    }
}

