/*
 * Decompiled with CFR 0.152.
 */
package whatap.logsink.std;

import whatap.agent.Logger;
import whatap.agent.conf.ConfLogSink;
import whatap.lang.conf.ConfObserver;
import whatap.lang.pack.CounterPack1;
import whatap.lang.value.MapValue;
import whatap.logsink.LineLog;
import whatap.logsink.SenderUtil;
import whatap.logsink.std.IStdSender;
import whatap.logsink.std.ProxyStream;
import whatap.util.AnsiPrint;
import whatap.util.RequestQueue;

public class StdOutSenderThread
extends Thread
implements IStdSender {
    private static StdOutSenderThread instance;
    RequestQueue<LineLog> queue = new RequestQueue(ConfLogSink.logsink_stdout_queue_size);
    long logWaitTime = 500L;
    private ProxyStream stdout;
    public long queueDropped = 0L;
    static long lastDropped;

    public static final synchronized StdOutSenderThread getInstance() {
        if (instance == null) {
            instance = new StdOutSenderThread();
            instance.setName("StdOutSenderThread");
            instance.setDaemon(true);
            instance.start();
        }
        return instance;
    }

    public void run() {
        ConfObserver.add(this.getClass().getName(), new Runnable(){

            public void run() {
                StdOutSenderThread.this.reset(ConfLogSink.logsink_stdout_enabled);
                StdOutSenderThread.this.queue.setCapacity(ConfLogSink.logsink_stdout_queue_size);
            }
        });
        this.reset(ConfLogSink.logsink_stdout_enabled);
        while (true) {
            LineLog log = this.queue.get(this.logWaitTime);
            try {
                if (log != null) {
                    SenderUtil.send(log);
                    continue;
                }
                this.flush();
            }
            catch (Throwable throwable) {
            }
        }
    }

    private void flush() {
        LineLog log;
        if (this.stdout != null && (log = this.stdout.logflush()) != null) {
            SenderUtil.send(log);
        }
    }

    private void reset(boolean enabled) {
        if (enabled) {
            this.logWaitTime = 500L;
            if (this.stdout == null) {
                this.stdout = new ProxyStream(ConfLogSink.logsink_category_stdout, System.out, this);
                System.setOut(this.stdout);
                Logger.println(AnsiPrint.yellow("logsink stdout enabled"));
            }
            this.stdout.setEnabled(enabled);
        } else {
            this.logWaitTime = 30000L;
            if (this.stdout != null) {
                this.stdout.setEnabled(enabled);
            }
        }
    }

    public void add(LineLog lineLog) {
        boolean ok = this.queue.put(lineLog);
        if (!ok) {
            if (ConfLogSink.debug_logsink_dropped_enabled) {
                Logger.println("StdOutSender", 10, "stdOut dropped: " + this.queueDropped + ", queue size: " + this.queue.size() + ", capacity: " + this.queue.getCapacity());
            }
            if (ConfLogSink.debug_logsink_dropped_detail_enabled) {
                StringBuffer sb = new StringBuffer();
                sb.append("[");
                sb.append(AnsiPrint.green(lineLog.category));
                sb.append("] ");
                if (lineLog.content != null) {
                    if (ConfLogSink.debug_logsink_limit_content_length > 2 && lineLog.content.length() > ConfLogSink.debug_logsink_limit_content_length) {
                        sb.append(lineLog.content.substring(0, ConfLogSink.debug_logsink_limit_content_length - 2));
                    } else {
                        sb.append(lineLog.content);
                    }
                }
                if (lineLog.content != null && !lineLog.content.endsWith("\n")) {
                    sb.append("\n");
                }
                Logger.write(sb.toString());
            }
            ++this.queueDropped;
        }
    }

    public void logSelf(CounterPack1 cp) {
        if (lastDropped == this.queueDropped) {
            return;
        }
        lastDropped = this.queueDropped;
        if (cp.extra == null) {
            cp.extra = new MapValue();
        }
        if (cp.extra != null) {
            cp.extra.put("log_stdout_drop", this.queueDropped);
        }
    }

    static {
        lastDropped = 0L;
    }
}

