/*
 * Decompiled with CFR 0.152.
 */
package whatap.logsink.std;

import java.io.PrintStream;
import whatap.agent.conf.ConfLogSink;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.logsink.LineBuffer;
import whatap.logsink.LineLog;
import whatap.logsink.LineLogUtil;
import whatap.logsink.std.IStdSender;

public class ProxyStream
extends PrintStream {
    boolean enabled = true;
    private final LineBuffer lineBuffer;
    public final PrintStream origin;
    protected String category;
    protected IStdSender sender;

    public ProxyStream(String category, PrintStream origin, IStdSender sender) {
        super(origin);
        this.origin = origin;
        this.lineBuffer = new LineBuffer();
        this.category = category;
        this.sender = sender;
    }

    public void print(String x) {
        this.origin.print(x);
        if (this.enabled) {
            String[] lines = this.lineBuffer.append(x);
            for (int i = 0; i < lines.length; ++i) {
                String content = lines[i];
                if (content == null || content.length() <= 1) continue;
                LineLog lineLog = new LineLog();
                lineLog.category = this.category;
                LineLogUtil.checkLogContent(lineLog, content);
                if (lineLog.content == null) continue;
                ProxyStream.addTxTag(lineLog);
                this.sender.add(lineLog);
            }
        }
    }

    public void println() {
        this.origin.println();
        if (this.enabled) {
            String[] lines = this.lineBuffer.appendLine("");
            for (int i = 0; i < lines.length; ++i) {
                String content = lines[i];
                if (content == null || content.length() <= 1) continue;
                LineLog lineLog = new LineLog();
                lineLog.category = this.category;
                LineLogUtil.checkLogContent(lineLog, content);
                if (lineLog.content == null) continue;
                ProxyStream.addTxTag(lineLog);
                this.sender.add(lineLog);
            }
        }
    }

    public void println(String x) {
        this.origin.println(x);
        if (this.enabled) {
            String[] lines = this.lineBuffer.appendLine(x);
            for (int i = 0; i < lines.length; ++i) {
                String content = lines[i];
                if (content == null || content.length() <= 1) continue;
                LineLog lineLog = new LineLog();
                lineLog.category = this.category;
                LineLogUtil.checkLogContent(lineLog, content);
                if (lineLog.content == null) continue;
                ProxyStream.addTxTag(lineLog);
                this.sender.add(lineLog);
            }
        }
    }

    public void println(Object x) {
        this.origin.println(x);
        if (this.enabled) {
            String[] lines = this.lineBuffer.appendLine(String.valueOf(x));
            for (int i = 0; i < lines.length; ++i) {
                String content = lines[i];
                if (content == null || content.length() <= 1) continue;
                LineLog lineLog = new LineLog();
                lineLog.category = this.category;
                LineLogUtil.checkLogContent(lineLog, content);
                if (lineLog.content == null) continue;
                ProxyStream.addTxTag(lineLog);
                this.sender.add(lineLog);
            }
        }
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    LineLog logflush() {
        String content = this.lineBuffer.flush();
        if (content != null && content.length() > 1) {
            LineLog lineLog = new LineLog();
            lineLog.category = this.category;
            LineLogUtil.checkLogContent(lineLog, content);
            return lineLog;
        }
        return null;
    }

    private static void addTxTag(LineLog lineLog) {
        if (lineLog == null) {
            return;
        }
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx != null) {
            if (ConfLogSink.logsink_trace_txid_enabled && ctx.txid != 0L) {
                lineLog.fields.put("@txid", ctx.txid);
            }
            if (ConfLogSink.logsink_trace_mtid_enabled && ctx.mtid != 0L) {
                lineLog.fields.put("@mtid", ctx.mtid);
            }
            if (ConfLogSink.logsink_trace_custid_enabled && ctx.custid != null && ctx.custid.length() > 0) {
                lineLog.fields.put("@custid", ctx.custid);
            }
            if (ConfLogSink.logsink_trace_enabled) {
                if (ConfLogSink.logsink_trace_login_enabled && ctx.login != null) {
                    lineLog.fields.put("@login", ctx.login);
                }
                if (ConfLogSink.logsink_trace_httphost_enabled && ctx.http_host != null) {
                    lineLog.tags.put("httphost", ctx.http_host);
                }
            }
        }
    }
}

