/*
 * Decompiled with CFR 0.152.
 */
package whatap.logsink.fw;

import whatap.agent.Logger;
import whatap.agent.conf.ConfLogSink;
import whatap.lang.conf.ConfObserver;
import whatap.lang.pack.CounterPack1;
import whatap.lang.value.MapValue;
import whatap.logsink.LineLog;
import whatap.logsink.SenderUtil;
import whatap.logsink.std.IStdSender;
import whatap.util.AnsiPrint;
import whatap.util.RequestQueue;

public class LogSenderThread
extends Thread
implements IStdSender {
    private static LogSenderThread instance;
    RequestQueue<LineLog> queue = new RequestQueue(ConfLogSink.logsink_pack_queue_size);
    public long queueDropped = 0L;
    static long lastDropped;

    public static final synchronized LogSenderThread getInstance() {
        if (instance == null) {
            instance = new LogSenderThread();
            instance.setName("LogSenderThread");
            instance.setDaemon(true);
            instance.start();
        }
        return instance;
    }

    public void run() {
        ConfObserver.add(LogSenderThread.class.getName(), new Runnable(){

            public void run() {
                LogSenderThread.this.queue.setCapacity(ConfLogSink.logsink_pack_queue_size);
            }
        });
        Logger.green("logsink logtracer enabled");
        while (true) {
            LineLog log = this.queue.get();
            try {
                SenderUtil.send(log);
            }
            catch (Throwable throwable) {
            }
        }
    }

    public void add(LineLog lineLog) {
        boolean ok = this.queue.put(lineLog);
        if (!ok) {
            if (ConfLogSink.debug_logsink_dropped_enabled) {
                Logger.println("LogSender", 10, "linelog dropped: " + this.queueDropped + ", queue size: " + this.queue.size() + ", capacity: " + this.queue.getCapacity());
            }
            if (ConfLogSink.debug_logsink_dropped_detail_enabled) {
                StringBuffer sb = new StringBuffer();
                sb.append("[");
                sb.append(AnsiPrint.green(lineLog.category));
                sb.append("] ");
                if (lineLog.content != null) {
                    if (ConfLogSink.debug_logsink_limit_content_length > 2 && lineLog.content.length() > ConfLogSink.debug_logsink_limit_content_length) {
                        sb.append(lineLog.content.substring(0, ConfLogSink.debug_logsink_limit_content_length - 2));
                    } else {
                        sb.append(lineLog.content);
                    }
                }
                if (lineLog.content != null && !lineLog.content.endsWith("\n")) {
                    sb.append("\n");
                }
                Logger.write(sb.toString());
            }
            ++this.queueDropped;
        }
    }

    public void logSelf(CounterPack1 cp) {
        if (lastDropped == this.queueDropped) {
            return;
        }
        lastDropped = this.queueDropped;
        if (cp.extra == null) {
            cp.extra = new MapValue();
        }
        if (cp.extra != null) {
            cp.extra.put("log_line_drop", this.queueDropped);
        }
    }

    static {
        lastDropped = 0L;
    }
}

