/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.value;

import java.io.IOException;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.value.Value;
import whatap.util.HashUtil;

public class TextHashValue
implements Value,
Comparable {
    public int value;

    public TextHashValue() {
    }

    public TextHashValue(int value) {
        this.value = value;
    }

    public TextHashValue(String str) {
        this.value = HashUtil.hash(str);
    }

    public int compareTo(Object o) {
        if (o instanceof TextHashValue) {
            long thisVal = this.value;
            long anotherVal = ((TextHashValue)o).value;
            return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (o instanceof TextHashValue) {
            return this.value == ((TextHashValue)o).value;
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    public byte getValueType() {
        return 51;
    }

    public void write(DataOutputX out) throws IOException {
        out.writeInt(this.value);
    }

    public Value read(DataInputX in) throws IOException {
        this.value = in.readInt();
        return this;
    }

    public String toString() {
        return Integer.toString(this.value, 16);
    }

    public Object toJavaObject() {
        return this.value;
    }

    public Value copy() {
        return new TextHashValue(this.value);
    }

    public boolean isEmpty() {
        return this.value == 0;
    }
}

