/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.value;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.value.BooleanValue;
import whatap.lang.value.DecimalValue;
import whatap.lang.value.DoubleValue;
import whatap.lang.value.FloatValue;
import whatap.lang.value.MapValue;
import whatap.lang.value.NullValue;
import whatap.lang.value.TextValue;
import whatap.lang.value.Value;
import whatap.util.CompareUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListValue
implements Value {
    private List<Value> valueList;
    private int hash;
    private int hash_sz;

    public ListValue() {
        this.valueList = new ArrayList<Value>();
    }

    public ListValue(int size) {
        this.valueList = new ArrayList<Value>(size);
    }

    public ListValue(List<Value> value) {
        this.valueList = value;
    }

    public Value get(int i) {
        return this.valueList.get(i);
    }

    public boolean getBoolean(int i) {
        Value v = this.valueList.get(i);
        if (v instanceof BooleanValue) {
            return ((BooleanValue)v).value;
        }
        return false;
    }

    public double getDouble(int i) {
        Value v = this.valueList.get(i);
        if (v instanceof Number) {
            return ((Number)((Object)v)).doubleValue();
        }
        return 0.0;
    }

    public long getLong(int i) {
        Value v = this.valueList.get(i);
        if (v instanceof Number) {
            return ((Number)((Object)v)).longValue();
        }
        return 0L;
    }

    public int getInt(int i) {
        Value v = this.valueList.get(i);
        if (v instanceof Number) {
            return ((Number)((Object)v)).intValue();
        }
        return 0;
    }

    public String getString(int i) {
        Value v = this.valueList.get(i);
        if (v instanceof TextValue) {
            return ((TextValue)v).value;
        }
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    public float getFloat(int i) {
        Value v = this.valueList.get(i);
        if (v instanceof Number) {
            return ((Number)((Object)v)).floatValue();
        }
        return 0.0f;
    }

    public void set(int i, Value value) {
        this.valueList.set(i, value);
    }

    public ListValue add(Value value) {
        this.valueList.add(value);
        return this;
    }

    public ListValue add(Value[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.valueList.add(value[i]);
        }
        return this;
    }

    public ListValue add(boolean value) {
        this.valueList.add(new BooleanValue(value));
        return this;
    }

    public void add(double value) {
        this.valueList.add(new DoubleValue(value));
    }

    public void add(long value) {
        this.valueList.add(new DecimalValue(value));
    }

    public void add(float value) {
        this.valueList.add(new FloatValue(value));
    }

    public void add(String value) {
        this.valueList.add(new TextValue(value));
    }

    @Override
    public byte getValueType() {
        return 70;
    }

    @Override
    public void write(DataOutputX out) throws IOException {
        int sz = this.size();
        out.writeDecimal(sz);
        for (int i = 0; i < sz; ++i) {
            out.writeValue(this.valueList.get(i));
        }
    }

    public int size() {
        return this.valueList.size();
    }

    @Override
    public Value read(DataInputX in) throws IOException {
        int count = (int)in.readDecimal();
        for (int i = 0; i < count; ++i) {
            this.valueList.add(in.readValue());
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.valueList.get(i));
        }
        sb.append("]");
        return sb.toString();
    }

    public ListValue addNull() {
        this.add(new NullValue());
        return this;
    }

    @Override
    public Object toJavaObject() {
        return this.valueList;
    }

    public Object[] toObjectArray() {
        int sz = this.valueList.size();
        Object[] o = new Object[sz];
        for (int i = 0; i < sz; ++i) {
            o[i] = this.valueList.get(i).toJavaObject();
        }
        return o;
    }

    public ListValue add(Set<Value> keySet) {
        for (Value val : keySet) {
            this.add(val);
        }
        return this;
    }

    public ListValue add(String[] str) {
        if (str == null) {
            return this;
        }
        for (String s : str) {
            this.add(s);
        }
        return this;
    }

    public Iterator<Value> iterator() {
        return this.valueList.iterator();
    }

    public String[] toStringArray() {
        String[] out = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            out[i] = this.getString(i);
        }
        return out;
    }

    public int hashCode() {
        if (this.size() == this.hash_sz && this.hash != 0) {
            return this.hash;
        }
        this.hash_sz = this.size();
        for (int i = 0; i < this.valueList.size(); ++i) {
            this.hash ^= this.get(i).hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListValue other = (ListValue)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).equals(other.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toJSONString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            Value value;
            if (i > 0) {
                sb.append(",");
            }
            if ((value = this.valueList.get(i)).getValueType() == 50) {
                sb.append('\"').append(value).append('\"');
                continue;
            }
            if (value.getValueType() == 80) {
                sb.append(((MapValue)value).toJSONString());
                continue;
            }
            sb.append(value.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public void addAll(ListValue items) {
        if (items != null) {
            Iterator<Value> iter = items.iterator();
            while (iter.hasNext()) {
                Value n = iter.next();
                this.add(n);
            }
        }
    }

    @Override
    public int compareTo(Object o) {
        return CompareUtil.compareTo(this.hashCode(), o.hashCode());
    }

    @Override
    public Value copy() {
        return new ListValue(this.valueList);
    }

    @Override
    public boolean isEmpty() {
        return this.valueList == null || this.valueList.size() == 0;
    }

    public static ListValue by(String[] strs) {
        ListValue lv = new ListValue(strs.length);
        for (String s : strs) {
            lv.add(s);
        }
        return lv;
    }
}

