/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.value;

import java.io.IOException;
import java.text.DecimalFormat;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.value.NumberValue;
import whatap.lang.value.Value;

public class DoubleValue
extends NumberValue
implements Value,
Comparable {
    public double value;

    public DoubleValue() {
    }

    public DoubleValue(double value) {
        this.value = value;
    }

    public int compareTo(Object o) {
        if (o instanceof DoubleValue) {
            return Double.compare(this.value, ((DoubleValue)o).value);
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (o instanceof DoubleValue) {
            return this.value == ((DoubleValue)o).value;
        }
        return false;
    }

    public int hashCode() {
        long v = Double.doubleToLongBits(this.value);
        return (int)(v ^ v >>> 32);
    }

    public byte getValueType() {
        return 40;
    }

    public void write(DataOutputX out) throws IOException {
        out.writeDouble(this.value);
    }

    public Value read(DataInputX in) throws IOException {
        this.value = in.readDouble();
        return this;
    }

    public String toString() {
        return new DecimalFormat("#0.0#################").format(new Double(this.value));
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public Object toJavaObject() {
        return this.value;
    }

    public Value copy() {
        return new DoubleValue(this.value);
    }

    public boolean isEmpty() {
        return this.value == 0.0;
    }
}

