/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.step;

import java.io.IOException;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.step.Step;
import whatap.lang.value.MapValue;
import whatap.lang.value.Value;
import whatap.org.json.JSONObject;

public class MessageStepX
extends Step {
    public String title;
    public String desc;
    public int ctr;
    public MapValue attr;
    public static final int SINGLE_LINE_DISPLAY = 1;

    public MessageStepX() {
    }

    public MessageStepX(int start_time) {
        this.start_time = start_time;
    }

    public byte getStepType() {
        return 22;
    }

    public String toString() {
        return "MessageStepX-" + this.title;
    }

    public int getElapsed() {
        return 0;
    }

    public void write(DataOutputX out) throws IOException {
        super.write(out);
        out.writeByte(0);
        out.writeBlob(this.writeVer0());
    }

    private byte[] writeVer0() {
        DataOutputX o = new DataOutputX();
        o.writeText(this.title);
        o.writeText(this.desc);
        o.writeInt(this.ctr);
        o.writeValue(this.attr);
        return o.toByteArray();
    }

    public Step read(DataInputX in) throws IOException {
        super.read(in);
        byte ver = in.readByte();
        byte[] bytes = in.readBlob();
        if (ver == 0) {
            this.readVer0(bytes);
        }
        return this;
    }

    private void readVer0(byte[] bytes) {
        DataInputX i = new DataInputX(bytes);
        this.title = i.readText();
        this.desc = i.readText();
        this.ctr = i.readInt();
        Value val = i.readValue();
        if (val instanceof MapValue) {
            this.attr = (MapValue)val;
        }
    }

    public void setCtr(int key) {
        this.ctr |= key;
    }

    public void setAttr(String key, Value val) {
        if (this.attr == null) {
            this.attr = new MapValue();
        }
        this.attr.put(key, val);
    }

    public JSONObject ctrToJson() {
        JSONObject o = new JSONObject();
        if (this.isA(1)) {
            o.put("SINGLE_LINE_DISPLAY", true);
        }
        return o;
    }

    private boolean isA(int k) {
        return (this.ctr & k) != 0;
    }
}

