/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack.os;

import java.io.IOException;
import whatap.io.DataIOException;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.Pack;
import whatap.lang.value.BooleanValue;
import whatap.lang.value.DecimalValue;
import whatap.lang.value.FloatValue;
import whatap.lang.value.IntMapValue;
import whatap.lang.value.TextValue;
import whatap.lang.value.Value;

public abstract class AbstractOSCounterPack
extends AbstractPack {
    protected IntMapValue osCounter = new IntMapValue();

    public Value get(int mx) {
        return this.osCounter.get(mx);
    }

    public boolean getBoolean(int mx) {
        Value v = this.get(mx);
        if (v instanceof BooleanValue) {
            return ((BooleanValue)v).value;
        }
        return false;
    }

    public int getInt(int mx) {
        Value v = this.get(mx);
        if (v instanceof Number) {
            return ((Number)((Object)v)).intValue();
        }
        return 0;
    }

    public long getLong(int mx) {
        Value v = this.get(mx);
        if (v instanceof Number) {
            return ((Number)((Object)v)).longValue();
        }
        return 0L;
    }

    public float getFloat(int mx) {
        Value v = this.get(mx);
        if (v instanceof Number) {
            return ((Number)((Object)v)).floatValue();
        }
        return 0.0f;
    }

    public String getText(int mx) {
        Value v = this.get(mx);
        if (v instanceof TextValue) {
            return ((TextValue)v).value;
        }
        return null;
    }

    public void put(int mx, Value value) {
        this.osCounter.put(mx, value);
    }

    public void put(int mx, String value) {
        this.put(mx, new TextValue(value));
    }

    public void put(int mx, long value) {
        this.put(mx, new DecimalValue(value));
    }

    public void put(int mx, float value) {
        this.put(mx, new FloatValue(value));
    }

    public void clear() {
        this.osCounter.clear();
    }

    public abstract short getPackType();

    public void write(DataOutputX dout) {
        super.write(dout);
        try {
            this.osCounter.write(dout);
        }
        catch (IOException e) {
            throw new DataIOException(e);
        }
    }

    public Pack read(DataInputX din) {
        super.read(din);
        try {
            this.osCounter.putAll((IntMapValue)new IntMapValue().read(din));
        }
        catch (IOException e) {
            throw new DataIOException(e);
        }
        return this;
    }
}

