/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack.open;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.open.Label;
import whatap.util.DateUtil;

public class OpenMx {
    public String metric;
    public List<Label> label;
    public long timestamp;
    public double value;

    public OpenMx() {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("OpenMx [");
        builder.append(this.metric);
        if (this.label != null && this.label.size() > 0) {
            builder.append(this.label);
        }
        builder.append(" ");
        builder.append(DateUtil.timestamp(this.timestamp));
        builder.append(" ");
        builder.append(this.value);
        builder.append("]");
        return builder.toString();
    }

    public OpenMx(String metric, long timestamp, double value) {
        this.metric = metric;
        this.timestamp = timestamp;
        this.value = value;
    }

    public OpenMx(String metric, long timestamp, double value, Label ... label) {
        this(metric, timestamp, value);
        this.label = Arrays.asList(label);
    }

    public void addLabel(String key, String value) {
        if (this.label == null) {
            this.label = new ArrayList<Label>();
        }
        this.label.add(new Label(key, value));
    }

    public void write(DataOutputX o) {
        o.writeByte(0);
        o.writeText(this.metric);
        int labelSize = this.label == null ? 0 : this.label.size();
        o.writeByte(labelSize);
        for (int i = 0; i < labelSize; ++i) {
            this.label.get(i).write(o);
        }
        o.writeLong(this.timestamp);
        o.writeDouble(this.value);
    }

    public OpenMx read(DataInputX in) {
        byte ver = in.readByte();
        this.metric = in.readText();
        int cnt = in.readByte();
        if (cnt > 0) {
            this.label = new ArrayList<Label>(cnt);
            for (int i = 0; i < cnt; ++i) {
                this.label.add(Label.readStatic(in));
            }
        }
        this.timestamp = in.readLong();
        this.value = in.readDouble();
        return this;
    }
}

