/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack.db;

import java.io.IOException;
import java.util.Enumeration;
import whatap.io.DataIOException;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.Pack;
import whatap.lang.value.BooleanValue;
import whatap.lang.value.DecimalValue;
import whatap.lang.value.FloatValue;
import whatap.lang.value.IntMapValue;
import whatap.lang.value.TextValue;
import whatap.lang.value.Value;
import whatap.util.StringKeyLinkedMap;

public abstract class AbstractDbCounterPack
extends AbstractPack {
    protected StringKeyLinkedMap<IntMapValue> dbms = new StringKeyLinkedMap<IntMapValue>(){

        @Override
        protected IntMapValue create(String key) {
            return new IntMapValue();
        }
    };

    public String[] getDBNames() {
        return this.dbms.keyArray();
    }

    public Value get(String db, int mx) {
        IntMapValue dbm = this.dbms.get(db);
        return dbm != null ? dbm.get(mx) : null;
    }

    public boolean getBoolean(String db, int mx) {
        Value v = this.get(db, mx);
        if (v instanceof BooleanValue) {
            return ((BooleanValue)v).value;
        }
        return false;
    }

    public int getInt(String db, int mx) {
        Value v = this.get(db, mx);
        if (v instanceof Number) {
            return ((Number)((Object)v)).intValue();
        }
        return 0;
    }

    public long getLong(String db, int mx) {
        Value v = this.get(db, mx);
        if (v instanceof Number) {
            return ((Number)((Object)v)).longValue();
        }
        return 0L;
    }

    public float getFloat(String db, int mx) {
        Value v = this.get(db, mx);
        if (v instanceof Number) {
            return ((Number)((Object)v)).floatValue();
        }
        return 0.0f;
    }

    public String getText(String db, int mx) {
        Value v = this.get(db, mx);
        if (v instanceof TextValue) {
            return ((TextValue)v).value;
        }
        return null;
    }

    public void put(String db, int mx, Value value) {
        this.dbms.intern(db).put(mx, value);
    }

    public void put(String db, int mx, String value) {
        this.put(db, mx, new TextValue(value));
    }

    public void put(String db, int mx, long value) {
        this.put(db, mx, new DecimalValue(value));
    }

    public void put(String db, int mx, float value) {
        this.put(db, mx, new FloatValue(value));
    }

    public void clear() {
        this.dbms.clear();
    }

    public abstract short getPackType();

    public void write(DataOutputX dout) {
        super.write(dout);
        dout.writeShort(this.dbms.size());
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<IntMapValue>> en = this.dbms.entries();
        while (en.hasMoreElements()) {
            StringKeyLinkedMap.StringKeyLinkedEntry<IntMapValue> ent = en.nextElement();
            dout.writeText(ent.getKey());
            try {
                ent.getValue().write(dout);
            }
            catch (IOException e) {
                throw new DataIOException(e);
            }
        }
    }

    public Pack read(DataInputX din) {
        super.read(din);
        int sz = din.readShort();
        for (int i = 0; i < sz; ++i) {
            String db = din.readText();
            try {
                this.dbms.put(db, (IntMapValue)new IntMapValue().read(din));
                continue;
            }
            catch (IOException e) {
                throw new DataIOException(e);
            }
        }
        return this;
    }
}

