/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack;

import java.util.Enumeration;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.Pack;
import whatap.util.IntIntMap;

public class StatStatusPack
extends AbstractPack {
    public IntIntMap iptable = new IntIntMap(2001, 1.0f);
    private short packType;
    public long dataStartTime;

    public StatStatusPack() {
        this(4864);
    }

    public StatStatusPack(short t) {
        this.packType = t;
    }

    public short getPackType() {
        return this.packType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StatStatus ");
        sb.append(super.toString());
        sb.append(",iptable=" + this.iptable.size());
        return sb.toString();
    }

    public void write(DataOutputX dout) {
        super.write(dout);
        dout.writeDecimal(this.iptable.size());
        Enumeration<IntIntMap.IntIntEntry> en = this.iptable.entries();
        while (en.hasMoreElements()) {
            IntIntMap.IntIntEntry e = en.nextElement();
            dout.writeInt(e.getKey());
            dout.writeInt(e.getValue());
        }
        if (this.packType == 4864) {
            return;
        }
        DataOutputX o = new DataOutputX();
        o.writeDecimal(this.dataStartTime);
        dout.writeBlob(o.toByteArray());
    }

    public Pack read(DataInputX din) {
        super.read(din);
        int cnt = (int)din.readDecimal();
        this.iptable = new IntIntMap(cnt, 1.0f);
        for (int i = 0; i < cnt; ++i) {
            int ip = din.readInt();
            int count = din.readInt();
            this.iptable.put(ip, count);
        }
        if (this.packType == 4864) {
            return this;
        }
        DataInputX in = new DataInputX(din.readBlob());
        this.dataStartTime = in.readDecimal();
        return this;
    }
}

