/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack;

import java.io.IOException;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.Pack;
import whatap.lang.step.Step;
import whatap.util.ArrayUtil;
import whatap.util.DateUtil;

public class ProfileStepSplitPack
extends AbstractPack {
    public long txid;
    public int inx;
    public byte[] steps;

    public short getPackType() {
        return 770;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Step ");
        sb.append(super.toString());
        sb.append(" time=" + DateUtil.timestamp(this.time));
        sb.append(" inx=" + this.inx);
        sb.append(" step_bytes=" + ArrayUtil.len(this.steps));
        return sb.toString();
    }

    public void write(DataOutputX dout) {
        super.write(dout);
        dout.writeByte(0);
        dout.writeLong(this.txid);
        dout.writeDecimal(this.inx);
        dout.writeBlob(this.steps);
    }

    public Pack read(DataInputX din) {
        super.read(din);
        byte ver = din.readByte();
        this.txid = din.readLong();
        this.inx = (int)din.readDecimal();
        this.steps = din.readBlob();
        return this;
    }

    public ProfileStepSplitPack setProfile(Step[] steps) throws IOException {
        this.steps = Step.toBytes(steps);
        return this;
    }
}

