/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack;

import java.util.ArrayList;
import java.util.List;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.LogSinkPack;
import whatap.lang.pack.Pack;
import whatap.util.ArrayUtil;
import whatap.util.CompressUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogSinkZipPack
extends AbstractPack {
    public static final int ZIPPED = 1;
    public static final int UN_ZIPPED = 0;
    public byte[] records;
    public int recordCount;
    public byte status = 0;
    public String license;

    @Override
    public short getPackType() {
        return 5901;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LogSinkZipPack ");
        sb.append(super.toString());
        sb.append("records=" + ArrayUtil.len(this.records) + "bytes");
        return sb.toString();
    }

    @Override
    public void write(DataOutputX dout) {
        super.write(dout);
        dout.writeByte(this.status);
        dout.writeDecimal(this.recordCount);
        dout.writeBlob(this.records);
    }

    @Override
    public Pack read(DataInputX din) {
        super.read(din);
        this.status = din.readByte();
        this.recordCount = (int)din.readDecimal();
        this.records = din.readBlob();
        return this;
    }

    private byte[] doUnZip() {
        if (this.status != 1) {
            return this.records;
        }
        return CompressUtil.unZip(this.records);
    }

    public List<LogSinkPack> records() {
        ArrayList<LogSinkPack> items = new ArrayList<LogSinkPack>();
        if (this.records == null) {
            return items;
        }
        DataInputX in = new DataInputX(this.doUnZip());
        for (int i = 0; i < this.recordCount; ++i) {
            LogSinkPack p = (LogSinkPack)in.readPack();
            if (p.pcode == 0L) {
                p.pcode = this.pcode;
                p.oid = this.oid;
                p.okind = this.okind;
                p.onode = this.onode;
            }
            items.add(p);
        }
        return items;
    }

    public void reset(List<LogSinkPack> packs, int min_size) {
        DataOutputX o = new DataOutputX();
        for (LogSinkPack p : packs) {
            o.writePack(p);
        }
        this.reset(packs.size(), o.toByteArray(), min_size);
    }

    public void reset(int rows, byte[] data, int logsink_zip_min_size) {
        this.recordCount = rows;
        if (data == null || data.length < logsink_zip_min_size) {
            this.status = 0;
            this.records = data;
        } else {
            this.status = 1;
            this.records = CompressUtil.doZip(data);
        }
    }
}

