/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack;

import java.util.ArrayList;
import java.util.List;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.Pack;
import whatap.util.LongEnumer;
import whatap.util.LongKeyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HvTextPack
extends AbstractPack {
    public List<Record> records = new ArrayList<Record>();

    @Override
    public short getPackType() {
        return 1793;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HvText");
        sb.append(super.toString());
        sb.append(",records=" + this.records.size());
        return sb.toString();
    }

    @Override
    public void write(DataOutputX dout) {
        super.write(dout);
        dout.writeByte(0);
        byte[] b = HvTextPack.writeRec(this.records);
        dout.writeBlob(b);
    }

    private static byte[] writeRec(List<Record> records) {
        DataOutputX o = new DataOutputX();
        o.writeDecimal(records.size());
        for (int i = 0; i < records.size(); ++i) {
            Record r = records.get(i);
            o.writeText(r.type);
            o.writeLong(r.hash);
            o.writeText(r.text);
        }
        return o.toByteArray();
    }

    @Override
    public Pack read(DataInputX din) {
        super.read(din);
        byte ver = din.readByte();
        byte[] b = din.readBlob();
        HvTextPack.readRec(this.records, b);
        return this;
    }

    private static void readRec(List<Record> records, byte[] b) {
        DataInputX in = new DataInputX(b);
        int size = (int)in.readDecimal();
        for (int i = 0; i < size; ++i) {
            String type = in.readText();
            long hash = in.readLong();
            String text = in.readText();
            records.add(new Record(type, hash, text));
        }
    }

    public void set(String type, LongKeyMap<String> m) {
        LongEnumer en = m.keys();
        while (en.hasMoreElements()) {
            long hash = en.nextLong();
            String val = m.get(hash);
            this.records.add(new Record(type, hash, val));
        }
    }

    public void add(Record r) {
        this.records.add(r);
    }

    public void add(String type, long hash, String text) {
        this.records.add(new Record(type, hash, text));
    }

    public static class Record {
        public String type;
        public long hash;
        public String text;

        public Record(String type, long hash, String text) {
            this.type = type;
            this.hash = hash;
            this.text = text;
        }
    }
}

