/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack;

import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.util.IntList;

public class HitViewRec {
    public static final int LENGTH = 240;
    public int[] hit = new int[240];
    public IntList hitOver;

    public HitViewRec write(DataOutputX o) {
        o.writeByte(0);
        if (this.hit == null) {
            o.writeShort(0);
        } else {
            int len;
            for (len = 239; len >= 0 && this.hit[len] == 0; --len) {
            }
            o.writeShort(++len);
            for (int i = 0; i < len; ++i) {
                o.writeShort(this.hit[i]);
            }
        }
        if (this.hitOver == null || this.hitOver.size() == 0) {
            o.writeShort(0);
        } else {
            int sz = this.hitOver.size();
            o.writeShort(sz);
            int hit_over_unit = 4000;
            o.writeByte(4);
            for (int i = 0; i < sz; ++i) {
                o.writeShort(this.hitOver.get(i) / 4000);
            }
        }
        return this;
    }

    public HitViewRec read(DataInputX in) {
        this.hit = new int[240];
        byte ver = in.readByte();
        int len = in.readShort();
        for (int i = 0; i < len; ++i) {
            this.hit[i] = in.readShort() & 0xFFFF;
        }
        int overCnt = in.readShort() & 0xFFFF;
        if (overCnt > 0) {
            this.hitOver = new IntList(overCnt + 1);
            int hit_over_unit = in.readByte() * 1000;
            for (int i = 0; i < overCnt; ++i) {
                int tm = in.readShort() & 0xFFFF;
                this.hitOver.add(tm * hit_over_unit);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(int time) {
        int x = time / 10000;
        switch (x) {
            case 0: {
                int[] nArray = this.hit;
                synchronized (this.hit) {
                    int n = time / 125;
                    this.hit[n] = this.hit[n] + 1;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
            case 1: {
                int[] nArray = this.hit;
                synchronized (this.hit) {
                    int n = 80 + (time - 10000) / 250;
                    this.hit[n] = this.hit[n] + 1;
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                    return;
                }
            }
            case 2: 
            case 3: {
                int[] nArray = this.hit;
                synchronized (this.hit) {
                    int n = 120 + (time - 20000) / 500;
                    this.hit[n] = this.hit[n] + 1;
                    // ** MonitorExit[var3_5] (shouldn't be in output)
                    return;
                }
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                int[] nArray = this.hit;
                synchronized (this.hit) {
                    int n = 160 + (time - 40000) / 1000;
                    this.hit[n] = this.hit[n] + 1;
                    // ** MonitorExit[var3_6] (shouldn't be in output)
                    return;
                }
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                int[] nArray = this.hit;
                synchronized (this.hit) {
                    int n = 200 + (time - 80000) / 2000;
                    this.hit[n] = this.hit[n] + 1;
                    // ** MonitorExit[var3_7] (shouldn't be in output)
                    return;
                }
            }
            default: {
                if (this.hitOver == null) {
                    this.hitOver = new IntList(31);
                }
                if (this.hitOver.size() >= 256) return;
                int[] nArray = this.hit;
                synchronized (this.hit) {
                    this.hitOver.add(time);
                    // ** MonitorExit[var3_8] (shouldn't be in output)
                    return;
                }
            }
        }
    }

    public void add(HitViewRec r) {
        for (int i = 0; i < 240; ++i) {
            int n = i;
            this.hit[n] = this.hit[n] + r.hit[i];
        }
        if (r.hitOver != null && r.hitOver.size() > 0) {
            if (this.hitOver == null) {
                this.hitOver = new IntList();
            }
            this.hitOver.addAll(r.hitOver);
        }
    }

    public static int index(int time) {
        int x = time / 10000;
        switch (x) {
            case 0: {
                return time / 125;
            }
            case 1: {
                return 80 + (time - 10000) / 250;
            }
            case 2: 
            case 3: {
                return 120 + (time - 20000) / 500;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 160 + (time - 40000) / 1000;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return 200 + (time - 80000) / 2000;
            }
        }
        return 240;
    }

    public static int time(int inx) {
        if (inx <= 0) {
            return 0;
        }
        int p = inx / 40;
        switch (p) {
            case 0: 
            case 1: {
                return inx * 125;
            }
            case 2: {
                return 10000 + (inx - 80) * 250;
            }
            case 3: {
                return 20000 + (inx - 120) * 500;
            }
            case 4: {
                return 40000 + (inx - 160) * 1000;
            }
            case 5: {
                return 80000 + (inx - 200) * 2000;
            }
        }
        return 160000;
    }

    public int[] getConvMap(int maxTime) {
        maxTime = maxTime / 10000 * 10000;
        int[] out = new int[80];
        switch (maxTime) {
            case 10000: {
                return this.b10(out);
            }
            case 20000: {
                return this.b20(out);
            }
            case 40000: {
                return this.b40(out);
            }
            case 80000: {
                return this.b80(out);
            }
            case 160000: {
                return this.b160(out);
            }
            case 320000: {
                return this.b320(out);
            }
        }
        return this.b320(out);
    }

    protected int[] b320(int[] out) {
        int i;
        for (i = 0; i < 80; ++i) {
            int n = i / 32;
            out[n] = out[n] + this.hit[i];
        }
        for (i = 80; i < 120; ++i) {
            int n = (int)((double)((float)i / 16.0f) - 2.5);
            out[n] = out[n] + this.hit[i];
        }
        for (i = 120; i < 160; ++i) {
            int n = i / 8 - 10;
            out[n] = out[n] + this.hit[i];
        }
        for (i = 160; i < 200; ++i) {
            int n = i / 4 - 30;
            out[n] = out[n] + this.hit[i];
        }
        for (i = 200; i < 240; ++i) {
            int n = i / 2 - 80;
            out[n] = out[n] + this.hit[i];
        }
        if (this.hitOver != null) {
            for (i = 0; i < this.hitOver.size(); ++i) {
                int t = this.hitOver.get(i);
                if (t >= 320000) {
                    out[79] = out[79] + 1;
                    continue;
                }
                int n = t / 4000;
                out[n] = out[n] + 1;
            }
        }
        return out;
    }

    protected int[] b160(int[] out) {
        int i;
        for (i = 0; i < 80; ++i) {
            int n = i / 16;
            out[n] = out[n] + this.hit[i];
        }
        for (i = 80; i < 120; ++i) {
            int n = i / 8 - 5;
            out[n] = out[n] + this.hit[i];
        }
        for (i = 120; i < 160; ++i) {
            int n = i / 4 - 20;
            out[n] = out[n] + this.hit[i];
        }
        for (i = 160; i < 200; ++i) {
            int n = i / 2 - 60;
            out[n] = out[n] + this.hit[i];
        }
        i = 200;
        int j = 40;
        while (i < 240) {
            out[j] = this.hit[i];
            ++i;
            ++j;
        }
        if (this.hitOver != null) {
            out[79] = out[79] + this.hitOver.size();
        }
        return out;
    }

    protected int[] b80(int[] out) {
        int i;
        for (i = 0; i < 80; ++i) {
            int n = i / 8;
            out[n] = out[n] + this.hit[i];
        }
        for (i = 80; i < 120; ++i) {
            int n = i / 4 - 10;
            out[n] = out[n] + this.hit[i];
        }
        for (i = 120; i < 160; ++i) {
            int n = i / 2 - 40;
            out[n] = out[n] + this.hit[i];
        }
        i = 160;
        int j = 40;
        while (i < 200) {
            out[j] = this.hit[i];
            ++i;
            ++j;
        }
        for (i = 200; i < 240; ++i) {
            out[79] = out[79] + this.hit[i];
        }
        if (this.hitOver != null) {
            out[79] = out[79] + this.hitOver.size();
        }
        return out;
    }

    protected int[] b40(int[] out) {
        int i;
        for (i = 0; i < 80; ++i) {
            int n = i / 4;
            out[n] = out[n] + this.hit[i];
        }
        for (i = 80; i < 120; ++i) {
            int n = i / 2 - 20;
            out[n] = out[n] + this.hit[i];
        }
        i = 120;
        int j = 40;
        while (i < 160) {
            out[j] = this.hit[i];
            ++i;
            ++j;
        }
        for (i = 160; i < 240; ++i) {
            out[79] = out[79] + this.hit[i];
        }
        if (this.hitOver != null) {
            out[79] = out[79] + this.hitOver.size();
        }
        return out;
    }

    protected int[] b20(int[] out) {
        int i;
        for (i = 0; i < 80; ++i) {
            int n = i / 2;
            out[n] = out[n] + this.hit[i];
        }
        i = 80;
        int j = 40;
        while (i < 120) {
            out[j] = this.hit[i];
            ++i;
            ++j;
        }
        for (i = 120; i < 240; ++i) {
            out[79] = out[79] + this.hit[i];
        }
        if (this.hitOver != null) {
            out[79] = out[79] + this.hitOver.size();
        }
        return out;
    }

    protected int[] b10(int[] out) {
        int i;
        int sx = 0;
        int dx = 80;
        for (i = sx; i < dx; ++i) {
            out[i] = this.hit[i];
        }
        for (i = dx; i < 240; ++i) {
            out[79] = out[79] + this.hit[i];
        }
        if (this.hitOver != null) {
            out[79] = out[79] + this.hitOver.size();
        }
        return out;
    }
}

