/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack;

import java.util.Enumeration;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.HitMapPack1;
import whatap.lang.pack.HitViewRec;
import whatap.lang.pack.Pack;
import whatap.util.IntEnumer;
import whatap.util.IntKeyMap;

public class HitViewPack
extends AbstractPack {
    public static final byte ID_ELAPSED = 1;
    public static final byte ID_ERROR = 2;
    public static final byte ID_SQL = 3;
    public static final byte ID_HTTPCALL = 4;
    public IntKeyMap<HitViewRec> map = new IntKeyMap(31, 1.0f);

    public short getPackType() {
        return 5382;
    }

    public void write(DataOutputX o) {
        super.write(o);
        o.writeByte(0);
        Enumeration<IntKeyMap.IntKeyEntry<HitViewRec>> en = this.map.entries();
        while (en.hasMoreElements()) {
            IntKeyMap.IntKeyEntry<HitViewRec> hr = en.nextElement();
            o.writeBoolean(true);
            o.writeByte(hr.getKey());
            hr.getValue().write(o);
        }
        o.writeBoolean(false);
    }

    public Pack read(DataInputX in) {
        super.read(in);
        byte version = in.readByte();
        while (in.readBoolean()) {
            byte id = in.readByte();
            HitViewRec hr = new HitViewRec().read(in);
            this.map.put(id, hr);
        }
        return this;
    }

    public HitViewRec get(int id) {
        return this.map.get(id);
    }

    public void put(int id, HitViewRec hr) {
        this.map.put(id, hr);
    }

    public void add(HitViewPack p) {
        IntEnumer en = p.map.keys();
        while (en.hasMoreElements()) {
            int id = en.nextInt();
            HitViewRec r = p.get(id);
            HitViewRec old = this.map.get(id);
            if (old == null) {
                old = new HitViewRec();
                this.map.put(id, old);
            }
            old.add(r);
        }
    }

    public HitMapPack1 toHitMapPack() {
        HitMapPack1 p = new HitMapPack1();
        p.pcode = this.pcode;
        p.time = this.time;
        p.oid = this.oid;
        p.okind = this.okind;
        p.onode = this.onode;
        this.merge(p.hit, this.get(1));
        this.merge(p.error, this.get(2));
        return p;
    }

    protected void merge(int[] map, HitViewRec r) {
        int i;
        if (r == null || map == null) {
            return;
        }
        for (i = 0; i < 40; ++i) {
            int n = i;
            map[n] = map[n] + r.hit[i];
        }
        for (i = 40; i < 80; ++i) {
            int n = 40 + (i - 40) / 2;
            map[n] = map[n] + r.hit[i];
        }
        for (i = 80; i < 120; ++i) {
            int n = 60 + (i - 80) / 2;
            map[n] = map[n] + r.hit[i];
        }
        for (i = 120; i < 160; ++i) {
            int n = 80 + (i - 120) / 2;
            map[n] = map[n] + r.hit[i];
        }
        for (i = 160; i < 200; ++i) {
            int n = 100 + (i - 160) / 2;
            map[n] = map[n] + r.hit[i];
        }
        for (i = 200; i < 240; ++i) {
            map[119] = map[119] + r.hit[i];
        }
        if (r.hitOver != null) {
            map[119] = map[119] + r.hitOver.size();
        }
    }
}

