/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack;

import java.util.Arrays;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.Pack;

public class HitMapPack1
extends AbstractPack {
    public static final int LENGTH = 120;
    public int[] hit = new int[120];
    public int[] error = new int[120];
    private static int[] dummy = new int[120];

    public short getPackType() {
        return 5377;
    }

    public String toString() {
        return "HitMap1 [" + super.toString() + ", hit=" + Arrays.toString(this.hit) + ", error=" + Arrays.toString(this.error) + "]";
    }

    public void write(DataOutputX o) {
        super.write(o);
        o.writeByte(3);
        HitMapPack1.writeArr(o, this.hit);
        HitMapPack1.writeArr(o, this.error);
    }

    private static void writeArr(DataOutputX o, int[] arr) {
        if (arr == null) {
            o.writeByte(0);
        } else {
            int len;
            for (len = 119; len >= 0 && arr[len] == 0; --len) {
            }
            o.writeByte((byte)(++len));
            for (int i = 0; i < len; ++i) {
                o.writeShort(arr[i]);
            }
        }
    }

    private static void readArr(DataInputX in, int[] arr) {
        int len = in.readByte() & 0xFF;
        for (int i = 0; i < len; ++i) {
            arr[i] = in.readShort() & 0xFFFF;
        }
    }

    public Pack read(DataInputX in) {
        super.read(in);
        byte ver = in.readByte();
        switch (ver) {
            case 1: {
                for (int i = 0; i < 120; ++i) {
                    this.hit[i] = in.readShort() & 0xFFFF;
                    this.error[i] = in.readShort() & 0xFFFF;
                }
                break;
            }
            case 2: {
                int len = in.readByte();
                for (int i = 0; i < len; ++i) {
                    this.hit[i] = in.readShort() & 0xFFFF;
                    this.error[i] = in.readShort() & 0xFFFF;
                }
                break;
            }
            case 3: {
                HitMapPack1.readArr(in, this.hit);
                HitMapPack1.readArr(in, this.error);
                break;
            }
            case 4: {
                HitMapPack1.readArr(in, this.hit);
                HitMapPack1.readArr(in, this.error);
                HitMapPack1.readArr(in, dummy);
                HitMapPack1.readArr(in, dummy);
                break;
            }
            default: {
                for (int i = 0; i < 120; ++i) {
                    this.hit[i] = in.readShort() & 0xFFFF;
                    this.error[i] = in.readShort() & 0xFFFF;
                }
            }
        }
        return this;
    }

    public void add(int time, boolean isError) {
        int idx;
        int n = idx = HitMapPack1.index(time);
        this.hit[n] = this.hit[n] + 1;
        if (isError) {
            int n2 = idx;
            this.error[n2] = this.error[n2] + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSync(int time, boolean isError) {
        int idx = HitMapPack1.index(time);
        if (isError) {
            int[] nArray = this.hit;
            synchronized (this.hit) {
                int n = idx;
                this.hit[n] = this.hit[n] + 1;
                int n2 = idx;
                this.error[n2] = this.error[n2] + 1;
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        int[] nArray = this.hit;
        synchronized (this.hit) {
            int n = idx;
            this.hit[n] = this.hit[n] + 1;
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return;
        }
    }

    public int hit(int sx, int dx) {
        int v = 0;
        for (int i = sx; i < dx; ++i) {
            v += this.hit[i];
        }
        return v;
    }

    public static int index(int time) {
        int x = time / 10000;
        switch (x) {
            case 0: {
                if (time < 5000) {
                    return time / 125;
                }
                return 40 + (time - 5000) / 250;
            }
            case 1: {
                return 60 + (time - 10000) / 500;
            }
            case 2: 
            case 3: {
                return 80 + (time - 20000) / 1000;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 100 + (time - 40000) / 2000;
            }
        }
        return 119;
    }

    public static int time(int inx) {
        if (inx <= 40) {
            return inx * 125;
        }
        if ((inx -= 40) <= 20) {
            return 5000 + inx * 250;
        }
        if ((inx -= 20) <= 20) {
            return 10000 + inx * 500;
        }
        if ((inx -= 20) <= 20) {
            return 20000 + inx * 1000;
        }
        if ((inx -= 20) <= 20) {
            return 40000 + inx * 2000;
        }
        return 80000;
    }

    public int getPct(double pct) {
        int tot = this.hitSum();
        if (tot == 0) {
            return 0;
        }
        int pctCnt = (int)((double)tot * pct);
        int cur = 0;
        for (int i = 0; i < 120; ++i) {
            int h = this.hit[i];
            if (cur + h >= pctCnt) {
                return HitMapPack1.time(i);
            }
            cur += h;
        }
        return HitMapPack1.time(120);
    }

    private int hitSum() {
        int s = 0;
        for (int h : this.hit) {
            s += h;
        }
        return s;
    }
}

