/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack;

import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.Pack;
import whatap.lang.slog.SLog;
import whatap.util.AnsiPrint;
import whatap.util.BitUtil;
import whatap.util.DateUtil;

public abstract class AbstractPack
implements Pack {
    public long pcode;
    public int oid;
    public int okind;
    public int onode;
    public long time;
    public transient boolean journaled;

    public boolean isWorkspace() {
        return BitUtil.getHigh(this.pcode) != 0;
    }

    public void setWorkspace(int id, short platform, short subsys) {
        this.pcode = new Workspace(id, platform, subsys).toLong();
    }

    public Workspace getWorkspace() {
        return new Workspace(this.pcode);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(DateUtil.timestamp(this.time));
        Workspace ws = this.getWorkspace();
        if (ws.id == 0) {
            sb.append("pcode=").append(this.pcode);
        } else {
            sb.append("wsid=").append(ws.id);
            sb.append(",platform=").append(ws.platform);
            sb.append(",sysid=").append(ws.sysid);
        }
        if (this.oid != 0) {
            sb.append(",oid=").append(this.oid);
        }
        if (this.okind != 0) {
            sb.append(",okind=").append(this.okind);
        }
        if (this.onode != 0) {
            sb.append(",onode=").append(this.onode);
        }
        return sb.toString();
    }

    public String toSimpleString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        Workspace ws = this.getWorkspace();
        if (ws.id == 0) {
            sb.append(" pcode=").append(this.pcode);
        } else {
            sb.append(" wsid=").append(ws.id);
            sb.append(",platform=").append(ws.platform);
            sb.append(",sysid=").append(ws.sysid);
        }
        if (this.oid != 0) {
            sb.append(",oid=").append(this.oid);
        }
        if (this.okind != 0) {
            sb.append(",okind=").append(this.okind);
        }
        if (this.onode != 0) {
            sb.append(",onode=").append(this.onode);
        }
        sb.append(",time=").append(DateUtil.timestamp(this.time));
        return sb.toString();
    }

    protected void toFmtString(StringBuilder sb, String k, Object v) {
        sb.append(",").append(AnsiPrint.green(k)).append("=").append(AnsiPrint.green(v));
    }

    public String toFormatString() {
        StringBuilder builder = new StringBuilder();
        builder.append("pcode=");
        builder.append(AnsiPrint.green(this.pcode));
        builder.append(",oid=").append(AnsiPrint.green(this.oid));
        builder.append(",okind=").append(AnsiPrint.green(this.okind));
        builder.append(",onode=").append(AnsiPrint.green(this.onode));
        return builder.toString();
    }

    public abstract short getPackType();

    public void write(DataOutputX dout) {
        if ((this.okind | this.onode) == 0) {
            dout.writeDecimal(this.pcode);
            dout.writeInt(this.oid);
            dout.writeLong(this.time);
        } else {
            dout.writeByte(9);
            dout.writeDecimal(this.pcode);
            dout.writeInt(this.oid);
            dout.writeInt(this.okind);
            dout.writeInt(this.onode);
            dout.writeLong(this.time);
        }
    }

    public Pack read(DataInputX din) {
        byte ver = din.readByte();
        if (ver <= 8) {
            this.pcode = din.readDecimal(ver);
            this.oid = din.readInt();
            this.time = din.readLong();
            return this;
        }
        if (ver == 9) {
            this.pcode = din.readDecimal();
            this.oid = din.readInt();
            this.okind = din.readInt();
            this.onode = din.readInt();
            this.time = din.readLong();
            return this;
        }
        throw new RuntimeException("Invalid Pack Data Error ver=" + ver);
    }

    public long getPcode() {
        return this.pcode;
    }

    public int getOid() {
        return this.oid;
    }

    public long getTime() {
        return this.time;
    }

    public int getOKind() {
        return this.okind;
    }

    public int getONode() {
        return this.onode;
    }

    public SLog slog(SLog log) {
        log.a("time", DateUtil.timestamp(this.time));
        log.a("pcode", this.pcode);
        if (this.oid != 0) {
            log.a("oid", this.oid);
        }
        if (this.okind != 0) {
            log.a("okind", this.okind);
        }
        if (this.onode != 0) {
            log.a("onode", this.onode);
        }
        return log;
    }

    public static class Workspace {
        public int id;
        public short platform;
        public short sysid;

        public Workspace(int id, short platform, short subsys) {
            this.id = id;
            this.platform = platform;
            this.sysid = subsys;
        }

        public Workspace(long pcode) {
            byte[] b = DataOutputX.toBytes(pcode);
            this.id = DataInputX.toInt(b, 0);
            this.platform = DataInputX.toShort(b, 4);
            this.sysid = DataInputX.toShort(b, 6);
        }

        public long toLong() {
            byte[] b = new byte[8];
            DataOutputX.toBytes(b, 0, this.id);
            DataOutputX.toBytes(b, 4, this.platform);
            DataOutputX.toBytes(b, 6, this.sysid);
            return DataInputX.toLong(b, 0);
        }
    }
}

