/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.conf;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Properties;
import whatap.lang.value.MapValue;
import whatap.util.FileUtil;
import whatap.util.SortUtil;
import whatap.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigMake {
    public static Properties reset(File file, List<String> keys, List<String> values, List<String> rmKeys) {
        Properties prop = ConfigMake.read(file);
        boolean dirty = false;
        if (keys != null && values != null && keys.size() == values.size()) {
            for (int i = 0; i < keys.size(); ++i) {
                String oldValue;
                String key = keys.get(i);
                String value = values.get(i);
                if (value.equals(oldValue = StringUtil.trim(prop.getProperty(key)))) continue;
                prop.setProperty(key, value);
                dirty = true;
            }
        }
        if (rmKeys != null) {
            for (String key : rmKeys) {
                if (!prop.containsKey(key)) continue;
                dirty = true;
                prop.remove(key);
            }
        }
        if (dirty) {
            ConfigMake.save(file, prop);
        }
        return prop;
    }

    public static void add(File file, String key, String value) {
        Properties prop = ConfigMake.read(file);
        String oldValue = StringUtil.trim(prop.getProperty(key));
        if (!value.equals(oldValue)) {
            prop.setProperty(key, value);
            ConfigMake.save(file, prop);
        }
    }

    public static boolean addProfile(File file, String key, String value) {
        if ((value = StringUtil.trimEmpty(value)).length() == 0) {
            return false;
        }
        Properties prop = ConfigMake.read(file);
        String oldValue = StringUtil.trimEmpty(prop.getProperty(key));
        if (oldValue.length() == 0) {
            prop.setProperty(key, value);
            ConfigMake.save(file, prop);
            return true;
        }
        if (oldValue.indexOf(value) < 0) {
            prop.setProperty(key, oldValue + "," + value);
            ConfigMake.save(file, prop);
            return true;
        }
        return false;
    }

    public static void remove(File file, String key) {
        Properties prop = ConfigMake.read(file);
        if (prop.containsKey(key)) {
            prop.remove(key);
            ConfigMake.save(file, prop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void save(File file, Properties s) {
        String[] keys = SortUtil.sort_string(s.keys(), s.size());
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            for (int i = 0; i < keys.length; ++i) {
                out.write((keys[i] + "=" + s.getProperty(keys[i]) + "\n").getBytes("UTF-8"));
            }
        }
        catch (Exception exception) {
            FileUtil.close(out);
            catch (Throwable throwable) {
                FileUtil.close(out);
                throw throwable;
            }
        }
        FileUtil.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties read(File file) {
        FileInputStream in;
        Properties p;
        block3: {
            p = new Properties();
            in = null;
            try {
                in = new FileInputStream(file);
                if (!file.exists()) break block3;
                p.load(in);
            }
            catch (Exception exception) {
                FileUtil.close(in);
            }
            catch (Throwable throwable) {
                FileUtil.close(in);
                throw throwable;
            }
        }
        FileUtil.close(in);
        return p;
    }

    public static void add(File file, String key, int value) {
        ConfigMake.add(file, key, Integer.toString(value));
    }

    public static MapValue load(File file) {
        String[] keys;
        Properties p = ConfigMake.read(file);
        MapValue m = new MapValue();
        for (String key : keys = SortUtil.sort_string(p.propertyNames(), p.size())) {
            String value = p.getProperty(key);
            m.put(key, value);
        }
        return m;
    }
}

