/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang;

import whatap.util.BitUtil;
import whatap.util.CastUtil;

public class WsKey {
    int wsid;
    short platform;
    short sysid;

    public WsKey() {
    }

    public WsKey(int wsid, short platform, short sysid) {
        this.wsid = wsid;
        this.platform = platform;
        this.sysid = sysid;
    }

    public int getWsid() {
        return this.wsid;
    }

    public void setWsid(int wsid) {
        this.wsid = wsid;
    }

    public short getPlatform() {
        return this.platform;
    }

    public void setPlatform(short platform) {
        this.platform = platform;
    }

    public short getSysid() {
        return this.sysid;
    }

    public void setSysid(short sysid) {
        this.sysid = sysid;
    }

    public long toLongPcode() {
        return BitUtil.composite(this.wsid, BitUtil.composite(this.platform, this.sysid));
    }

    public static WsKey createFromPcode(long pcode) {
        WsKey ws = new WsKey();
        ws.wsid = BitUtil.getHigh(pcode);
        if (ws.wsid > 0) {
            int subid = BitUtil.getLow(pcode);
            ws.platform = BitUtil.getHigh(subid);
            ws.sysid = BitUtil.getLow(subid);
        }
        return ws;
    }

    public static boolean isWorkspace(long pcode) {
        return BitUtil.getHigh(pcode) > 0;
    }

    public static long clearLowBits(long pcode) {
        return pcode & 0xFFFFFFFF00000000L;
    }

    public static long clearPlatform(long pcode) {
        return pcode & 0xFFFFFFFF0000FFFFL;
    }

    public static long clearSysid(long pcode) {
        return pcode & 0xFFFFFFFFFFFF0000L;
    }

    public static long wcode(long pcode) {
        return WsKey.clearLowBits(pcode);
    }

    public static long clearHighBits(long pcode) {
        return pcode & 0xFFFFFFFFL;
    }

    public static int wsid(long pcode) {
        return BitUtil.getHigh(pcode);
    }

    public String toString() {
        return this.wsid + "-" + this.platform + "-" + this.sysid;
    }

    public static String toString(long pcode) {
        if (WsKey.isWorkspace(pcode)) {
            return WsKey.createFromPcode(pcode).toString();
        }
        return Long.toString(pcode);
    }

    public static long parse(String id) {
        String[] toks = id.split("-");
        switch (toks.length) {
            case 1: {
                return CastUtil.clong(id);
            }
            case 3: {
                int wsid = CastUtil.cint(toks[0]);
                short platform = (short)CastUtil.cint(toks[1]);
                short sysid = (short)CastUtil.cint(toks[2]);
                return BitUtil.composite(wsid, BitUtil.composite(platform, sysid));
            }
        }
        throw new IllegalArgumentException("not pcode: " + id);
    }

    public String dirName() {
        StringBuilder sb = new StringBuilder();
        sb.append("w").append(this.wsid).append("/");
        sb.append(this.wsid).append("-").append(this.platform).append("-");
        sb.append(this.sysid);
        return sb.toString();
    }

    public String desc() {
        StringBuilder sb = new StringBuilder();
        sb.append("wsid=").append(this.wsid).append(":");
        sb.append("platform=").append(this.platform).append(":");
        sb.append("sysid=").append(this.sysid);
        return sb.toString();
    }
}

