/*
 * Decompiled with CFR 0.152.
 */
package whatap.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import whatap.io.DataIOException;
import whatap.lang.pack.Pack;
import whatap.lang.step.Step;
import whatap.lang.value.NullValue;
import whatap.lang.value.Value;

public class DataOutputX {
    public static final int INT3_MIN_VALUE = -8388608;
    public static final int INT3_MAX_VALUE = 0x7FFFFF;
    public static final long LONG5_MIN_VALUE = -549755813888L;
    public static final long LONG5_MAX_VALUE = 0x7FFFFFFFFFL;
    public static final long LONG6_MIN_VALUE = -140737488355328L;
    public static final long LONG6_MAX_VALUE = 0x7FFFFFFFFFFFL;
    private int written;
    private DataOutput inner;
    private ByteArrayOutputStream bout;
    private static final byte[] obfusKey = new byte[]{-1, 16, -14, 119, 73};

    public DataOutputX(int size) {
        this(new ByteArrayOutputStream(size));
    }

    public DataOutputX() {
        this(new ByteArrayOutputStream());
    }

    public byte[] toByteArray() {
        if (this.bout != null) {
            return this.bout.toByteArray();
        }
        return null;
    }

    public DataOutputX(ByteArrayOutputStream byteout) {
        this.bout = byteout;
        this.inner = new DataOutputStream(byteout);
    }

    public DataOutputX(BufferedOutputStream anyout) {
        this.inner = new DataOutputStream(anyout);
    }

    public DataOutputX(DataOutputStream out) {
        this.inner = out;
    }

    public DataOutputX(RandomAccessFile out) {
        this.inner = out;
    }

    public DataOutputX writeIntBytes(byte[] b) {
        if (b == null || b.length == 0) {
            this.writeInt(0);
        } else {
            this.writeInt(b.length);
            this.write(b);
        }
        return this;
    }

    public DataOutputX writeTinyBytes(byte[] b) {
        this.writeByte(b.length);
        this.write(b);
        return this;
    }

    public DataOutputX writeShortBytes(byte[] b) {
        this.writeShort(b.length);
        this.write(b);
        return this;
    }

    public DataOutputX writeBlob(byte[] value, int offset, int length) {
        if (value == null || value.length == 0) {
            this.writeByte(0);
        } else {
            int len = Math.min(length, value.length - offset);
            if (len <= 253) {
                this.writeByte((byte)len);
                this.write(value, offset, len);
            } else if (len <= 65535) {
                byte[] buff = new byte[3];
                buff[0] = -1;
                this.write(DataOutputX.toBytes(buff, 1, (short)len));
                this.write(value, offset, len);
            } else {
                byte[] buff = new byte[5];
                buff[0] = -2;
                this.write(DataOutputX.toBytes(buff, 1, len));
                this.write(value, offset, len);
            }
        }
        return this;
    }

    public DataOutputX writeBlob(byte[] value) {
        if (value == null || value.length == 0) {
            this.writeByte(0);
        } else {
            int len = value.length;
            if (len <= 253) {
                this.writeByte((byte)len);
                this.write(value);
            } else if (len <= 65535) {
                byte[] buff = new byte[3];
                buff[0] = -1;
                this.write(DataOutputX.toBytes(buff, 1, (short)len));
                this.write(value);
            } else {
                byte[] buff = new byte[5];
                buff[0] = -2;
                this.write(DataOutputX.toBytes(buff, 1, len));
                this.write(value);
            }
        }
        return this;
    }

    public DataOutputX writeText(String s) {
        if (s == null) {
            this.writeByte(0);
        } else {
            try {
                this.writeBlob(s.getBytes("UTF8"));
            }
            catch (IOException e) {
                throw new DataIOException(e);
            }
        }
        return this;
    }

    public DataOutputX writeText(StringBuffer s) {
        if (s == null) {
            this.writeByte(0);
        } else {
            try {
                this.writeBlob(s.toString().getBytes("UTF8"));
            }
            catch (IOException e) {
                throw new DataIOException(e);
            }
        }
        return this;
    }

    public DataOutputX writeInt3(int v) {
        this.write(DataOutputX.toBytes3(v), 0, 3);
        return this;
    }

    public DataOutputX writeLong5(long v) {
        this.write(DataOutputX.toBytes5(v), 0, 5);
        return this;
    }

    public DataOutputX writeLong6(long v) {
        this.write(DataOutputX.toBytes6(v), 0, 6);
        return this;
    }

    public DataOutputX writeDecimal(long v) {
        if (v == 0L) {
            this.writeByte(0);
        } else if (-128L <= v && v <= 127L) {
            byte[] b = new byte[]{1, (byte)v};
            this.write(b);
        } else if (-32768L <= v && v <= 32767L) {
            byte[] b = new byte[3];
            b[0] = 2;
            DataOutputX.toBytes(b, 1, (short)v);
            this.write(b);
        } else if (-8388608L <= v && v <= 0x7FFFFFL) {
            byte[] b = new byte[4];
            b[0] = 3;
            this.write(DataOutputX.toBytes3(b, 1, (int)v), 0, 4);
        } else if (Integer.MIN_VALUE <= v && v <= Integer.MAX_VALUE) {
            byte[] b = new byte[5];
            b[0] = 4;
            this.write(DataOutputX.toBytes(b, 1, (int)v), 0, 5);
        } else if (-549755813888L <= v && v <= 0x7FFFFFFFFFL) {
            byte[] b = new byte[6];
            b[0] = 5;
            this.write(DataOutputX.toBytes5(b, 1, v), 0, 6);
        } else if (Long.MIN_VALUE <= v && v <= Long.MAX_VALUE) {
            byte[] b = new byte[9];
            b[0] = 8;
            this.write(DataOutputX.toBytes(b, 1, v), 0, 9);
        }
        return this;
    }

    public DataOutputX wrttenDecimal(long v) {
        this.writeDecimal(v);
        this.flush();
        return this;
    }

    public static byte[] toBytes(short v) {
        byte[] buf = new byte[]{(byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)};
        return buf;
    }

    public static byte[] toBytes(byte[] buf, int off, short v) {
        buf[off] = (byte)(v >>> 8 & 0xFF);
        buf[off + 1] = (byte)(v >>> 0 & 0xFF);
        return buf;
    }

    public static byte[] toBytes(int v) {
        byte[] buf = new byte[]{(byte)(v >>> 24 & 0xFF), (byte)(v >>> 16 & 0xFF), (byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)};
        return buf;
    }

    public static byte[] toBytes(byte[] buf, int off, int v) {
        buf[off] = (byte)(v >>> 24 & 0xFF);
        buf[off + 1] = (byte)(v >>> 16 & 0xFF);
        buf[off + 2] = (byte)(v >>> 8 & 0xFF);
        buf[off + 3] = (byte)(v >>> 0 & 0xFF);
        return buf;
    }

    public static byte[] toBytes3(int v) {
        byte[] buf = new byte[]{(byte)(v >>> 16 & 0xFF), (byte)(v >>> 8 & 0xFF), (byte)(v >>> 0 & 0xFF)};
        return buf;
    }

    public static byte[] toBytes3(byte[] buf, int off, int v) {
        buf[off] = (byte)(v >>> 16 & 0xFF);
        buf[off + 1] = (byte)(v >>> 8 & 0xFF);
        buf[off + 2] = (byte)(v >>> 0 & 0xFF);
        return buf;
    }

    public static byte[] toBytes(long v) {
        byte[] buf = new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        return buf;
    }

    public static byte[] toBytes(byte[] buf, int off, long v) {
        buf[off] = (byte)(v >>> 56);
        buf[off + 1] = (byte)(v >>> 48);
        buf[off + 2] = (byte)(v >>> 40);
        buf[off + 3] = (byte)(v >>> 32);
        buf[off + 4] = (byte)(v >>> 24);
        buf[off + 5] = (byte)(v >>> 16);
        buf[off + 6] = (byte)(v >>> 8);
        buf[off + 7] = (byte)(v >>> 0);
        return buf;
    }

    public static byte[] toBytes5(long v) {
        byte[] writeBuffer = new byte[]{(byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        return writeBuffer;
    }

    public static byte[] toBytes6(long v) {
        byte[] writeBuffer = new byte[]{(byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        return writeBuffer;
    }

    public static byte[] toBytes5(byte[] buf, int off, long v) {
        buf[off] = (byte)(v >>> 32);
        buf[off + 1] = (byte)(v >>> 24);
        buf[off + 2] = (byte)(v >>> 16);
        buf[off + 3] = (byte)(v >>> 8);
        buf[off + 4] = (byte)(v >>> 0);
        return buf;
    }

    public static byte[] toBytes6(byte[] buf, int off, long v) {
        buf[off] = (byte)(v >>> 40);
        buf[off + 1] = (byte)(v >>> 32);
        buf[off + 2] = (byte)(v >>> 24);
        buf[off + 3] = (byte)(v >>> 16);
        buf[off + 4] = (byte)(v >>> 8);
        buf[off + 5] = (byte)(v >>> 0);
        return buf;
    }

    public static byte[] toBytes(boolean b) {
        if (b) {
            return new byte[]{1};
        }
        return new byte[]{0};
    }

    public static byte[] toBytes(byte[] buf, int off, boolean b) {
        buf[off] = b ? (byte)1 : 0;
        return buf;
    }

    public static byte[] toBytes(float v) {
        return DataOutputX.toBytes(Float.floatToIntBits(v));
    }

    public static byte[] toBytes(byte[] buf, int off, float v) {
        return DataOutputX.toBytes(buf, off, Float.floatToIntBits(v));
    }

    public static byte[] toBytes(double v) {
        return DataOutputX.toBytes(Double.doubleToLongBits(v));
    }

    public static byte[] toBytes(byte[] buf, int off, double v) {
        return DataOutputX.toBytes(buf, off, Double.doubleToLongBits(v));
    }

    public static byte[] set(byte[] dest, int pos, byte[] src) {
        System.arraycopy(src, 0, dest, pos, src.length);
        return dest;
    }

    public DataOutputX writeDecimalArray(int[] v) {
        if (v == null) {
            this.writeDecimal(0L);
        } else {
            this.writeDecimal(v.length);
            for (int i = 0; i < v.length; ++i) {
                this.writeDecimal(v[i]);
            }
        }
        return this;
    }

    public DataOutputX writeDecimalArray(long[] v) {
        if (v == null) {
            this.writeDecimal(0L);
        } else {
            this.writeDecimal(v.length);
            for (int i = 0; i < v.length; ++i) {
                this.writeDecimal(v[i]);
            }
        }
        return this;
    }

    public DataOutputX writeArray(long[] v) {
        if (v == null) {
            this.writeShort(0);
        } else {
            this.writeShort(v.length);
            for (int i = 0; i < v.length; ++i) {
                this.writeLong(v[i]);
            }
        }
        return this;
    }

    public DataOutputX writeArray(int[] v) {
        if (v == null) {
            this.writeShort(0);
        } else {
            this.writeShort(v.length);
            for (int i = 0; i < v.length; ++i) {
                this.writeInt(v[i]);
            }
        }
        return this;
    }

    public DataOutputX writeArray(float[] v) {
        if (v == null) {
            this.writeShort(0);
        } else {
            this.writeShort(v.length);
            for (int i = 0; i < v.length; ++i) {
                this.writeFloat(v[i]);
            }
        }
        return this;
    }

    public DataOutputX writeArray(double[] v) {
        if (v == null) {
            this.writeShort(0);
        } else {
            this.writeShort(v.length);
            for (int i = 0; i < v.length; ++i) {
                this.writeDouble(v[i]);
            }
        }
        return this;
    }

    public DataOutputX writeValue(Value value) {
        if (value == null) {
            value = NullValue.value;
        }
        try {
            this.writeByte(value.getValueType());
            value.write(this);
        }
        catch (IOException e) {
            throw new DataIOException(e);
        }
        return this;
    }

    public DataOutputX writeStep(Step step) {
        this.writeByte(step.getStepType());
        try {
            step.write(this);
        }
        catch (IOException e) {
            throw new DataIOException(e);
        }
        return this;
    }

    public DataOutputX writePack(Pack packet) {
        this.writeShort(packet.getPackType());
        try {
            packet.write(this);
        }
        catch (IOException e) {
            throw new DataIOException(e);
        }
        return this;
    }

    public DataOutputX write(byte[] b) {
        this.written += b.length;
        try {
            this.inner.write(b);
        }
        catch (IOException e) {
            throw new DataIOException(e);
        }
        return this;
    }

    public DataOutputX write(byte[] b, int off, int len) {
        this.written += len;
        try {
            this.inner.write(b, off, len);
        }
        catch (IOException e) {
            throw new DataIOException(e);
        }
        return this;
    }

    public DataOutputX writeBoolean(boolean v) {
        ++this.written;
        try {
            this.inner.writeBoolean(v);
        }
        catch (IOException e) {
            throw new DataIOException(e);
        }
        return this;
    }

    public DataOutputX writeByte(int v) {
        ++this.written;
        try {
            this.inner.writeByte((byte)v);
        }
        catch (IOException e) {
            throw new DataIOException(e);
        }
        return this;
    }

    public DataOutputX writeShort(int v) {
        this.written += 2;
        try {
            this.inner.write(DataOutputX.toBytes((short)v));
        }
        catch (IOException e) {
            throw new DataIOException(e);
        }
        return this;
    }

    public DataOutputX writeChar(int v) {
        this.written += 2;
        try {
            this.inner.writeChar(v);
        }
        catch (IOException e) {
            throw new DataIOException(e);
        }
        return this;
    }

    public DataOutputX writeInt(int v) {
        this.written += 4;
        try {
            this.inner.write(DataOutputX.toBytes(v));
        }
        catch (IOException e) {
            throw new DataIOException(e);
        }
        return this;
    }

    public DataOutputX writeLong(long v) {
        this.written += 8;
        try {
            this.inner.write(DataOutputX.toBytes(v));
        }
        catch (IOException e) {
            throw new DataIOException(e);
        }
        return this;
    }

    public DataOutputX writeFloat(float v) {
        this.written += 4;
        try {
            this.inner.write(DataOutputX.toBytes(v));
        }
        catch (IOException e) {
            throw new DataIOException(e);
        }
        return this;
    }

    public DataOutputX writeDouble(double v) {
        this.written += 8;
        try {
            this.inner.write(DataOutputX.toBytes(v));
        }
        catch (IOException e) {
            throw new DataIOException(e);
        }
        return this;
    }

    public int size() {
        return this.written;
    }

    public int getWriteSize() {
        return this.written;
    }

    public void close() {
        try {
            if (this.inner instanceof RandomAccessFile) {
                ((RandomAccessFile)this.inner).close();
            } else if (this.inner instanceof OutputStream) {
                ((OutputStream)((Object)this.inner)).close();
            }
        }
        catch (IOException e) {
            throw new DataIOException(e);
        }
    }

    public void flush() {
        if (this.inner instanceof OutputStream) {
            try {
                ((OutputStream)((Object)this.inner)).flush();
            }
            catch (IOException e) {
                throw new DataIOException(e);
            }
        }
    }

    public static byte[] toBytes(Value v) {
        return new DataOutputX().writeValue(v).toByteArray();
    }

    public static byte[] toBytes(Pack p) {
        return new DataOutputX().writePack(p).toByteArray();
    }

    public static byte[] toBytes(Pack pack, int fmtLen) {
        DataOutputX out = new DataOutputX().writePack(pack);
        int remainder = out.size() % fmtLen;
        if (remainder != 0) {
            out.write(new byte[fmtLen - remainder]);
        }
        return out.toByteArray();
    }

    public DataOutputX writeObfusText(String s) {
        if (s == null) {
            this.writeByte(0);
        } else {
            try {
                byte[] b = s.getBytes("UTF8");
                this.writeBlob(DataOutputX.obfus(b));
            }
            catch (IOException e) {
                throw new DataIOException(e);
            }
        }
        return this;
    }

    static byte[] obfus(byte[] b) {
        int i = 0;
        int j = 0;
        while (i < b.length) {
            int n = i++;
            b[n] = (byte)(b[n] ^ obfusKey[j]);
            j = (j + 1) % obfusKey.length;
        }
        return b;
    }
}

