/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.warning;

import java.util.Enumeration;
import java.util.TimeZone;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.data.DataPackSender;
import whatap.agent.plugin.PluginActionScript;
import whatap.agent.stat.ErrorArg;
import whatap.agent.util.ThreadNameUtil;
import whatap.agent.warning.WarnConf;
import whatap.lang.conf.ConfObserver;
import whatap.lang.pack.EventPack;
import whatap.notice.WHATAP_ERROR;
import whatap.util.DateTimeHelper;
import whatap.util.DateUtilGmt9;
import whatap.util.RequestQueue;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringUtil;
import whatap.util.ThreadUtil;

public class ExceptionWarning
extends Thread {
    private static ExceptionWarning instance;
    private RequestQueue<ErrorArg> queue = new RequestQueue(100);
    static Configure conf;
    private DateTimeHelper dateTime;
    private StringKeyLinkedMap<WarnConf> warningConfig = new StringKeyLinkedMap();
    private boolean enabled = false;
    private long last_check = 0L;

    public static synchronized ExceptionWarning getInstance() {
        if (instance == null) {
            instance = new ExceptionWarning();
            instance.setDaemon(true);
            instance.start();
            ThreadNameUtil.whatap(instance);
        }
        return instance;
    }

    public void add(ErrorArg r) {
        this.queue.put(r);
    }

    public void addError(ErrorArg arg) {
        this.add(arg);
    }

    public void run() {
        this.initialze();
        ConfObserver.add("ExceptionWarning", new Runnable(){

            public void run() {
                ExceptionWarning.this.initialze();
            }
        });
        while (true) {
            try {
                while (true) {
                    ErrorArg m = this.queue.get();
                    this.checkActive();
                    this.warning(m);
                }
            }
            catch (Throwable e) {
                Logger.println("EXCEPTION", 10, e.toString());
                continue;
            }
            break;
        }
    }

    private void initialze() {
        try {
            boolean exception_enabled;
            Configure conf = Configure.getInstance();
            boolean bl = exception_enabled = conf.exception_enabled && conf.enabled;
            if (!exception_enabled) {
                this.enabled = false;
                this.warningConfig.clear();
                return;
            }
            String[] ids = conf.getStringSet("exception.config", "", ",").getArray();
            StringKeyLinkedMap<WarnConf> tmpConf = new StringKeyLinkedMap<WarnConf>();
            for (int i = 0; i < ids.length; ++i) {
                WarnConf wc = new WarnConf();
                wc.id = ids[i];
                String exceptions = conf.getValue("exception." + ids[i] + ".name");
                if (StringUtil.isEmpty(exceptions)) continue;
                wc.silent_hour = conf.getIntSet("exception." + ids[i] + ".silent_hour", conf.getValue("exception.silent_hour", ""), ",");
                wc.silent_day = conf.getStringSet("exception." + ids[i] + ".silent_day", conf.getValue("exception.silent_day", ""), ",");
                wc.silent_interval = conf.getLong("exception." + ids[i] + ".silent_interval", conf.getLong("exception.silent_interval", 300000L));
                wc.check_count = conf.getInt("exception." + ids[i] + ".check_count", conf.getInt("exception.check_count", 5));
                if (wc.check_count > 1000) {
                    wc.check_count = 1000;
                }
                wc.check_period = conf.getLong("exception." + ids[i] + ".check_period", conf.getLong("exception.check_period", 300000L));
                wc.occur.setMax(wc.check_count);
                wc.action = conf.getBoolean("exception." + ids[i] + ".action", conf.getBoolean("exception.action", false));
                if (exceptions.indexOf(44) < 0) {
                    tmpConf.put(exceptions, wc);
                    continue;
                }
                String[] names = StringUtil.tokenizer(exceptions, ",");
                for (int n = 0; n < names.length; ++n) {
                    tmpConf.put(names[n], n == 0 ? wc : wc.copyNew());
                }
            }
            boolean bl2 = this.enabled = tmpConf.size() > 0;
            if (this.enabled) {
                String tz = conf.getValue("exception.timezone", "GMT+9");
                this.dateTime = "GMT+9".equalsIgnoreCase(tz) ? DateUtilGmt9.helper : DateTimeHelper.getDateTimeHelper(TimeZone.getTimeZone(tz));
            }
            this.warningConfig = tmpConf;
        }
        catch (Throwable t) {
            Logger.println(ThreadUtil.getStackTrace(t));
        }
    }

    protected boolean isTarget(String exception) {
        return this.warningConfig.containsKey(exception);
    }

    protected void checkActive() {
        if (this.dateTime == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.last_check < 10000L) {
            return;
        }
        this.last_check = now;
        String day = this.dateTime.getWeekDay(this.dateTime.yyyymmdd(now));
        int hour = this.dateTime.getHour(now);
        Enumeration<WarnConf> en = this.warningConfig.values();
        while (en.hasMoreElements()) {
            WarnConf wc = en.nextElement();
            boolean ok = true;
            if (wc.silent_day.contains(day)) {
                ok = false;
            }
            if (wc.silent_hour.contains(hour)) {
                ok = false;
            }
            if (now < wc.last_warning_time + wc.silent_interval) {
                ok = false;
            }
            wc.activated = ok;
        }
    }

    protected void warning(ErrorArg m) {
        WarnConf wc;
        if (!this.enabled) {
            return;
        }
        if (ExceptionWarning.conf.exception_status_code_enable && (m.exception == WHATAP_ERROR.status_error || m.exception == WHATAP_ERROR.httpc_error)) {
            m.className = m.className + "(" + m.status + ")";
        }
        if ((wc = this.warningConfig.get(m.className)) == null) {
            return;
        }
        if (!wc.activated) {
            return;
        }
        long now = System.currentTimeMillis();
        if (wc.check_count > 1) {
            wc.occur.put(now);
            if (wc.occur.size() < wc.check_count) {
                return;
            }
            if (wc.occur.getFirst() < now - wc.check_period) {
                return;
            }
            wc.occur.clear();
        }
        wc.last_warning_time = now;
        EventPack e = new EventPack();
        e.title = "TRANSACTION_EXCEPTION";
        e.level = (byte)20;
        e.status = 1;
        e.attr.put("url", Integer.toString(m.serviceHash));
        e.attr.put("class", m.className);
        if (m.appendHash != 0) {
            e.attr.put("ttype", Integer.toString(m.appendType));
            e.attr.put("thash", Integer.toString(m.appendHash));
        }
        e.message = m.className + " " + StringUtil.truncate(m.message, 200);
        DataPackSender.send(e);
        if (wc.action) {
            PluginActionScript.process(wc.id, m.className);
        }
    }

    static {
        conf = Configure.getInstance();
    }
}

