/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class WebLogic {
    private static MBeanServerConnection connection;
    private static JMXConnector connector;
    private static final ObjectName service;

    public static void initConnection(String hostname, String portString, String username, String password) throws IOException, MalformedURLException {
        String protocol = "t3";
        Integer portInteger = Integer.valueOf(portString);
        int port = portInteger;
        String jndiroot = "/jndi/";
        String mserver = "weblogic.management.mbeanservers.domainruntime";
        JMXServiceURL serviceURL = new JMXServiceURL(protocol, hostname, port, jndiroot + mserver);
        Hashtable<String, String> h = new Hashtable<String, String>();
        h.put("java.naming.security.principal", username);
        h.put("java.naming.security.credentials", password);
        h.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
        connector = JMXConnectorFactory.connect(serviceURL, h);
        connection = connector.getMBeanServerConnection();
    }

    public static ObjectName[] getServerRuntimes() throws Exception {
        return (ObjectName[])connection.getAttribute(service, "ServerRuntimes");
    }

    public void printClusterInfo() throws Exception {
        ObjectName[] cluster_list;
        ObjectName[] serverRT = WebLogic.getServerRuntimes();
        Hashtable<String, String> server_states = new Hashtable<String, String>();
        for (ObjectName ser : serverRT) {
            server_states.put((String)connection.getAttribute(ser, "Name"), (String)connection.getAttribute(ser, "State"));
        }
        ObjectName domain1 = (ObjectName)connection.getAttribute(service, "DomainConfiguration");
        for (ObjectName cl : cluster_list = (ObjectName[])connection.getAttribute(domain1, "Clusters")) {
            ObjectName[] servers;
            System.out.println("######################## n Cluster Name: " + (String)connection.getAttribute(cl, "Name"));
            for (ObjectName ser : servers = (ObjectName[])connection.getAttribute(cl, "Servers")) {
                String server_name = (String)connection.getAttribute(ser, "Name");
                System.out.println("Server Name: " + server_name + ", Server State: " + server_states.get(server_name));
            }
            System.out.println("######################## n");
        }
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        String hostname = "localhost";
        String portString = "7001";
        String username = "weblogic";
        String password = "weblogic";
        WebLogic s = new WebLogic();
        WebLogic.initConnection(hostname, portString, username, password);
        s.printClusterInfo();
        connector.close();
    }

    static {
        try {
            service = new ObjectName("com.bea:Name=DomainRuntimeService,Type=weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean");
        }
        catch (MalformedObjectNameException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }
}

