/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace.urlnorm;

import whatap.agent.Configure;
import whatap.util.IntKeyLinkedMap;
import whatap.util.IntLinkedSet;
import whatap.util.PathTree;

public class UrlNormProxy {
    public static PathTree<String> urlPathTree = new PathTree();
    public static IntLinkedSet noNeedSet = new IntLinkedSet(1025, 1.0f).setMax(10000);
    public static IntKeyLinkedMap<String> parsedSet = new IntKeyLinkedMap().setMax(2000);

    public static String normalize(String url) {
        if (noNeedSet.contains(url.hashCode())) {
            return url;
        }
        String newUrl = parsedSet.get(url.hashCode());
        if (newUrl != null) {
            return newUrl;
        }
        newUrl = urlPathTree.find(url);
        if (newUrl == null) {
            noNeedSet.put(url.hashCode());
            return url;
        }
        parsedSet.put(url.hashCode(), newUrl);
        return newUrl;
    }

    public static String normalize(String contextPath, String url) {
        if (noNeedSet.contains(url.hashCode())) {
            return url;
        }
        String newUrl = parsedSet.get(url.hashCode());
        if (newUrl != null) {
            return newUrl;
        }
        if (contextPath == null || contextPath.length() <= 1 || Configure.getInstance()._is_trace_auto_normalize_base_context) {
            return UrlNormProxy.withoutCtx(url);
        }
        return UrlNormProxy.withCtx(contextPath, url);
    }

    private static String withCtx(String contextPath, String url) {
        String newUrl = url.substring(contextPath.length());
        if ((newUrl = urlPathTree.find(newUrl)) == null) {
            noNeedSet.put(url.hashCode());
            return url;
        }
        newUrl = contextPath + newUrl;
        parsedSet.put(url.hashCode(), newUrl);
        return newUrl;
    }

    private static String withoutCtx(String url) {
        String newUrl = urlPathTree.find(url);
        if (newUrl == null) {
            noNeedSet.put(url.hashCode());
            return url;
        }
        parsedSet.put(url.hashCode(), newUrl);
        return newUrl;
    }
}

