/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace.urlnorm;

import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfDebug;
import whatap.agent.trace.urlnorm.ScanPathMap;
import whatap.agent.trace.urlnorm.UrlNormPathTreeBuilder;
import whatap.agent.util.AsyncRunner;

public class RebuildUrlNormScheduler {
    static Configure conf = Configure.getInstance();
    static long fullbuildActiveTime = Long.MAX_VALUE;
    static int reset = RebuildUrlNormScheduler.conf.trace_normalize_urls_reset;

    public static boolean checkBuildScanOrReset() {
        boolean activeEnabled = false;
        if (fullbuildActiveTime <= System.currentTimeMillis()) {
            fullbuildActiveTime = Long.MAX_VALUE;
            reset = RebuildUrlNormScheduler.conf.trace_normalize_urls_reset;
            activeEnabled = true;
        } else if (reset != RebuildUrlNormScheduler.conf.trace_normalize_urls_reset) {
            reset = RebuildUrlNormScheduler.conf.trace_normalize_urls_reset;
            activeEnabled = true;
        }
        if (activeEnabled) {
            if (ConfDebug.debug_urlnorm) {
                Logger.green("UrlNorm RebuildUrlNormScheduler.checkBuildScanOrReset()");
            }
            AsyncRunner.getInstance().add(new Runnable(){

                public void run() {
                    ScanPathMap pathMap = new ScanPathMap();
                    if (RebuildUrlNormScheduler.conf.trace_auto_normalize_enabled) {
                        UrlNormPathTreeBuilder.scanClasses(pathMap);
                    }
                    UrlNormPathTreeBuilder.build("FullBuild", pathMap);
                }
            });
        }
        return activeEnabled;
    }
}

