/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace.sql;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.Date;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.ParamSecurity;
import whatap.agent.conf.ConfDBC;
import whatap.agent.conf.ConfDebug;
import whatap.agent.conf.ConfPIIMask;
import whatap.agent.conf.ConfTrace;
import whatap.agent.counter.meter.MeterSQL;
import whatap.agent.data.DataTextAgent;
import whatap.agent.pii.PiiMask;
import whatap.agent.proxy.SqlTraceFactory;
import whatap.agent.stat.ErrorArg;
import whatap.agent.stat.StatError;
import whatap.agent.stat.StatSql;
import whatap.agent.trace.BuildPos;
import whatap.agent.trace.LocalContext;
import whatap.agent.trace.LogSinkRemoteAccessStatus;
import whatap.agent.trace.ParsedSql;
import whatap.agent.trace.ResultStat;
import whatap.agent.trace.SqlParameter;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.agent.trace.exception.ExceptionAlert;
import whatap.agent.trace.pstmt.ReflectPstmtProxy;
import whatap.agent.trace.sql.ISqlTrace;
import whatap.agent.trace.sql.SID;
import whatap.lang.ref.BYTE;
import whatap.lang.step.DBCStep;
import whatap.lang.step.MessageStep;
import whatap.lang.step.MethodStepX;
import whatap.lang.step.ResultSetStep;
import whatap.lang.step.SqlStepX;
import whatap.lang.value.TextValue;
import whatap.notice.WHATAP_ERROR;
import whatap.util.DateUtil;
import whatap.util.EscapeLiteralSQL;
import whatap.util.FileUtil;
import whatap.util.HashUtil;
import whatap.util.IntIntLinkedMap;
import whatap.util.IntKeyLinkedMap;
import whatap.util.IntKeyMap;
import whatap.util.SysJMX;
import whatap.util.ThreadUtil;

public class TraceSQL {
    public static ISqlTrace isql = SqlTraceFactory.java8;
    private static IntKeyLinkedMap<ParsedSql> checkedSql = new IntKeyLinkedMap(10001, 1.0f).setMax(1001);
    private static IntKeyLinkedMap<ParsedSql> nonLiteSql = new IntKeyLinkedMap(1007, 1.0f).setMax(10000);
    private static long logStackNum;
    private static Configure conf;
    static int dumpName;
    private static int CUSTOM_OPEN;
    private static int CUSTOM_CLOSE;
    private static IntIntLinkedMap driver_hash;
    static long last_log;
    static long dbc_log;

    public static ParsedSql escapeLiteral(String sql) {
        if (!TraceSQL.conf.trace_sql_normalize_enabled) {
            int hash = HashUtil.hash(sql);
            DataTextAgent.SQL.add(hash, sql);
            return new ParsedSql('*', hash, null);
        }
        int sqlHash = sql.hashCode();
        ParsedSql psql = nonLiteSql.get(sqlHash);
        if (psql != null) {
            return psql;
        }
        psql = checkedSql.get(sqlHash);
        if (psql != null) {
            return psql;
        }
        EscapeLiteralSQL els = new EscapeLiteralSQL(sql);
        els.process();
        String sql2 = els.getParsedSql();
        int hash = HashUtil.hash(sql2);
        DataTextAgent.SQL.add(hash, sql2);
        if (sql2.hashCode() == sqlHash) {
            psql = new ParsedSql(els.sqlType, hash, null);
            nonLiteSql.put(sqlHash, psql);
        } else {
            psql = new ParsedSql(els.sqlType, hash, els.getParameter());
            checkedSql.put(sqlHash, psql);
        }
        return psql;
    }

    public static void end(Object stat, Throwable thr) {
        if (stat == null) {
            return;
        }
        try {
            LocalContext lCtx = (LocalContext)stat;
            TraceContext ctx = lCtx.context;
            SqlStepX step = (SqlStepX)lCtx.step;
            if (ctx == null) {
                step.elapsed = (int)(DateUtil.nanoToMillis() - lCtx.time1);
                if (thr != null) {
                    int sqlErrorCode = isql.getErrorCode(thr);
                    if (!ConfTrace.ignore_sql_error_code_set.contains(sqlErrorCode)) {
                        ErrorArg arg = new ErrorArg();
                        arg.exception = thr;
                        arg.message = thr.getMessage();
                        arg.appendSql(step.hash);
                        arg.sqlErrorCode = sqlErrorCode;
                        step.error = StatError.getInstance().addError(arg);
                    }
                } else if (step.elapsed > ConfTrace.trace_error_sql_time_max) {
                    ErrorArg arg = new ErrorArg();
                    arg.exception = WHATAP_ERROR.slow_sql;
                    arg.message = WHATAP_ERROR.slow_sql.getMessage();
                    arg.appendSql(step.hash);
                    step.error = StatError.getInstance().addError(arg);
                }
                StatSql.getInstance().addSqlTime(0, 0L, step.dbc, step.hash, step.elapsed, step.error != 0L);
            } else {
                if (thr != null && ConfTrace.trace_sql_exception_enabled) {
                    int sqlErrorCode = isql.getErrorCode(thr);
                    if (sqlErrorCode == 0 || !ConfTrace.ignore_sql_error_code_set.contains(sqlErrorCode)) {
                        ErrorArg arg = new ErrorArg();
                        arg.exception = thr;
                        arg.message = thr.getMessage();
                        arg.setTraceCtx(ctx);
                        arg.sqlErrorCode = sqlErrorCode;
                        arg.appendSql(step.hash);
                        step.error = StatError.getInstance().addError(arg);
                        ExceptionAlert.getInstance().jdbc(ctx, ctx.sqlText, arg);
                        ctx.handleSqlErrorStack(thr);
                    }
                } else if (step.elapsed > ConfTrace.trace_error_sql_time_max) {
                    ErrorArg arg = new ErrorArg();
                    arg.exception = WHATAP_ERROR.slow_sql;
                    arg.message = WHATAP_ERROR.slow_sql.getMessage();
                    arg.appendSql(step.hash);
                    step.error = StatError.getInstance().addError(arg);
                }
                step.elapsed = ctx.getElapsedTime() - step.start_time;
                ctx.executed_dbc = step.dbc;
                ctx.executed_sqlhash = step.hash;
                ctx.sql = null;
                ctx.sqlText = null;
                ++ctx.sql_count;
                ctx.sql_time += step.elapsed;
                MeterSQL.getInstance().add(step.dbc, step.elapsed, step.error != 0L);
                StatSql.getInstance().addSqlTime(ctx.service_hash, ctx.txid, step.dbc, step.hash, step.elapsed, step.error != 0L);
                ctx.profile.pop(step);
            }
        }
        catch (Throwable t) {
            TraceSQL.profileLog(t);
        }
    }

    public static int[] executeBatch(int[] rtn, Object stat) {
        if (stat == null) {
            return rtn;
        }
        try {
            TraceSQL.end((LocalContext)stat, (byte)16, 0);
        }
        catch (Throwable t) {
            TraceSQL.profileLog(t);
        }
        return rtn;
    }

    public static long[] executeBatchInternal(long[] rtn, Object stat) {
        if (stat == null) {
            return rtn;
        }
        try {
            TraceSQL.end((LocalContext)stat, (byte)16, 0);
        }
        catch (Throwable t) {
            TraceSQL.profileLog(t);
        }
        return rtn;
    }

    public static Object executeQuery(Object rs, Object stat) {
        if (stat == null) {
            return rs;
        }
        try {
            LocalContext lCtx = (LocalContext)stat;
            TraceSQL.end(lCtx, (byte)48, 0);
            return rs;
        }
        catch (Throwable t) {
            TraceSQL.profileLog(t);
            return rs;
        }
    }

    public static int executeUpdate(int rtn, Object stat) {
        if (stat == null) {
            return rtn;
        }
        try {
            TraceSQL.end((LocalContext)stat, (byte)32, rtn);
        }
        catch (Throwable t) {
            TraceSQL.profileLog(t);
        }
        return rtn;
    }

    public static boolean execute(boolean rtn, Object stat) {
        if (stat == null) {
            return rtn;
        }
        try {
            TraceSQL.end((LocalContext)stat, (byte)16, 0);
        }
        catch (Throwable t) {
            TraceSQL.profileLog(t);
        }
        return rtn;
    }

    private static void profileLog(Throwable t) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx != null) {
            ctx.sql = null;
            ctx.executed_sqlhash = 0;
        }
        Logger.println("TR-SQL-ERR", 30, t);
    }

    private static void end(LocalContext lCtx, byte xtype, int update) {
        TraceContext ctx = lCtx.context;
        SqlStepX step = (SqlStepX)lCtx.step;
        if (ctx == null) {
            step.elapsed = (int)(DateUtil.nanoToMillis() - lCtx.time1);
            if (step.elapsed > ConfTrace.trace_error_sql_time_max) {
                ErrorArg arg = new ErrorArg();
                arg.exception = WHATAP_ERROR.slow_sql;
                arg.message = WHATAP_ERROR.slow_sql.getMessage();
                arg.appendSql(step.hash);
                step.error = StatError.getInstance().addError(arg);
            }
            StatSql.getInstance().addSqlTime(0, step.dbc, step.hash, step.elapsed, step.error != 0L);
        } else {
            step.elapsed = ctx.getElapsedTime() - step.start_time;
            if (step.elapsed > ConfTrace.trace_error_sql_time_max) {
                ErrorArg arg = new ErrorArg();
                arg.exception = WHATAP_ERROR.slow_sql;
                arg.message = WHATAP_ERROR.slow_sql.getMessage();
                arg.setTraceCtx(ctx);
                arg.appendSql(step.hash);
                step.error = StatError.getInstance().addError(arg);
                ExceptionAlert.getInstance().jdbc(ctx, ctx.sqlText, arg);
            }
            step.xtype = (byte)(step.xtype | xtype);
            ctx.executed_dbc = step.dbc;
            ctx.executed_sqlhash = step.hash;
            ctx.sql = null;
            ctx.sqlText = null;
            ++ctx.sql_count;
            ctx.sql_time += step.elapsed;
            ctx.jdbc_update_record += update;
            MeterSQL.getInstance().add(step.dbc, step.elapsed, step.error != 0L);
            StatSql.getInstance().addSqlTime(ctx.service_hash, ctx.txid, step.dbc, step.hash, step.elapsed, step.error != 0L);
            ctx.profile.pop(step);
        }
    }

    public static void prepare(Object o, SqlParameter args, String sql) {
        if (args != null) {
            args.setSql(sql);
        }
    }

    public static void prepareInitAttach(Object o, String sql) {
    }

    public static boolean rsnext(boolean b, Object rs, ResultStat rt) {
        if (b) {
            if (rt != null) {
                ++rt.count;
            }
        } else if (rt != null && rt.ctx != null) {
            TraceSQL.fetch(rt.ctx, rt.sqlhash, rt.start, rt.count, rt.dbc);
            rt.ctx = null;
        }
        return b;
    }

    public static void rsclose(Object rs, ResultStat rt) {
        if (rt != null && rt.ctx != null) {
            TraceSQL.fetch(rt.ctx, rt.sqlhash, rt.start, rt.count, rt.dbc);
            rt.ctx = null;
        }
    }

    public static void fetch(TraceContext ctx, int sqlhash, long rs_start, int rs_count, int dbc) {
        try {
            long time = DateUtil.nanoToMillis() - rs_start;
            ResultSetStep p = new ResultSetStep();
            p.dbc = dbc;
            p.sqlhash = sqlhash;
            p.start_time = ctx.getElapsedTime();
            p.fetch = rs_count;
            p.elapsed = (int)time;
            ctx.profile.add(p);
            if (rs_count > ConfTrace.trace_error_jdbc_fetch_max) {
                ErrorArg arg = new ErrorArg();
                arg.exception = WHATAP_ERROR.too_many_records;
                arg.message = WHATAP_ERROR.too_many_records.getMessage();
                arg.setTraceCtx(ctx);
                arg.appendSql(sqlhash);
                StatError.getInstance().addError(arg);
            }
            ctx.rs_time += time;
            ctx.rs_count += rs_count;
            MeterSQL.getInstance().addFetch(p.dbc, p.fetch, p.elapsed);
            StatSql.getInstance().addFetch(ctx.service_hash, p.dbc, sqlhash, p.fetch, p.elapsed);
        }
        catch (Throwable t) {
            Logger.println("TR-SQL-ERR", 10, t);
        }
    }

    public static Object startCustomTrace(int dbc, String sql, String param2) {
        Configure conf = Configure.getInstance();
        if (!conf.sql_enabled) {
            return null;
        }
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx != null && ctx.sql != null) {
            return null;
        }
        if (sql == null) {
            sql = "null-sql";
        }
        ParsedSql psql = TraceSQL.escapeLiteral(sql);
        SqlStepX step = new SqlStepX();
        step.dbc = dbc;
        step.xtype = 1;
        if (ConfTrace.trace_sql_param_enabled) {
            BYTE crc = new BYTE();
            step.p1 = TraceSQL.toParamBytes(psql.param, crc);
            if (param2 != null) {
                step.p2 = TraceSQL.toParamBytes(param2, crc);
            }
            step.pcrc = crc.value;
        }
        if (ConfTrace._has_ignore_sql && psql != null && ConfTrace.ignore_sql_hash_set.contains(psql.sqlHash)) {
            return null;
        }
        LocalContext lctx = new LocalContext(ctx, step);
        return TraceSQL.start(lctx, psql, sql);
    }

    public static Object start(Object o, SqlParameter sqlparam) {
        return TraceSQL.start(o, sqlparam, (byte)1);
    }

    public static Object start(Object o, SqlParameter sqlparam, byte xtype) {
        if (!TraceSQL.conf.sql_enabled || sqlparam != null && HashUtil.hash(sqlparam.getSql()) == 0) {
            return null;
        }
        try {
            SID sid;
            int hash;
            ParsedSql psql;
            String sql;
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (ctx != null && ctx.sql != null) {
                if (ConfTrace.debug_sql_nested) {
                    Logger.println("SQL_NESTED_PSTMT", 10, "pstmt nested called " + (sqlparam == null ? String.valueOf(o) : sqlparam.getSql()));
                }
                return null;
            }
            int dbc_hash = isql.getUrlHashFromStatement(o);
            if (TraceSQL.conf.trace_pstmt_sql_enabled && sqlparam != null) {
                sql = sqlparam.getSql();
                if (sql == null) {
                    sql = "sql is null";
                }
                if ((psql = TraceSQL.escapeLiteral(sql)) == null) {
                    sql = o.getClass().getName();
                    hash = HashUtil.hash(sql);
                    DataTextAgent.SQL.add(hash, sql);
                    psql = new ParsedSql('*', hash, null);
                }
            } else {
                sql = o.getClass().getName();
                sql = sqlparam == null ? sql + " param is null" : sql + " param=" + sqlparam.getCount();
                hash = HashUtil.hash(sql);
                DataTextAgent.SQL.add(hash, sql);
                psql = new ParsedSql('*', hash, null);
            }
            if (ConfTrace._has_ignore_sql && ConfTrace.ignore_sql_hash_set.contains(psql.sqlHash)) {
                return null;
            }
            SqlStepX step = new SqlStepX();
            step.dbc = dbc_hash;
            if (ConfDBC.dbc_sid_stmt_enabled && ctx != null && dbc_hash == ctx.dbc_hash && (sid = ctx.sid) != null) {
                step.sid = sid.sid;
                step.serial = sid.serial;
                step.inst = sid.inst;
            }
            step.xtype = xtype;
            if (ConfTrace.trace_sql_param_enabled) {
                BYTE crc = new BYTE();
                if (ConfPIIMask.pii_mask_sql_enabled) {
                    step.p1 = TraceSQL.toParamBytes(PiiMask.parseSqlP1(psql.sqlHash, psql.param), crc);
                    if (sqlparam != null) {
                        step.p2 = TraceSQL.toParamBytes(PiiMask.parseSqlP2(psql.sqlHash, sqlparam.toString()), crc);
                    }
                } else {
                    step.p1 = TraceSQL.toParamBytes(psql.param, crc);
                    if (sqlparam != null) {
                        step.p2 = TraceSQL.toParamBytes(sqlparam.toString(), crc);
                    }
                }
                step.pcrc = crc.value;
            }
            LocalContext lctx = new LocalContext(ctx, step);
            return TraceSQL.start(lctx, psql, sql);
        }
        catch (Throwable t) {
            Logger.println("TR-SQL-ERR-1", 30, t);
            return null;
        }
    }

    public static byte[] toParamBytes(String p, BYTE crc) {
        if (p == null || p.length() == 0) {
            return null;
        }
        switch (ConfTrace._sql_param_dump_mode) {
            case 4: {
                try {
                    byte[] b = p.getBytes(ConfTrace.trace_sql_param_encoding);
                    FileUtil.save(new File("sqlp-" + dumpName++ + ".dat"), b);
                    return ParamSecurity.encrypt(b, crc);
                }
                catch (UnsupportedEncodingException e) {
                    Logger.println("A140", 10, "sql param getBytes() encoding error");
                    return null;
                }
            }
            case 3: {
                try {
                    byte[] b = p.getBytes(ConfTrace.trace_sql_param_encoding);
                    return ParamSecurity.encrypt(b, crc);
                }
                catch (UnsupportedEncodingException e) {
                    Logger.println("A140", 10, "sql param getBytes() encoding error");
                    return null;
                }
            }
            case 2: {
                byte[] b = p.getBytes();
                FileUtil.save(new File("sqlp-" + dumpName++ + ".dat"), b);
                return ParamSecurity.encrypt(b, crc);
            }
        }
        byte[] b = p.getBytes();
        return ParamSecurity.encrypt(b, crc);
    }

    public static Object start(Object o) {
        if (!TraceSQL.conf.sql_enabled) {
            return null;
        }
        try {
            SID sid;
            String sql;
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (ctx != null && ctx.sql != null) {
                if (ConfTrace.debug_sql_nested) {
                    Logger.println("SQL_NESTED_NONE", 10, "sql nested called " + String.valueOf(o));
                }
                return null;
            }
            int dbc_hash = 0;
            ParsedSql psql = null;
            if (TraceSQL.conf.attach_pstmt_enabled && (sql = ReflectPstmtProxy.getSql(o)) != null) {
                psql = TraceSQL.escapeLiteral(sql);
            }
            if (psql == null) {
                TextValue conName = new TextValue();
                dbc_hash = isql.getUrlHashFromStatement(o, conName);
                String sql2 = o.getClass().getName() + " " + conName.value;
                int hash = HashUtil.hash(sql2);
                DataTextAgent.SQL.add(hash, sql2);
                psql = new ParsedSql('*', hash, null);
            } else {
                dbc_hash = isql.getUrlHashFromStatement(o);
            }
            if (ConfTrace._has_ignore_sql && ConfTrace.ignore_sql_hash_set.contains(psql.sqlHash)) {
                return null;
            }
            SqlStepX step = new SqlStepX();
            step.dbc = dbc_hash;
            if (ConfDBC.dbc_sid_stmt_enabled && ctx != null && dbc_hash == ctx.dbc_hash && (sid = ctx.sid) != null) {
                step.sid = sid.sid;
                step.serial = sid.serial;
                step.inst = sid.inst;
            }
            step.xtype = 1;
            if (ConfTrace.trace_sql_param_enabled) {
                BYTE crc = new BYTE();
                step.p1 = TraceSQL.toParamBytes(psql.param, crc);
                step.pcrc = crc.value;
                if (ctx != null && ctx.sqlParam != null) {
                    String p2 = ctx.sqlParam.toString();
                    step.p2 = TraceSQL.toParamBytes(p2, crc);
                    step.pcrc = crc.value;
                    ctx.sqlParam = null;
                }
            }
            LocalContext lctx = new LocalContext(ctx, step);
            return TraceSQL.start(lctx, psql, null);
        }
        catch (Throwable t) {
            Logger.println("TR-SQL-ERR-2", 30, t);
            return null;
        }
    }

    public static Object start(Object o, String sql) {
        if (!TraceSQL.conf.sql_enabled) {
            return null;
        }
        try {
            SID sid;
            int hash;
            ParsedSql psql;
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (ctx != null && (ctx.sql != null || ctx.jdbc_stmt_loading_sid)) {
                if (ConfTrace.debug_sql_nested) {
                    Logger.println("SQL_NESTED_STMT", 10, "stmt nested called " + sql);
                }
                return null;
            }
            if (sql == null) {
                sql = "sql is null";
            }
            int dbc_hash = isql.getUrlHashFromStatement(o);
            if (TraceSQL.conf.trace_stmt_sql_enabled) {
                psql = TraceSQL.escapeLiteral(sql);
                if (psql == null) {
                    sql = o.getClass().getName();
                    hash = HashUtil.hash(sql);
                    DataTextAgent.SQL.add(hash, sql);
                    psql = new ParsedSql('*', hash, null);
                }
            } else {
                sql = o.getClass().getName();
                hash = HashUtil.hash(sql);
                DataTextAgent.SQL.add(hash, sql);
                psql = new ParsedSql('*', hash, null);
            }
            if (ConfTrace._has_ignore_sql && ConfTrace.ignore_sql_hash_set.contains(psql.sqlHash)) {
                return null;
            }
            SqlStepX step = new SqlStepX();
            step.dbc = dbc_hash;
            if (ConfDBC.dbc_sid_stmt_enabled && ctx != null && dbc_hash == ctx.dbc_hash && (sid = ctx.sid) != null) {
                step.sid = sid.sid;
                step.serial = sid.serial;
                step.inst = sid.inst;
            }
            step.xtype = 0;
            if (ConfTrace.trace_sql_param_enabled) {
                BYTE crc = new BYTE();
                step.p1 = ConfPIIMask.pii_mask_sql_enabled ? TraceSQL.toParamBytes(PiiMask.parseSqlP1(psql.sqlHash, psql.param), crc) : TraceSQL.toParamBytes(psql.param, crc);
                step.pcrc = crc.value;
            }
            LocalContext lctx = new LocalContext(ctx, step);
            return TraceSQL.start(lctx, psql, sql);
        }
        catch (Throwable t) {
            Logger.println("TR-SQL-ERR-3", 30, t);
            return null;
        }
    }

    private static Object start(LocalContext lctx, ParsedSql psql, String sql) {
        SqlStepX step = (SqlStepX)lctx.step;
        TraceContext ctx = lctx.context;
        step.hash = psql != null ? psql.sqlHash : 0;
        if (ctx == null) {
            lctx.time1 = DateUtil.nanoToMillis();
        } else {
            step.start_time = ctx.getElapsedTime();
            if (ConfTrace.trace_sql_resource_enabled) {
                step.start_cpu = (int)(SysJMX.getThreadCPU(ctx.thread.getId()) - ctx.start_cpu);
                if (TraceSQL.conf.trace_malloc_step_enabled) {
                    step.start_mem = (int)(SysJMX.getThreadAllocBytes(ctx.thread.getId()) - ctx.start_malloc);
                }
            }
            if (ConfTrace._trace_position_sql_hash != 0) {
                BuildPos.profileSqlPos(step, sql);
            }
            ctx.profile.push(step);
            ctx.sql = step;
            ctx.sqlText = sql;
        }
        return lctx;
    }

    public static void customOpen(String method) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return;
        }
        if (ConfTrace.trace_custom_leak_enabled) {
            if (CUSTOM_OPEN == 0) {
                CUSTOM_OPEN = HashUtil.hash("CustomOpen");
                DataTextAgent.MESSAGE.add(CUSTOM_OPEN, "CustomOpen");
            }
            MessageStep step = new MessageStep();
            step.start_time = ctx.getElapsedTime();
            step.hash = CUSTOM_OPEN;
            if (ctx.customLeak <= 0) {
                ++ctx.customLeak;
                try {
                    step.desc = method;
                    ctx.profile.add(step);
                }
                catch (Throwable throwable) {}
            } else {
                try {
                    step.desc = "ignore " + method;
                    ctx.profile.add(step);
                }
                catch (Throwable throwable) {}
            }
        } else if (ctx.customLeak <= 0) {
            ++ctx.customLeak;
        }
    }

    public static void customClose(String method) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return;
        }
        if (ConfTrace.trace_custom_leak_enabled) {
            if (CUSTOM_CLOSE == 0) {
                CUSTOM_CLOSE = HashUtil.hash("CustomClose");
                DataTextAgent.MESSAGE.add(CUSTOM_CLOSE, "CustomClose");
            }
            MessageStep step = new MessageStep();
            step.start_time = ctx.getElapsedTime();
            step.hash = CUSTOM_CLOSE;
            if (ctx.customLeak > 0) {
                --ctx.customLeak;
                try {
                    step.desc = method;
                    ctx.profile.add(step);
                }
                catch (Throwable throwable) {}
            } else {
                try {
                    step.desc = "ignore " + method;
                    ctx.profile.add(step);
                }
                catch (Throwable throwable) {}
            }
        } else if (ctx.customLeak > 0) {
            --ctx.customLeak;
        }
    }

    public static Object drmOpenStart(String url) {
        if (!ConfTrace.trace_connection_open_enabled) {
            return null;
        }
        try {
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (ctx == null || ctx.db_opening) {
                return null;
            }
            ctx.db_opening = true;
            DBCStep p = new DBCStep();
            p.start_time = ctx.getElapsedTime();
            ctx.profile.push(p);
            LocalContext lctx = new LocalContext(ctx, p);
            lctx.option = url == null ? "unknown" : url;
            return lctx;
        }
        catch (Throwable t) {
            Logger.println("DBCON", 10, "drm open start error ", t, dbc_log++ < 1000L);
            return null;
        }
    }

    protected static int toHash(String url) {
        int dbc_hash = driver_hash.get(url.hashCode());
        if (dbc_hash == 0) {
            dbc_hash = HashUtil.hash(url);
            DataTextAgent.dbc(dbc_hash, url);
            driver_hash.put(url.hashCode(), dbc_hash);
        }
        return dbc_hash;
    }

    public static Object drmOpenEnd(Object conn, Object stat) {
        if (stat == null) {
            return conn;
        }
        try {
            int dbc_hash;
            LocalContext lctx = (LocalContext)stat;
            TraceContext ctx = lctx.context;
            if (ctx == null) {
                return conn;
            }
            ctx.db_opening = false;
            DBCStep step = (DBCStep)lctx.step;
            if (step == null) {
                return conn;
            }
            String url = (String)lctx.option;
            step.hash = dbc_hash = TraceSQL.toHash(url);
            step.elapsed = ctx.getElapsedTime() - step.start_time;
            ctx.dbc_time += step.elapsed;
            ctx.profile.pop(step);
            if (ConfDebug.debug_dbc_stack_enabled) {
                String stack = ThreadUtil.getStackTrace(Thread.currentThread().getStackTrace(), 2);
                MessageStep m = new MessageStep();
                m.start_time = ctx.getElapsedTime();
                m.hash = HashUtil.hash("Open Connection Stack");
                DataTextAgent.MESSAGE.add(m.hash, "Open Connection Stack");
                m.desc = stack;
                ctx.profile.add(m);
            }
            if (TraceSQL.conf.trace_dbc_leak_enabled) {
                if (ctx.unclosedConnMap == null) {
                    ctx.unclosedConnMap = new IntKeyMap(31, 0.7f);
                }
                if (TraceSQL.conf.trace_dbc_leak_fullstack_enabled) {
                    ctx.unclosedConnMap.put(System.identityHashCode(conn), Thread.currentThread().getStackTrace());
                } else {
                    ctx.unclosedConnMap.put(System.identityHashCode(conn), new StackTraceElement[0]);
                }
            }
            LogSinkRemoteAccessStatus.dbcOk(dbc_hash, "DriverManager", null);
            if (TraceSQL.conf.trace_dbc_wrap_enabled) {
                return isql.wrapConnection(conn, dbc_hash, ctx.service_hash);
            }
        }
        catch (Throwable t) {
            Logger.println("DriverManager", 10, "drm open end error ", t, dbc_log++ < 1000L);
        }
        return conn;
    }

    public static void drmOpenEnd(Object stat, Throwable thr) {
        if (stat == null) {
            return;
        }
        try {
            LocalContext lctx = (LocalContext)stat;
            DBCStep step = (DBCStep)lctx.step;
            if (step == null) {
                return;
            }
            TraceContext ctx = lctx.context;
            if (ctx == null) {
                return;
            }
            ctx.db_opening = false;
            step.elapsed = ctx.getElapsedTime() - step.start_time;
            ctx.dbc_time += step.elapsed;
            if (thr != null) {
                ErrorArg arg = new ErrorArg();
                arg.exception = WHATAP_ERROR.connection_open_fail;
                arg.message = thr.getMessage();
                arg.setTraceCtx(ctx);
                StatError.getInstance().addError(arg);
                step.error = arg.messageHash;
                ctx.handleSqlErrorStack(thr);
            }
            ctx.profile.pop(step);
            if (ConfDebug.debug_dbc_stack_enabled) {
                String stack = ThreadUtil.getStackTrace(Thread.currentThread().getStackTrace(), 2);
                MessageStep m = new MessageStep();
                m.start_time = ctx.getElapsedTime();
                m.hash = HashUtil.hash("Open Connection Stack");
                DataTextAgent.MESSAGE.add(m.hash, "Open Connection Stack");
                m.desc = stack;
                ctx.profile.add(m);
            }
        }
        catch (Throwable t) {
            Logger.println("DBCON", 10, "drm open end error ", t, dbc_log++ < 1000L);
        }
    }

    public static Object dbcOpenStart(String classname, Object pool) {
        if (!ConfTrace.trace_connection_open_enabled) {
            return null;
        }
        try {
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (ctx == null || ctx.db_opening) {
                return null;
            }
            ctx.db_opening = true;
            DBCStep p = new DBCStep();
            p.start_time = ctx.getElapsedTime();
            ctx.profile.push(p);
            LocalContext lctx = new LocalContext(ctx, p);
            lctx.option = classname;
            lctx.option2 = pool;
            return lctx;
        }
        catch (Throwable t) {
            Logger.println("DBCON", 10, "dbc open start error ", t, dbc_log++ < 1000L);
            return null;
        }
    }

    public static Object dbcOpenEnd(Object conn, Object stat) {
        if (stat == null) {
            return conn;
        }
        try {
            int dbc_hash;
            LocalContext lctx = (LocalContext)stat;
            TraceContext ctx = lctx.context;
            if (ctx == null) {
                return conn;
            }
            ctx.db_opening = false;
            DBCStep step = (DBCStep)lctx.step;
            if (step == null) {
                return conn;
            }
            step.hash = dbc_hash = isql.getURLHashFromConnection((String)lctx.option, conn);
            step.elapsed = ctx.getElapsedTime() - step.start_time;
            ctx.dbc_time += step.elapsed;
            if (ConfDBC.dbc_sid_enabled) {
                long now;
                SID sid = isql.getConnectionSid(conn);
                if (sid != null) {
                    step.sid = sid.sid;
                    step.serial = sid.serial;
                    step.inst = sid.inst;
                    ctx.sid = sid;
                    ctx.dbc_hash = dbc_hash;
                }
                if (ConfDBC.debug_dbc_sid_enabled && (now = System.currentTimeMillis()) - last_log > 5000L) {
                    last_log = now;
                    Logger.info("DBCSID", conn.getClass().getName() + " " + sid);
                }
            }
            ctx.profile.pop(step);
            if (ConfDebug.debug_dbc_stack_enabled) {
                String stack = ThreadUtil.getStackTrace(Thread.currentThread().getStackTrace(), 2);
                MessageStep m = new MessageStep();
                m.start_time = ctx.getElapsedTime();
                m.hash = HashUtil.hash("Open Connection Stack");
                DataTextAgent.MESSAGE.add(m.hash, "Open Connection Stack");
                m.desc = stack;
                ctx.profile.add(m);
            }
            if (TraceSQL.conf.trace_dbc_leak_enabled) {
                if (ctx.unclosedConnMap == null) {
                    ctx.unclosedConnMap = new IntKeyMap(31, 0.7f);
                }
                int id = isql.getHashKey(conn);
                if (TraceSQL.conf.trace_dbc_leak_fullstack_enabled) {
                    ctx.unclosedConnMap.put(id, Thread.currentThread().getStackTrace());
                } else {
                    ctx.unclosedConnMap.put(id, new StackTraceElement[0]);
                }
            }
            LogSinkRemoteAccessStatus.dbcOk(dbc_hash, lctx.option, lctx.option2);
            if (TraceSQL.conf.trace_dbc_wrap_enabled) {
                return isql.wrapConnection(conn, dbc_hash, ctx.service_hash);
            }
        }
        catch (Throwable t) {
            Logger.println("DBCON", 10, "dbc open end error ", t, dbc_log++ < 1000L);
        }
        return conn;
    }

    public static void dbcOpenEnd(Object stat, Throwable thr) {
        if (stat == null) {
            return;
        }
        try {
            LocalContext lctx = (LocalContext)stat;
            DBCStep step = (DBCStep)lctx.step;
            if (step == null) {
                return;
            }
            TraceContext ctx = lctx.context;
            if (ctx == null) {
                return;
            }
            ctx.db_opening = false;
            step.elapsed = ctx.getElapsedTime() - step.start_time;
            ctx.dbc_time += step.elapsed;
            if (thr != null) {
                ErrorArg arg = new ErrorArg();
                arg.exception = WHATAP_ERROR.connection_open_fail;
                arg.message = thr.getMessage();
                arg.setTraceCtx(ctx);
                StatError.getInstance().addError(arg);
                step.error = arg.messageHash;
                MeterSQL.getInstance().addDBC(step.hash, step.elapsed, true);
                ExceptionAlert.getInstance().jdbc(ctx, null, arg);
                LogSinkRemoteAccessStatus.dbcError(thr.getMessage(), lctx.option, lctx.option2);
                ctx.handleSqlErrorStack(thr);
            }
            ctx.profile.pop(step);
            if (ConfDebug.debug_dbc_stack_enabled) {
                String stack = ThreadUtil.getStackTrace(Thread.currentThread().getStackTrace(), 2);
                MessageStep m = new MessageStep();
                m.start_time = ctx.getElapsedTime();
                m.hash = HashUtil.hash("Open Connection Stack");
                DataTextAgent.MESSAGE.add(m.hash, "Open Connection Stack");
                m.desc = stack;
                ctx.profile.add(m);
            }
        }
        catch (Throwable t) {
            Logger.println("DBCON", 10, "dbc open end error ", t, dbc_log++ < 1000L);
        }
    }

    public static int toInt(boolean b) {
        return b ? -1 : -2;
    }

    public static int getIntArraySum(int[] arr) {
        int sum = 0;
        for (int i = arr.length - 1; i >= 0; --i) {
            sum += arr[i];
        }
        return sum;
    }

    public static int updateCount(int rtn, Object o) {
        return rtn;
    }

    public static Object getResultSet(Object rs) {
        return rs;
    }

    public static void set(SqlParameter args, int idx, boolean p) {
        if (args != null) {
            args.put(idx, Boolean.toString(p));
        }
    }

    public static void set(SqlParameter args, int idx, int p) {
        if (args != null) {
            args.put(idx, Integer.toString(p));
        }
    }

    public static void set(SqlParameter args, int idx, float p) {
        if (args != null) {
            args.put(idx, Float.toString(p));
        }
    }

    public static void set(SqlParameter args, int idx, long p) {
        if (args != null) {
            args.put(idx, Long.toString(p));
        }
    }

    public static void set(SqlParameter args, int idx, double p) {
        if (args != null) {
            args.put(idx, Double.toString(p));
        }
    }

    public static void set(SqlParameter args, int idx, String p) {
        if (args == null) {
            return;
        }
        if (p == null) {
            args.put(idx, "null");
            return;
        }
        int limit = ConfTrace.trace_sql_param_length;
        int len = p.length();
        if (ConfTrace.trace_sql_param_show_length_enabled && len > limit) {
            String v = new StringBuilder(limit + 20).append('\'').append(p, 0, limit).append('\'').append("...(").append(len).append(')').toString();
            args.put(idx, v);
            return;
        }
        if (len > limit) {
            p = p.substring(0, limit);
        }
        String v = new StringBuilder(p.length() + 10).append('\'').append(p).append('\'').toString();
        args.put(idx, v);
    }

    public static void set(SqlParameter args, int idx, Object p) {
        if (args == null) {
            return;
        }
        if (p == null) {
            args.put(idx, "null");
            return;
        }
        if (p instanceof String) {
            String s = (String)p;
            int limit = ConfTrace.trace_sql_param_length;
            int len = s.length();
            if (ConfTrace.trace_sql_param_show_length_enabled && len > limit) {
                String v = new StringBuilder(limit + 20).append('\'').append(s, 0, limit).append('\'').append("...(").append(len).append(')').toString();
                args.put(idx, v);
                return;
            }
            if (len > limit) {
                s = s.substring(0, limit);
            }
            String v = new StringBuilder(s.length() + 10).append('\'').append(s).append('\'').toString();
            args.put(idx, v);
            return;
        }
        if (p instanceof Number) {
            args.put(idx, p.toString());
            return;
        }
        Class<?> cls = p.getClass();
        boolean isArray = cls.isArray();
        boolean javaTimeEnabled = ConfTrace.trace_sql_param_javatime_enabled;
        if (p instanceof Date) {
            args.put(idx, TraceSQL.quote(p));
            return;
        }
        if (javaTimeEnabled) {
            String name = cls.getName();
            if (name.startsWith("java.time") || name.endsWith("Timestamp")) {
                args.put(idx, TraceSQL.quote(p));
                return;
            }
            if (isArray) {
                args.put(idx, TraceSQL.arrayLenString(Array.getLength(p)));
                return;
            }
            args.put(idx, cls.getSimpleName());
            return;
        }
        if (isArray) {
            args.put(idx, TraceSQL.arrayLenString(Array.getLength(p)));
        } else {
            args.put(idx, cls.getSimpleName());
        }
    }

    private static String quote(Object o) {
        String s = String.valueOf(o);
        return new StringBuilder(s.length() + 2).append('\'').append(s).append('\'').toString();
    }

    private static String arrayLenString(int len) {
        return new StringBuilder(20).append("array[").append(len).append(']').toString();
    }

    public static void setParam(int idx, boolean p) {
        if (ConfTrace.trace_sql_param_enabled) {
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (ctx == null) {
                return;
            }
            if (ctx.sqlParam == null) {
                ctx.sqlParam = new SqlParameter();
            }
            ctx.sqlParam.put(idx, Boolean.toString(p));
        }
    }

    public static void setParam(int idx, int p) {
        if (ConfTrace.trace_sql_param_enabled) {
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (ctx == null) {
                return;
            }
            if (ctx.sqlParam == null) {
                ctx.sqlParam = new SqlParameter();
            }
            ctx.sqlParam.put(idx, Integer.toString(p));
        }
    }

    public static void setParam(int idx, float p) {
        if (ConfTrace.trace_sql_param_enabled) {
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (ctx == null) {
                return;
            }
            if (ctx.sqlParam == null) {
                ctx.sqlParam = new SqlParameter();
            }
            ctx.sqlParam.put(idx, Float.toString(p));
        }
    }

    public static void setParam(int idx, long p) {
        if (ConfTrace.trace_sql_param_enabled) {
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (ctx == null) {
                return;
            }
            if (ctx.sqlParam == null) {
                ctx.sqlParam = new SqlParameter();
            }
            ctx.sqlParam.put(idx, Long.toString(p));
        }
    }

    public static void setParam(int idx, double p) {
        if (ConfTrace.trace_sql_param_enabled) {
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (ctx == null) {
                return;
            }
            if (ctx.sqlParam == null) {
                ctx.sqlParam = new SqlParameter();
            }
            ctx.sqlParam.put(idx, Double.toString(p));
        }
    }

    public static void setParam(int idx, String p) {
        if (ConfTrace.trace_sql_param_enabled) {
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (ctx == null) {
                return;
            }
            if (ctx.sqlParam == null) {
                ctx.sqlParam = new SqlParameter();
            }
            SqlParameter args = ctx.sqlParam;
            if (p == null) {
                args.put(idx, "null");
            } else {
                if (p.length() > ConfTrace.trace_sql_param_length) {
                    p = p.substring(0, ConfTrace.trace_sql_param_length);
                }
                args.put(idx, "'" + p + "'");
            }
        }
    }

    public static void setParam(int idx, Object p) {
        if (ConfTrace.trace_sql_param_enabled) {
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (ctx == null) {
                return;
            }
            if (ctx.sqlParam == null) {
                ctx.sqlParam = new SqlParameter();
            }
            SqlParameter args = ctx.sqlParam;
            if (p == null) {
                args.put(idx, "null");
            } else if (p instanceof String) {
                String s = (String)p;
                if (s.length() > ConfTrace.trace_sql_param_length) {
                    s = s.substring(0, ConfTrace.trace_sql_param_length);
                }
                args.put(idx, "'" + s + "'");
            } else if (p instanceof Number) {
                args.put(idx, p.toString());
            } else {
                String s = p instanceof Date ? "'" + p + "'" : (p.getClass().isArray() ? "array[" + Array.getLength(p) + "]" : p.getClass().getSimpleName());
                args.put(idx, s);
            }
        }
    }

    public static void clear(Object o, SqlParameter args) {
        if (args != null) {
            args.clear();
        }
    }

    public static int dbcOpenCustom(String dbc_url, Throwable thr, int elapsed) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx != null) {
            int dbc_hash = 0;
            if (dbc_url != null) {
                dbc_hash = HashUtil.hash(dbc_url);
                DataTextAgent.dbc(dbc_hash, dbc_url);
            } else {
                dbc_url = "custom";
            }
            DBCStep p = new DBCStep();
            p.start_time = ctx.getElapsedTime() - elapsed;
            p.hash = dbc_hash;
            p.elapsed = elapsed;
            ctx.dbc_time += elapsed;
            if (thr != null) {
                ErrorArg arg = new ErrorArg();
                arg.exception = WHATAP_ERROR.connection_open_fail;
                arg.message = thr.getMessage();
                arg.setTraceCtx(ctx);
                StatError.getInstance().addError(arg);
                p.error = arg.messageHash;
                LogSinkRemoteAccessStatus.dbcError(thr.getMessage(), dbc_url, null);
            }
            ctx.profile.add(p);
            return dbc_hash;
        }
        return 0;
    }

    public static void stmtInit(Object stmt) {
        TraceContext ctx;
        if (TraceSQL.conf.trace_stmt_leak_enabled && (ctx = TraceContextManager.getLocalContext()) != null) {
            if (ctx.unclosedStmtMap == null) {
                ctx.unclosedStmtMap = new IntKeyMap(31, 0.7f);
            }
            if (TraceSQL.conf.trace_stmt_leak_fullstack_enabled) {
                ctx.unclosedStmtMap.put(System.identityHashCode(stmt), Thread.currentThread().getStackTrace());
            } else {
                ctx.unclosedStmtMap.put(System.identityHashCode(stmt), new StackTraceElement[0]);
            }
        }
    }

    public static void stmtClose(Object stmt) {
        TraceContext ctx;
        if (TraceSQL.conf.trace_stmt_leak_enabled && (ctx = TraceContextManager.getLocalContext()) != null && ctx.unclosedStmtMap != null) {
            ctx.unclosedStmtMap.remove(System.identityHashCode(stmt));
        }
    }

    public static Object dbcCloseStart(int closeMethodFullHash, String closeMethodFull, Object conn) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return null;
        }
        if (ctx.unclosedConnMap != null) {
            int id = isql.getHashKey(conn);
            ctx.unclosedConnMap.remove(id);
        }
        if (!TraceSQL.conf.trace_dbc_close_enabled) {
            return null;
        }
        DataTextAgent.METHOD.add(closeMethodFullHash, closeMethodFull);
        MethodStepX p = new MethodStepX();
        p.start_time = ctx.getElapsedTime();
        p.hash = closeMethodFullHash;
        if (ConfTrace.trace_method_resource_enabled) {
            p.start_cpu = (int)(SysJMX.getThreadCPU(ctx.thread.getId()) - ctx.start_cpu);
            if (TraceSQL.conf.trace_malloc_step_enabled) {
                p.start_mem = (int)(SysJMX.getThreadAllocBytes(ctx.thread.getId()) - ctx.start_malloc);
            }
        }
        ctx.profile.push(p);
        return new LocalContext(ctx, p);
    }

    public static void dbcCloseEnd(Object localContext, Throwable thr) {
        if (localContext == null) {
            return;
        }
        LocalContext lctx = (LocalContext)localContext;
        MethodStepX step = (MethodStepX)lctx.step;
        if (step == null) {
            return;
        }
        TraceContext ctx = lctx.context;
        if (ctx == null) {
            return;
        }
        step.elapsed = ctx.getElapsedTime() - step.start_time;
        ctx.profile.pop(step);
        ++ctx.method_count;
        ctx.method_time += step.elapsed;
        if (thr != null) {
            ErrorArg arg = new ErrorArg();
            arg.exception = thr;
            arg.message = thr.getMessage();
            arg.setTraceCtx(ctx);
            StatError.getInstance().addError(arg);
            ctx.handleSqlErrorStack(thr);
        }
    }

    static {
        DataTextAgent.resets.put("TraceSQL", new Runnable(){

            public void run() {
                checkedSql.clear();
                nonLiteSql.clear();
            }
        });
        logStackNum = 0L;
        conf = Configure.getInstance();
        dumpName = 1;
        driver_hash = new IntIntLinkedMap();
        last_log = System.currentTimeMillis();
        dbc_log = 0L;
    }
}

