/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace.httpc.urlnorm;

import whatap.agent.Configure;
import whatap.agent.trace.httpc.urlnorm.HttpcURLNormProxy;
import whatap.agent.trace.httpc.urlnorm.HttpcURLPrefix;
import whatap.lang.step.HttpcStepX;

public class HttpcUrlNorm {
    static Configure conf = Configure.getInstance();

    public static String normalize(String url) {
        if (url == null || url.length() == 0) {
            return "";
        }
        String url2 = HttpcURLPrefix.normalize(url);
        if (url2 != url) {
            return url2;
        }
        if (HttpcUrlNorm.conf.trace_httpc_trim_enabled) {
            url = HttpcUrlNorm.trim(url);
        }
        if (HttpcUrlNorm.conf.trace_httpc_normalize_enabled) {
            return HttpcURLNormProxy.normalize(url);
        }
        return url;
    }

    public static String normalize(String url, HttpcStepX step) {
        if (url == null || url.length() == 0) {
            return "";
        }
        String url2 = HttpcURLPrefix.normalize(url);
        if (url2 != url) {
            step.originUrl = url2;
            return url2;
        }
        if (HttpcUrlNorm.conf.trace_httpc_trim_enabled) {
            url = HttpcUrlNorm.trim(url);
        }
        if (HttpcUrlNorm.conf.trace_httpc_normalize_enabled && (url2 = HttpcURLNormProxy.normalize(url)) != url) {
            step.originUrl = url2;
            return url2;
        }
        return url;
    }

    private static String trim(String url) {
        StringBuilder sb = new StringBuilder(url.length());
        int len = Math.min(url.length(), 200);
        block4: for (int i = 0; i < len; ++i) {
            char c = url.charAt(i);
            switch (c) {
                case ' ': {
                    continue block4;
                }
                case '#': 
                case '+': 
                case '=': 
                case '?': {
                    return sb.toString();
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.length() == len ? url : sb.toString();
    }
}

