/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace.httpc;

import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfMTrace;
import whatap.agent.conf.ConfTrace;
import whatap.agent.plugin.PluginHttpCallEnd;
import whatap.agent.plugin.PluginHttpCallStart;
import whatap.agent.proxy.IHttpClient;
import whatap.agent.proxy.SpringRestFactory;
import whatap.agent.trace.HookArgs;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.httpc.HttpcTraceHelper;
import whatap.agent.trace.httpc.urlnorm.HttpcUrlNorm;
import whatap.lang.step.HttpcStepX;
import whatap.util.IntKeyLinkedMap;

public class ForSpringRest
implements HttpcTraceHelper.IHelper {
    private boolean ok = true;
    private String driver;
    private static IntKeyLinkedMap<IHttpClient> httpclients = new IntKeyLinkedMap().setMax(5);
    Configure conf = Configure.getInstance();

    public ForSpringRest(String driver) {
        this.driver = driver;
    }

    public boolean start(TraceContext ctx, HttpcStepX step, HookArgs hookPoint) {
        step.driver = this.driver;
        try {
            if (!this.ok) {
                ctx.httpc_url = hookPoint.class1 + "." + hookPoint.method;
            } else if (hookPoint.args != null && hookPoint.args.length >= 2) {
                IHttpClient httpclient = this.getProxy(hookPoint);
                ctx.httpc_host = httpclient.getHost(hookPoint.this1);
                ctx.httpc_port = httpclient.getPort(hookPoint.this1);
                ctx.httpc_url = httpclient.getURI(hookPoint.this1);
                ctx.httpc_url = ConfTrace.trace_origin_httpc_enabled ? HttpcUrlNorm.normalize(ctx.httpc_url, step) : HttpcUrlNorm.normalize(ctx.httpc_url);
                if ("".equals(ctx.httpc_url)) {
                    ctx.httpc_url = "/";
                }
                this.transfer(httpclient, ctx, step, hookPoint.this1);
            }
        }
        catch (Exception e) {
            this.ok = false;
            ctx.httpc_url = e.toString();
        }
        if (ctx.httpc_url == null) {
            ctx.httpc_url = hookPoint.class1;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IHttpClient getProxy(HookArgs hookPoint) {
        int key = System.identityHashCode(hookPoint.this1.getClass());
        IHttpClient httpclient = httpclients.get(key);
        if (httpclient == null) {
            ForSpringRest forSpringRest = this;
            synchronized (forSpringRest) {
                httpclient = SpringRestFactory.create(hookPoint.this1.getClass().getClassLoader());
                httpclients.put(key, httpclient);
            }
        }
        return httpclient;
    }

    private void transfer(IHttpClient httpclient, TraceContext ctx, HttpcStepX step, Object req) {
        if (ConfMTrace.mtrace_enabled) {
            String traceparent;
            httpclient.addHeader(req, ConfMTrace._trace_mtrace_poid_key, TraceContext.transferPOID());
            if (ConfMTrace.stat_mtrace_enabled) {
                httpclient.addHeader(req, ConfMTrace._trace_mtrace_spec_key1, ctx.transferSPEC_URL1());
            }
            if (ConfMTrace.mtid_mtrace_enabled && ctx.mtid != 0L) {
                httpclient.addHeader(req, ConfMTrace._trace_mtrace_caller_key, ctx.transferMTID_CALLERTX(step.stepId));
            }
            if (ConfMTrace.mtrace_traceparent_enabled && (traceparent = ctx.trasferMTID_TRACEPARENT(step.stepId)) != null) {
                httpclient.addHeader(req, ConfMTrace._trace_mtrace_traceparent_key, traceparent);
            }
        }
        PluginHttpCallStart.process(ctx, httpclient, req, req);
    }

    public HttpcTraceHelper.HttpcEndValue end(TraceContext ctx, HookArgs hookPoint, Throwable thr) {
        if (this.ok && hookPoint.returnValue != null) {
            try {
                HttpcTraceHelper.HttpcEndValue httpcEndValue = new HttpcTraceHelper.HttpcEndValue();
                IHttpClient httpclient = this.getProxy(hookPoint);
                httpcEndValue.exception = thr;
                httpcEndValue.status = httpclient.getStatus(hookPoint.returnValue);
                if (httpcEndValue.status >= 400) {
                    httpcEndValue.status_reason = httpclient.getStatusReason(hookPoint.returnValue);
                }
                PluginHttpCallEnd.process(ctx, httpcEndValue);
                return httpcEndValue;
            }
            catch (Throwable e) {
                this.ok = false;
                Logger.println("HTTPC-SPRING", 10, e);
            }
        }
        return null;
    }
}

