/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace;

import whatap.agent.conf.ConfThrottle;
import whatap.agent.trace.TraceContext;
import whatap.lang.conf.ConfObserver;
import whatap.util.IPUtil;
import whatap.util.StringUtil;

public class RejectUtil {
    static boolean hasParam;
    static boolean orgUrl;
    static boolean orgIp;
    static boolean orgHost;

    public static String getRejectUrl(String url, TraceContext ctx) {
        if (!hasParam || ctx == null || ctx.service_name == null) {
            return url;
        }
        StringBuffer sb = new StringBuffer(url.length() + ctx.service_name.length());
        sb.append(url).append("?");
        boolean flag = false;
        if (orgUrl) {
            sb.append("url=" + ctx.service_name);
            flag = true;
        }
        if (orgIp) {
            if (flag) {
                sb.append("&");
            }
            sb.append("ip=" + IPUtil.toString(ctx.remoteIp));
            flag = true;
        }
        if (orgHost) {
            if (flag) {
                sb.append("&");
            }
            sb.append("host=" + ctx.http_host);
            flag = true;
        }
        return sb.toString();
    }

    private static void set(String opt) {
        try {
            if (opt == null) {
                hasParam = false;
                return;
            }
            String[] tokens = StringUtil.tokenizer(opt, ",");
            orgUrl = false;
            orgIp = false;
            orgHost = false;
            for (int i = 0; tokens != null && i < tokens.length; ++i) {
                String p = tokens[i];
                if ("url".equals(p)) {
                    orgUrl = true;
                }
                if ("ip".equals(p)) {
                    orgIp = true;
                }
                if (!"host".equals(p)) continue;
                orgHost = true;
            }
            hasParam = orgUrl || orgIp || orgHost;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        RejectUtil.set(ConfThrottle.throttle_rejected_forward_param);
        ConfObserver.add("RejectUtil", new Runnable(){

            public void run() {
                RejectUtil.set(ConfThrottle.throttle_rejected_forward_param);
            }
        });
    }
}

