/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace;

import whatap.agent.conf.ConfTrace;
import whatap.agent.trace.IProfileCollector;
import whatap.lang.step.Step;

public class ProfileCircularCollector
implements IProfileCollector {
    protected final int BUFFER_LEN = ConfTrace.trace_step_max_count;
    protected final Step[] buffer = new Step[this.BUFFER_LEN];
    public int loop = 0;
    public int position = 0;
    public int this_index = 0;
    public int parent_index = -1;

    public boolean hasStep() {
        return this.position > 0;
    }

    public synchronized void push(Step step) {
        if (this.position >= this.BUFFER_LEN) {
            ++this.loop;
            this.position = 0;
        }
        step.index = this.this_index;
        step.parent = this.parent_index;
        this.parent_index = this.this_index++;
        this.buffer[this.position] = step;
        ++this.position;
    }

    public synchronized void add(Step step) {
        if (this.position >= this.BUFFER_LEN) {
            ++this.loop;
            this.position = 0;
        }
        step.index = this.this_index++;
        step.parent = this.parent_index;
        this.buffer[this.position] = step;
        ++this.position;
    }

    public synchronized void justAdd(Step step) {
        if (this.position >= this.BUFFER_LEN) {
            ++this.loop;
            this.position = 0;
        }
        this.buffer[this.position] = step;
        ++this.position;
        ++this.this_index;
    }

    public synchronized void addTail(Step step) {
        if (this.position >= this.BUFFER_LEN) {
            ++this.loop;
            this.position = 0;
        }
        step.index = this.this_index++;
        step.parent = this.parent_index;
        this.buffer[this.position] = step;
        ++this.position;
    }

    public synchronized void pop(Step step) {
        this.parent_index = step.parent;
    }

    public synchronized Step[] getLastSteps(int n) {
        if (this.loop == 0) {
            int cnt = this.position > n ? n : this.position;
            Step[] buff = new Step[cnt];
            int x = this.position - cnt;
            for (int i = 0; i < cnt; ++i) {
                buff[i] = this.buffer[x + i];
            }
            return buff;
        }
        int x = this.position - 1;
        int y = n - 1;
        Step[] buff = new Step[n];
        while (y >= 0) {
            if (x < 0) {
                x = this.BUFFER_LEN - 1;
            }
            buff[y--] = this.buffer[x--];
        }
        return buff;
    }

    public synchronized Step[] getSteps() {
        if (this.loop == 0) {
            if (this.position >= this.buffer.length) {
                return this.buffer;
            }
            Step[] buff = new Step[this.position];
            if (this.position > 0) {
                System.arraycopy(this.buffer, 0, buff, 0, this.position);
            }
            return buff;
        }
        if (this.position == 0) {
            return this.buffer;
        }
        Step[] buff = new Step[this.BUFFER_LEN];
        System.arraycopy(this.buffer, this.position, buff, 0, this.BUFFER_LEN - this.position);
        System.arraycopy(this.buffer, 0, buff, this.BUFFER_LEN - this.position, this.position);
        return buff;
    }

    public byte[] toBytes() {
        return Step.toBytes(this.getSteps());
    }

    public Step[] getStep4Error() {
        return this.getLastSteps(5);
    }

    public boolean isReal() {
        return true;
    }

    public synchronized void append(Step[] steps) {
        if (steps == null) {
            return;
        }
        for (int i = 0; i < steps.length; ++i) {
            this.add(steps[i]);
        }
    }

    public void append(int parentOffsetTime, Step[] steps) {
        if (steps == null) {
            return;
        }
        for (int i = 0; i < steps.length; ++i) {
            steps[i].start_time += parentOffsetTime;
            this.add(steps[i]);
        }
    }

    public int getSplitCount() {
        return 0;
    }

    public int length() {
        return this.loop * this.BUFFER_LEN + this.position;
    }
}

