/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace;

import whatap.agent.conf.ConfMTrace;
import whatap.util.KeyGen;

public class MTraceHelper {
    protected static int mtrace_real_rate = ConfMTrace.mtrace_rate;

    public static void updateMtraceAutoRate(float tps) {
        mtrace_real_rate = !ConfMTrace.mtrace_rate_configured ? (tps < 500.0f ? ConfMTrace.mtrace_rate : (int)((float)ConfMTrace.mtrace_rate * (500.0f / tps))) : ConfMTrace.mtrace_rate;
    }

    public static long createId(String userAgent) {
        if (ConfMTrace.mtrace_auto_enabled) {
            if (MTraceHelper.isMtraceable(userAgent)) {
                if (ConfMTrace.mtrace_alltx_enabled) {
                    return KeyGen.next();
                }
                long next = KeyGen.next();
                if (Math.abs(next / 100L % 100L) < (long)mtrace_real_rate) {
                    return next;
                }
            }
        } else {
            if (ConfMTrace.mtrace_alltx_enabled) {
                return KeyGen.next();
            }
            long next = KeyGen.next();
            if (Math.abs(next / 100L % 100L) < (long)mtrace_real_rate) {
                return next;
            }
        }
        return 0L;
    }

    public static boolean isMtraceable(String ua) {
        if (ua != null && ua.length() >= 3) {
            for (int i = 0; i < 3; ++i) {
                if (ua.charAt(i) == ConfMTrace.mtraceable_user_agent[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

