/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import whatap.agent.api.trace.TxChild;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletableFutureTrace {
    public static <T> Supplier<T> trace(final Supplier<T> f) {
        final TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return f;
        }
        final TraceContext cCtx = TxChild.startChild(ctx, "supplier");
        return new Supplier<T>(){

            @Override
            public T get() {
                if (cCtx != null) {
                    cCtx.thread = Thread.currentThread();
                    TraceContextManager.attach(cCtx);
                }
                try {
                    Object t = f.get();
                    return t;
                }
                finally {
                    if (cCtx != null) {
                        TxChild.endChild(cCtx, null);
                        if (!ctx.closed && ctx.thread == cCtx.thread) {
                            TraceContextManager.attach(ctx);
                        }
                    }
                }
            }
        };
    }

    public static Runnable trace(final Runnable f) {
        final TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return f;
        }
        final TraceContext cCtx = TxChild.startChild(ctx, "runnable");
        return new Runnable(){

            public void run() {
                if (cCtx != null) {
                    cCtx.thread = Thread.currentThread();
                    TraceContextManager.attach(cCtx);
                }
                try {
                    f.run();
                }
                finally {
                    if (cCtx != null) {
                        TxChild.endChild(cCtx, null);
                        if (!ctx.closed && ctx.thread == cCtx.thread) {
                            TraceContextManager.attach(ctx);
                        }
                    }
                }
            }
        };
    }

    public static <T> Consumer<T> trace(final Consumer<T> f) {
        final TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return f;
        }
        final TraceContext cCtx = TxChild.startChild(ctx, "consumer");
        return new Consumer<T>(){

            @Override
            public void accept(T t) {
                if (cCtx != null) {
                    cCtx.thread = Thread.currentThread();
                    TraceContextManager.attach(cCtx);
                }
                try {
                    f.accept(t);
                }
                finally {
                    if (cCtx != null) {
                        TxChild.endChild(cCtx, null);
                        if (!ctx.closed && ctx.thread == cCtx.thread) {
                            TraceContextManager.attach(ctx);
                        }
                    }
                }
            }
        };
    }

    public static <T> Callable<T> trace(final Callable<T> f) {
        final TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return f;
        }
        final TraceContext cCtx = TxChild.startChild(ctx, "callable");
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                if (cCtx != null) {
                    cCtx.thread = Thread.currentThread();
                    TraceContextManager.attach(cCtx);
                }
                try {
                    Object v = f.call();
                    return v;
                }
                finally {
                    if (cCtx != null) {
                        TxChild.endChild(cCtx, null);
                        if (!ctx.closed && ctx.thread == cCtx.thread) {
                            TraceContextManager.attach(ctx);
                        }
                    }
                }
            }
        };
    }

    public static <T> Future<T> trace(final Future<T> f) {
        final TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return f;
        }
        final TraceContext cCtx = TxChild.startChild(ctx, "future");
        return new Future<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return f.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return f.isCancelled();
            }

            @Override
            public boolean isDone() {
                return f.isDone();
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                if (cCtx != null) {
                    cCtx.thread = Thread.currentThread();
                    TraceContextManager.attach(cCtx);
                }
                try {
                    Object v = f.get(timeout, unit);
                    return v;
                }
                catch (InterruptedException e) {
                    if (cCtx != null) {
                        cCtx.handleMethodErrorStack(e);
                    }
                    throw e;
                }
                catch (ExecutionException e) {
                    if (cCtx != null) {
                        cCtx.handleMethodErrorStack(e);
                    }
                    throw e;
                }
                catch (TimeoutException e) {
                    if (cCtx != null) {
                        cCtx.handleMethodErrorStack(e);
                    }
                    throw e;
                }
                finally {
                    if (cCtx != null) {
                        TxChild.endChild(cCtx, null);
                        if (!ctx.closed && ctx.thread == cCtx.thread) {
                            TraceContextManager.attach(ctx);
                        }
                    }
                }
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                if (cCtx != null) {
                    cCtx.thread = Thread.currentThread();
                    TraceContextManager.attach(cCtx);
                }
                try {
                    Object v = f.get();
                    return v;
                }
                catch (InterruptedException e) {
                    if (cCtx != null) {
                        cCtx.handleMethodErrorStack(e);
                    }
                    throw e;
                }
                catch (ExecutionException e) {
                    if (cCtx != null) {
                        cCtx.handleMethodErrorStack(e);
                    }
                    throw e;
                }
                finally {
                    if (cCtx != null) {
                        TxChild.endChild(cCtx, null);
                        if (!ctx.closed && ctx.thread == cCtx.thread) {
                            TraceContextManager.attach(ctx);
                        }
                    }
                }
            }
        };
    }

    public static <T, R> Function<? super T, R> trace(final Function<? super T, R> f) {
        final TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return f;
        }
        final TraceContext cCtx = TxChild.startChild(ctx, "function");
        return new Function<T, R>(){

            @Override
            public R apply(T t) {
                if (cCtx != null) {
                    cCtx.thread = Thread.currentThread();
                    TraceContextManager.attach(cCtx);
                }
                try {
                    Object r = f.apply(t);
                    return r;
                }
                finally {
                    if (cCtx != null) {
                        TxChild.endChild(cCtx, null);
                        if (!ctx.closed && ctx.thread == cCtx.thread) {
                            TraceContextManager.attach(ctx);
                        }
                    }
                }
            }
        };
    }
}

