/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.tags;

import whatap.agent.Logger;
import whatap.agent.conf.ConfAgentTags;
import whatap.agent.tags.AgentMetaTags;
import whatap.agent.util.HttpClientUtil;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringUtil;

public class AwsTagHelper {
    static int remainFailAwsApi = 5;
    static long lastLoad;
    static boolean isSuccMemory;

    static void loadCloudTags() {
        String zone;
        if (!ConfAgentTags.agent_meta_tags_aws_enabled || remainFailAwsApi <= 0) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now < lastLoad + 300000L) {
            return;
        }
        lastLoad = now;
        String api = "http://169.254.169.254/latest/meta-data/";
        int conntectTimeOut = 3000;
        String apiResult = StringUtil.trim(HttpClientUtil.read(api, conntectTimeOut));
        if (apiResult == null || apiResult.length() == 0) {
            --remainFailAwsApi;
            if (isSuccMemory) {
                Logger.green("AWS meta-tags : fail to access " + api);
            }
            return;
        }
        remainFailAwsApi = 5;
        isSuccMemory = true;
        StringKeyLinkedMap<String> map = new StringKeyLinkedMap<String>();
        boolean hasTag = apiResult.indexOf("tags") >= 0;
        String instance_id = StringUtil.trim(HttpClientUtil.read(api + "instance-id", conntectTimeOut));
        if (instance_id != null && instance_id.length() > 0) {
            map.put("instasnce-id", instance_id);
        }
        if ((zone = StringUtil.trim(HttpClientUtil.read(api + "placement/availability-zone", conntectTimeOut))) != null && zone.length() > 0) {
            map.put("availability-zone", zone);
        }
        if (hasTag) {
            String[] tagNames = StringUtil.tokenizer(HttpClientUtil.read(api + "tags/instance", conntectTimeOut), " \n");
            if (tagNames != null) {
                for (String tag : tagNames) {
                    String tagValue = HttpClientUtil.read(api + "tags/instance/" + tag, conntectTimeOut);
                    map.put(tag, tagValue);
                }
            }
        } else if (AgentMetaTags.cloudMetaAndTag == null) {
            Logger.println("AWS", "skip load tags, may not be allowed to access the instance tag");
        }
        if (AgentMetaTags.cloudMetaAndTag == null) {
            Logger.yellow("AWS meta-tags : " + map);
        }
        AgentMetaTags.cloudMetaAndTag = map;
    }

    static {
        isSuccMemory = false;
    }
}

