/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.stat;

import java.util.ArrayList;
import java.util.Enumeration;
import whatap.agent.Logger;
import whatap.agent.conf.ConfMTrace;
import whatap.agent.conf.ConfStat;
import whatap.agent.data.DataPackSender;
import whatap.agent.data.ZipPackThread;
import whatap.lang.conf.ConfObserver;
import whatap.lang.pack.StatTransactionPack;
import whatap.lang.pack.StatTransactionPack1;
import whatap.lang.pack.TransactionRec;
import whatap.util.IntKeyLinkedMap;

public class StatTranx {
    private static StatTranx instance;
    private final int TABLE_MAX_SIZE = 5000;
    private final IntKeyLinkedMap<TransactionRec> table = new IntKeyLinkedMap<TransactionRec>(5001, 1.0f){

        @Override
        protected TransactionRec create(int hash) {
            if (this.isFull()) {
                return null;
            }
            TransactionRec rec = new TransactionRec();
            rec.setUrlHash(hash);
            return rec;
        }
    }.setMax(5000);

    public static synchronized StatTranx getInstance() {
        if (instance == null) {
            instance = new StatTranx();
        }
        return instance;
    }

    public StatTranx() {
        this.table.setMax(ConfStat.stat_tx_max_count);
        ConfObserver.add("StatTranx", new Runnable(){

            public void run() {
                StatTranx.this.table.setMax(ConfStat.stat_tx_max_count);
            }
        });
    }

    public TransactionRec getService(int hash) {
        return this.table.intern(hash);
    }

    protected void send(long now) {
        if (this.table.size() == 0) {
            return;
        }
        try {
            ArrayList<TransactionRec> out = new ArrayList<TransactionRec>(this.table.size() + 10);
            Enumeration<TransactionRec> en = this.table.values();
            while (en.hasMoreElements()) {
                out.add(en.nextElement());
            }
            this.table.clear();
            if (ConfMTrace.stat_service1_enabled || ConfStat.stat_service_version >= 4) {
                StatTransactionPack1 p;
                if (ConfStat.stat_1m_enabled) {
                    p = new StatTransactionPack1(2306);
                    p.dataStartTime = now - 60000L;
                } else {
                    p = ConfStat.stat_service_version >= 5 ? new StatTransactionPack1(2306) : new StatTransactionPack1();
                }
                p.time = now;
                p.spec = ConfMTrace.mtrace_spec_hash;
                p.version = ConfStat.stat_service_version;
                p.setRecords(out);
                if (ConfStat.stat_zip_enabled) {
                    ZipPackThread.getInstance().add(p);
                } else {
                    DataPackSender.send(p);
                }
            } else {
                if (ConfMTrace.stat_mtrace_enabled && ConfMTrace.mtrace_enabled && ConfMTrace.mtrace_spec_hash != 0) {
                    Logger.red("Please set 'stat_service1_enabled=true', currently 'MSA analysis' is fail");
                }
                StatTransactionPack p = new StatTransactionPack();
                p.time = now;
                p.setRecords(out);
                DataPackSender.send(p);
            }
        }
        catch (Exception e) {
            Logger.println("A203", 10, e.toString());
        }
    }

    protected void clear() {
        this.table.clear();
    }

    public int size() {
        return this.table.size();
    }
}

