/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.setup;

import whatap.agent.Configure;
import whatap.agent.SecurityMaster;
import whatap.agent.conf.ConfSysMon;
import whatap.agent.data.DataPackSender;
import whatap.agent.data.DataTextAgent;
import whatap.agent.logo.Logo;
import whatap.agent.net.TcpRequestMgr;
import whatap.agent.net.TcpSession;
import whatap.lang.pack.CounterPack1;
import whatap.util.DateUtil;
import whatap.util.HashUtil;
import whatap.util.JarUtil;
import whatap.util.KeyGen;
import whatap.util.SysJMX;
import whatap.util.ThreadUtil;

public class TestTwoAgent {
    public static void main(String[] args) {
        if (System.getProperty("whatap.home") == null) {
            String home = JarUtil.getJarLocation(TestTwoAgent.class);
            System.setProperty("whatap.home", home);
        }
        Configure conf = Configure.getInstance();
        Configure.getInstance().waitForInit();
        Configure.TCP_SESSION_ALLOWED = true;
        SecurityMaster.getInstance();
        System.setProperty("whatap.name", "NET-PING-{pid}");
        String oname1 = "agent1";
        int oid1 = HashUtil.hash(oname1);
        String oname2 = "agent2";
        int oid2 = HashUtil.hash(oname2);
        Logo.print();
        long seed = DateUtil.currentTime() ^ (long)SysJMX.getProcessPID() << 32;
        KeyGen.setSeed(seed);
        TcpRequestMgr.getInstance();
        TcpSession.getInstance().waitForConnection();
        SecurityMaster secuMaster = SecurityMaster.getInstance();
        int sleepMs = conf.realtime_interval;
        while (true) {
            TestTwoAgent.sleepx(sleepMs / 1000);
            DataTextAgent.getInstance().add((byte)13, oid1, oname1);
            DataTextAgent.getInstance().add((byte)13, oid2, oname2);
            CounterPack1 pw = new CounterPack1();
            pw.pcode = secuMaster.PCODE;
            pw.oid = oid1;
            pw.time = System.currentTimeMillis();
            pw.duration = 5;
            pw.active_tx_slice = new short[]{10, 10, 10};
            pw.tps = 10.0f;
            pw.resp_time = 100;
            pw.cpu = 50.0f;
            DataPackSender.sendTest(pw);
            System.out.println(DateUtil.timestamp(pw.time) + " send data tps=" + pw.tps + " oid=" + pw.oid);
            ThreadUtil.sleep(1000L);
            pw = new CounterPack1();
            pw.pcode = secuMaster.PCODE;
            pw.oid = oid2;
            pw.time = System.currentTimeMillis();
            pw.duration = 5;
            pw.active_tx_slice = new short[]{5, 5, 5};
            pw.tps = 15.0f;
            pw.resp_time = 100;
            pw.cpu = 30.0f * ConfSysMon.correction_factor_cpu;
            DataPackSender.sendTest(pw);
            System.out.println(DateUtil.timestamp(pw.time) + " send data tps=" + pw.tps + " oid=" + pw.oid);
        }
    }

    private static void sleepx(int sec) {
        ThreadUtil.sleep(1000L);
        long now;
        while ((now = DateUtil.currentTime() / 1000L) != now / (long)sec * (long)sec) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {
            }
        }
        return;
    }
}

